/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.raids;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.SoundHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.raids.PokemonSlot;
import com.pixelmonmod.pixelmon.client.gui.raids.RaidButton;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.RenderPixelmon;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.comm.packetHandlers.raids.RaidAction;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiRaidStart
extends GuiScreen {
    private static final ResourceLocation WATERMARK = new ResourceLocation("pixelmon", "textures/gui/raids/watermark.png");
    private static final ResourceLocation STAR = new ResourceLocation("pixelmon", "textures/gui/raids/star.png");
    private final ArrayList<RaidButton> buttons = new ArrayList();
    private final ArrayList<PokemonSlot> slots = new ArrayList();
    private RaidData raid;
    private EntityPixelmon pixelmon;
    private boolean shouldRefresh = false;
    private float fadeout = 0.0f;
    private int seconds = 0;
    private boolean closing = false;

    public GuiRaidStart(RaidData raid) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.setRaid(raid);
    }

    public void setRaid(RaidData raid) {
        this.setRaid(raid, null);
    }

    public void setRaid(RaidData raid, GuiRaidStart old) {
        this.raid = raid;
        if (old != null) {
            this.pixelmon = old.pixelmon;
        } else {
            Pokemon pokemon = Pixelmon.pokemonFactory.create(raid.getSpecies());
            if (raid.getForm() != null) {
                pokemon.setForm(raid.getForm());
            }
            pokemon.setGrowth(EnumGrowth.Ordinary);
            this.pixelmon = new EntityPixelmon((World)this.field_146297_k.field_71441_e);
            this.pixelmon.setPokemon(pokemon);
            this.pixelmon.setAnimation(AnimationType.IDLE);
            this.pixelmon.checkAnimation();
            this.pixelmon.initAnimation();
        }
        this.shouldRefresh = true;
    }

    private void initButtons() {
        this.buttons.clear();
        this.slots.clear();
        this.buttons.add(new RaidButton((double)this.field_146294_l / 1.45, (double)this.field_146295_m / 1.15 - (double)((int)((double)this.field_146295_m * 0.08 * 2.0)), 1.0, (float)this.field_146294_l / 4.0f, (float)this.field_146295_m / 17.0f, I18n.func_135052_a((String)"raid.button.solo", (Object[])new Object[0]), this.raid, button -> Pixelmon.network.sendToServer((IMessage)new RaidAction(this.raid.getDen(), 6))).setEnabled(!this.raid.isStarting()).setVisible(this.raid.isSolo()));
        this.buttons.add(new RaidButton((double)this.field_146294_l / 1.45, (double)this.field_146295_m / 1.15 - (double)((int)((double)this.field_146295_m * 0.08 * 2.0)), 1.0, (float)this.field_146294_l / 4.0f, (float)this.field_146295_m / 17.0f, I18n.func_135052_a((String)"raid.button.start", (Object[])new Object[0]), this.raid, button -> Pixelmon.network.sendToServer((IMessage)new RaidAction(this.raid.getDen(), 9))).setEnabled(!this.raid.isStarting() && this.raid.isOwner(this.field_146297_k.field_71439_g.func_110124_au())).setVisible(!this.raid.isSolo()));
        this.buttons.add(new RaidButton((double)this.field_146294_l / 1.45, (double)this.field_146295_m / 1.15 - (double)((int)((double)this.field_146295_m * 0.08)), 1.0, (float)this.field_146294_l / 4.0f, (float)this.field_146295_m / 17.0f, I18n.func_135052_a((String)"raid.button.multi", (Object[])new Object[0]), this.raid, button -> Pixelmon.network.sendToServer((IMessage)new RaidAction(this.raid.getDen(), 7))).setEnabled(!this.raid.isStarting()).setVisible(this.raid.isSolo()));
        this.buttons.add(new RaidButton((double)this.field_146294_l / 1.45, (double)this.field_146295_m / 1.15 - (double)((int)((double)this.field_146295_m * 0.08)), 1.0, (float)this.field_146294_l / 4.0f, (float)this.field_146295_m / 17.0f, I18n.func_135052_a((String)"raid.button.players", (Object[])new Object[]{this.raid.getPlayers().size()}), this.raid, button -> {}).setEnabled(false).setVisible(!this.raid.isSolo()));
        this.buttons.add(new RaidButton((double)this.field_146294_l / 1.45, (double)this.field_146295_m / 1.15, 1.0, (float)this.field_146294_l / 4.0f, (float)this.field_146295_m / 17.0f, I18n.func_135052_a((String)"raid.button.quit", (Object[])new Object[0]), this.raid, button -> {
            this.closing = true;
            Pixelmon.network.sendToServer((IMessage)new RaidAction(this.raid.getDen(), 8));
        }).setEnabled(!this.raid.isStarting()));
        float xGap = (float)this.field_146294_l * 0.075f;
        float yGap = (float)this.field_146295_m * 0.1f;
        ArrayList<RaidData.RaidPlayer> players = this.raid.getPlayers();
        for (int i = 0; i < 4; ++i) {
            RaidData.RaidPlayer player = players.size() > i ? players.get(i) : null;
            this.slots.add(new PokemonSlot(this.raid, (double)((float)this.field_146294_l / 1.1f), (double)((float)this.field_146295_m * 0.08f + yGap * (float)i), 2.0, player, button -> {}).setEnabled(false));
        }
        Pokemon[] party = ClientStorageManager.party.getAll();
        for (int i = 0; i < 6; ++i) {
            int xPos = i;
            boolean yPos = false;
            if (i >= 3) {
                xPos -= 3;
                yPos = true;
            }
            int index = i;
            this.slots.add(new PokemonSlot(this.raid, (double)((float)this.field_146294_l * 0.755f + xGap * (float)xPos), (double)((float)this.field_146295_m * 0.55f + yGap * (float)yPos), 2.0, party[index], button -> {
                if (party[index] != null && party[index].canBattle()) {
                    SoundHelper.playButtonPressSound();
                    Pixelmon.network.sendToServer((IMessage)new RaidAction(this.raid.getDen(), index));
                }
            }).setEnabled(!this.raid.isStarting()).setIndex(index));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.buttons.isEmpty() || this.shouldRefresh) {
            this.shouldRefresh = false;
            this.initButtons();
        }
        this.func_146276_q_();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.raid.isStarting()) {
            int seconds = 5 - this.raid.tick / 20;
            if (this.seconds != seconds) {
                SoundHelper.playSound(SoundEvents.field_193807_ew, 0.8f, 1.5f);
                this.seconds = seconds;
                this.fadeout = 255.0f;
            }
            this.raid.getDenEntity((World)this.field_146297_k.field_71441_e).map(den -> {
                Color c2 = den.getColorUIB();
                Color color = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), Math.max(0, (int)this.fadeout));
                GuiHelper.drawScaledCenteredString(String.valueOf(this.seconds), (float)this.field_146294_l * 0.8f, (float)this.field_146295_m * 0.13f, color.getRGB(), (float)this.field_146294_l * 0.25f);
                return true;
            }).orElseGet(() -> {
                Color color = new Color(226, 75, 66, Math.max(0, (int)this.fadeout));
                GuiHelper.drawScaledCenteredString(String.valueOf(this.seconds), (float)this.field_146294_l * 0.8f, (float)this.field_146295_m * 0.13f, color.getRGB(), (float)this.field_146294_l * 0.25f);
                return true;
            });
            this.fadeout -= 1.5f;
        }
        this.field_146297_k.field_71446_o.func_110577_a(STAR);
        int starSize = (int)((double)this.field_146294_l * 0.05);
        for (int i = 0; i < this.raid.getStars(); ++i) {
            GuiHelper.drawImage((double)starSize * 0.75 + (double)(i * starSize), (double)starSize * 0.6, starSize, starSize, 1.0f);
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.types);
        List<EnumType> types = this.pixelmon.getBaseStats().getTypeList();
        for (int i = 0; i < types.size(); ++i) {
            EnumType enumType = types.get(i);
            float x = enumType.textureX;
            float y = enumType.textureY;
            GuiHelper.drawImageQuad((double)starSize * 0.75 + (double)(i * starSize), starSize * 2, starSize, starSize, x / 1792.0f, y / 768.0f, (x + 240.0f) / 1792.0f, (y + 240.0f) / 768.0f, 1.0f);
        }
        for (RaidButton raidButton : this.buttons) {
            raidButton.draw(mouseX, mouseY, partialTicks);
        }
        RaidData.RaidPlayer player = this.raid.getPlayer(this.field_146297_k.field_71439_g.func_110124_au());
        for (PokemonSlot slot : this.slots) {
            slot.draw(mouseX, mouseY, this.field_146294_l, this.field_146295_m, player != null && player.index == slot.getIndex() || slot.isPlayer(this.field_146297_k.field_71439_g.func_110124_au()), partialTicks);
        }
        boolean bl = !this.raid.canAllCatch;
        String desc = I18n.func_135052_a((String)(bl ? "raid.lorespecial" : "raid.lore"), (Object[])new Object[]{4, 10});
        String[] split = desc.split("\\\\n");
        int lineCount = 0;
        for (String line : split) {
            GuiHelper.drawScaledString(line, (float)this.field_146294_l * 0.025f, (float)this.field_146295_m * (bl ? 0.82f : 0.88f) + (float)this.field_146295_m * 0.03f * (float)lineCount, 0xFFFFFF, (float)this.field_146295_m * 0.05f);
            ++lineCount;
        }
        GuiHelper.drawScaledCenteredString(I18n.func_135052_a((String)"raid.choose", (Object[])new Object[0]), (float)this.field_146294_l * 0.855f, (float)this.field_146295_m * 0.46f, -1, (float)this.field_146294_l * 0.03f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179142_g();
        GlStateManager.func_179126_j();
        GlStateManager.func_179109_b((float)((float)this.field_146294_l / 4.0f), (float)((float)this.field_146295_m / 4.0f * 3.0f), (float)300.0f);
        double referenceW = (float)this.field_146295_m / 3.0f;
        double referenceH = (float)this.field_146295_m / 3.0f;
        double dh = this.pixelmon.getBaseStats().getBoundsData().getHeight() - referenceH;
        double dw = this.pixelmon.getBaseStats().getBoundsData().getWidth() - referenceW;
        double scalar = 1.0;
        scalar = dh > dw ? referenceH / this.pixelmon.getBaseStats().getBoundsData().getHeight() : referenceW / this.pixelmon.getBaseStats().getBoundsData().getWidth();
        GlStateManager.func_179139_a((double)scalar, (double)scalar, (double)scalar);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        try {
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            Render entityClassRenderObject = renderManager.func_78715_a(EntityPixelmon.class);
            RenderPixelmon rp = (RenderPixelmon)entityClassRenderObject;
            rp.renderPixelmon(this.pixelmon, 0.0, 0.0, 0.0, partialTicks, true, 1, new float[]{0.0f, 0.0f, 0.0f, 1.0f});
            renderManager.field_78735_i = 180.0f;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        for (RaidButton button : this.buttons) {
            button.onClick(mouseX, mouseY, mouseButton);
        }
        for (PokemonSlot slot : this.slots) {
            slot.onClick(mouseX, mouseY, mouseButton);
        }
    }

    public void func_146276_q_() {
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -1596523265, -1866285374);
        int right = this.field_146294_l / 3 * 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)right, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.raid.getDenEntity((World)this.field_146297_k.field_71441_e).map(den -> {
            GuiHelper.drawGradientRect(-right, 0, 0.0f, 0, this.field_146295_m * 2, den.getColorUIA().getRGB(), den.getColorUIB().getRGB());
            Color c3 = den.getColorUIC();
            GlStateManager.func_179131_c((float)((float)c3.getRed() / 255.0f), (float)((float)c3.getGreen() / 255.0f), (float)((float)c3.getBlue() / 255.0f), (float)0.2f);
            return true;
        }).orElseGet(() -> {
            GuiHelper.drawGradientRect(-right, 0, 0.0f, 0, this.field_146295_m * 2, -37796, -5752007);
            GlStateManager.func_179131_c((float)0.8f, (float)0.0f, (float)0.0f, (float)0.2f);
            return true;
        });
        GlStateManager.func_179121_F();
        this.field_146297_k.field_71446_o.func_110577_a(WATERMARK);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)25.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GuiHelper.drawImage((float)this.field_146294_l / 6.0f, (float)(-this.field_146295_m) / 4.0f, (float)this.field_146294_l / 2.5f, (double)((float)this.field_146294_l / 2.5f) * 1.65591398, 2.0f);
        GlStateManager.func_179121_F();
    }

    public void func_73876_c() {
        this.pixelmon.getAnimationVariables().tick();
    }

    public void func_175273_b(Minecraft mc, int nw, int nh) {
        super.func_175273_b(mc, nw, nh);
        this.initButtons();
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (!this.closing) {
            if (!this.raid.isStarting()) {
                this.closing = true;
                Pixelmon.network.sendToServer((IMessage)new RaidAction(this.raid.getDen(), 8));
            } else {
                this.field_146297_k.func_152344_a(() -> this.field_146297_k.func_147108_a((GuiScreen)this));
            }
        }
    }

    public void func_146282_l() throws IOException {
        if (!this.raid.isStarting()) {
            super.func_146282_l();
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

