/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.models.smd;

import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.models.smd.SmdAnimation;
import com.pixelmonmod.pixelmon.client.models.smd.SmdModel;
import com.pixelmonmod.pixelmon.client.models.smd.ValveStudioModel;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.animation.IncrementingVariable;
import java.util.ArrayList;
import java.util.List;

public class SmdAnimationSequence {
    AnimationType animationType;
    List<SmdAnimation> sequence;
    int current = -1;

    public SmdAnimationSequence(AnimationType animType, List<SmdAnimation> animations, ValveStudioModel model) {
        this.animationType = animType;
        this.sequence = new ArrayList<SmdAnimation>();
        animations.forEach(animation -> this.sequence.add(new SmdAnimation((SmdAnimation)animation, model)));
    }

    public SmdAnimation next() {
        ++this.current;
        if (this.current >= this.sequence.size()) {
            this.current = 0;
        }
        if (this.sequence.isEmpty()) {
            return null;
        }
        return this.sequence.get(this.current);
    }

    public SmdAnimation current() {
        if (this.current < 0) {
            this.current = 0;
        }
        if (this.sequence.isEmpty()) {
            return null;
        }
        return this.sequence.get(this.current);
    }

    public void precalculate(SmdModel body) {
        ArrayList<SmdAnimation> precalculated = new ArrayList<SmdAnimation>();
        for (SmdAnimation animation : this.sequence) {
            if (precalculated.contains(animation)) continue;
            animation.precalculateAnimation(body);
            precalculated.add(animation);
        }
    }

    public SmdAnimation checkForIncrement(IncrementingVariable variable) {
        SmdAnimation current = this.current();
        if (this.sequence.size() > 1 && variable.value + variable.increment >= (float)current.totalFrames) {
            variable.value = 0.0f;
            return this.next();
        }
        return current;
    }

    public SmdAnimation checkForFinalFrame(int frame) {
        if (frame > this.current().totalFrames) {
            return this.next();
        }
        return this.current();
    }
}

