/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.particle.systems;

import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystem;
import com.pixelmonmod.pixelmon.client.particle.particles.Blob;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class UltraWormhole
extends ParticleSystem {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        double posZ;
        double posY;
        int i;
        int spokes;
        GlStateManager.func_179094_E();
        long time = (long)args[1];
        long mod100 = time % 15L;
        double yaw = args[2] * (Math.PI / 180);
        double pitch = args[3] * (Math.PI / 180);
        EntityPlayerSP viewpoint = mc.func_175606_aa() == null ? mc.field_71439_g : mc.func_175606_aa();
        float tx = (float)(viewpoint.field_70169_q + (viewpoint.field_70165_t - viewpoint.field_70169_q) * (double)mc.func_184121_ak());
        float ty = (float)(viewpoint.field_70167_r + (viewpoint.field_70163_u - viewpoint.field_70167_r) * (double)mc.func_184121_ak());
        float tz = (float)(viewpoint.field_70166_s + (viewpoint.field_70161_v - viewpoint.field_70166_s) * (double)mc.func_184121_ak());
        GlStateManager.func_179090_x();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179109_b((float)(-tx), (float)(-ty), (float)(-tz));
        GL11.glEnable((int)2848);
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double[] cx = new double[9];
        double[] cy = new double[9];
        double[] cz = new double[9];
        double[] coords = new double[768];
        int coordsIndex = 0;
        for (spokes = 0; spokes < 16; ++spokes) {
            double zFront = 0.0;
            double zBack = 0.1;
            float radiusDecay = 0.35f;
            double radius = 3.25;
            double dx = Math.cos(0.39269908169872414 * (double)spokes);
            double dy = Math.sin(0.39269908169872414 * (double)spokes);
            for (int segments = 0; segments < 8; ++segments) {
                double radius2 = radius - (double)radiusDecay;
                coords[coordsIndex++] = x + dx * radius;
                coords[coordsIndex++] = y + dy * radius;
                coords[coordsIndex++] = z + zFront;
                coords[coordsIndex++] = x + dx * radius2;
                coords[coordsIndex++] = y + dy * radius2;
                coords[coordsIndex++] = z + zBack;
                if (segments == 0) {
                    cx[segments] = radius;
                    cy[segments] = radius;
                    cz[segments] = zFront;
                }
                if (spokes == 1) {
                    cx[segments + 1] = radius2;
                    cy[segments + 1] = radius2;
                    cz[segments + 1] = zBack;
                }
                zFront = zBack;
                zBack += 0.2 * (double)(segments + 1);
                radius -= (double)radiusDecay;
                radiusDecay -= 0.02f;
            }
        }
        coordsIndex = 0;
        for (spokes = 0; spokes < 16; ++spokes) {
            GL11.glHint((int)3154, (int)4354);
            GL11.glBegin((int)3);
            for (int segments = 0; segments < 8; ++segments) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)segments / 9.0f));
                for (int i2 = 0; i2 < 2; ++i2) {
                    this.rotatePointAndDraw(coords[coordsIndex++], coords[coordsIndex++], coords[coordsIndex++], x, y, z, yaw, pitch);
                }
            }
            GL11.glEnd();
        }
        for (i = 0; i < 9; ++i) {
            if (i <= 1) continue;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)i / 9.0f * (i == 2 ? (float)mod100 / 15.0f * 2.0f : 1.0f)));
            GL11.glHint((int)3154, (int)4354);
            GL11.glBegin((int)3);
            double ox = cx[i];
            double oy = cx[i];
            double oz = cz[i];
            if (i != 8) {
                ox = cx[i] + (cx[i + 1] - cx[i]) * ((double)mod100 / 15.0);
                oy = cy[i] + (cy[i + 1] - cy[i]) * ((double)mod100 / 15.0);
                oz = cz[i] + (cz[i + 1] - cz[i]) * ((double)mod100 / 15.0);
            }
            for (int spokes2 = 0; spokes2 < 17; ++spokes2) {
                double theta = 0.39269908169872414 * (double)(spokes2 == 16 ? 0 : spokes2);
                double dx = Math.cos(theta);
                double dy = Math.sin(theta);
                this.rotatePointAndDraw(x + ox * dx, y + oy * dy, z + oz, x, y, z, yaw, pitch);
            }
            GL11.glEnd();
        }
        for (i = 0; i < 9; ++i) {
            GlStateManager.func_179129_p();
            if (i != 8) {
                for (int spokes3 = 0; spokes3 < 16; ++spokes3) {
                    int colorPattern = (int)args[0];
                    int colorSpeed = 120;
                    int colorDeterminant = ((int)args[1] + (int)w.func_82737_E() % colorSpeed) % colorSpeed + i * 4;
                    GlStateManager.func_179131_c((float)this.calcRed(colorPattern, colorSpeed, colorDeterminant), (float)this.calcGreen(colorPattern, colorSpeed, colorDeterminant), (float)this.calcBlue(colorPattern, colorSpeed, colorDeterminant), (float)(1.0f - 0.11f * (float)(i + 1)));
                    GL11.glHint((int)3155, (int)4354);
                    GL11.glBegin((int)7);
                    double theta1 = 0.39269908169872414 * (double)spokes3;
                    double dx1 = Math.cos(theta1);
                    double dy1 = Math.sin(theta1);
                    double theta2 = 0.39269908169872414 * (double)(spokes3 + 1 == 16 ? 0 : spokes3 + 1);
                    double dx2 = Math.cos(theta2);
                    double dy2 = Math.sin(theta2);
                    this.rotatePointAndDraw(x + cx[7 - i] * dx1, y + cy[7 - i] * dy1, z + cz[7 - i], x, y, z, yaw, pitch);
                    this.rotatePointAndDraw(x + cx[7 - i] * dx2, y + cy[7 - i] * dy2, z + cz[7 - i], x, y, z, yaw, pitch);
                    this.rotatePointAndDraw(x + cx[7 - i + 1] * dx2, y + cy[7 - i + 1] * dy2, z + cz[7 - i + 1], x, y, z, yaw, pitch);
                    this.rotatePointAndDraw(x + cx[7 - i + 1] * dx1, y + cy[7 - i + 1] * dy1, z + cz[7 - i + 1], x, y, z, yaw, pitch);
                    GL11.glEnd();
                }
            }
            GlStateManager.func_179089_o();
        }
        GlStateManager.func_187441_d((float)1.0f);
        long seed = time - mod100 + (long)x + (long)y + (long)z;
        Random rand = new Random(seed);
        for (int bolts = 0; bolts < 3; ++bolts) {
            if (mod100 >= 7L) continue;
            int forks = rand.nextInt(5) + 5;
            double dx = x;
            double dy = y;
            double dz = z + 5.5;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - 0.14285715f * (float)mod100));
            for (int i3 = 0; i3 < forks; ++i3) {
                GL11.glHint((int)3154, (int)4354);
                GL11.glBegin((int)3);
                this.rotatePointAndDraw(dx, dy, dz, x, y, z, yaw, pitch);
                this.rotatePointAndDraw(dx += (rand.nextDouble() * 2.0 - 1.0) / 2.0, dy += rand.nextDouble() * 2.0 - 1.0, dz -= rand.nextDouble() * 2.0, x, y, z, yaw, pitch);
                GL11.glEnd();
                if (i3 <= 4) continue;
                GL11.glHint((int)3154, (int)4354);
                GL11.glBegin((int)3);
                this.rotatePointAndDraw(dx, dy, dz, x, y, z, yaw, pitch);
                this.rotatePointAndDraw(dx + (rand.nextDouble() * 2.0 - 1.0) / 2.0, dy + rand.nextDouble() * 2.0 - 1.0, dz + rand.nextDouble() * 2.0, x, y, z, yaw, pitch);
                GL11.glEnd();
            }
        }
        double rad = 0.85;
        double posX = w.field_73012_v.nextDouble() * (rad * 2.0) - rad;
        if (Math.sqrt(posX * posX + (posY = w.field_73012_v.nextDouble() * (rad * 2.0) - rad) * posY + (posZ = w.field_73012_v.nextDouble() * (rad * 2.0) - rad) * posZ) <= rad) {
            double[] center = this.rotatePoint(x, y, z + 5.0, x, y, z, yaw, pitch);
            mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(w, center[0] + posX, center[1] + posY, center[2] + posZ, 0.0, 0.0, 0.0, new Blob(0.0, 0.0, 0.0, 0.0, 0.0f, 0.0f, 0.0f, true, 10, (int)args[0], 1.7f)));
        }
        GL11.glDisable((int)2848);
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
    }

    private double[] rotatePoint(double px, double py, double pz, double cx, double cy, double cz, double yaw, double pitch) {
        double rx = Math.cos(yaw) * (px - cx) - Math.sin(yaw) * (pz - cz) + cx;
        double rz = Math.sin(yaw) * (px - cx) + Math.cos(yaw) * (pz - cz) + cz;
        double ry = Math.sin(pitch) * (rz - cz) + Math.cos(pitch) * (py - cy) + cy;
        rz = Math.cos(pitch) * (rz - cz) - Math.sin(pitch) * (py - cy) + cz;
        return new double[]{rx, ry, rz};
    }

    private void rotatePointAndDraw(double px, double py, double pz, double cx, double cy, double cz, double yaw, double pitch) {
        double[] points = this.rotatePoint(px, py, pz, cx, cy, cz, yaw, pitch);
        GL11.glVertex3d((double)points[0], (double)points[1], (double)points[2]);
    }

    private float calcChangingColor(int colorSpeed, int colorDeterminant) {
        float c1 = 1.0f / (float)colorSpeed;
        float c2 = c1 * (float)colorDeterminant;
        if (c2 > 0.5f) {
            float c3 = c2 - 0.5f;
            c2 -= c3 * 2.0f;
        }
        return c2;
    }

    private float calcRed(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 0: 
            case 1: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 2: 
            case 3: {
                return 0.2f;
            }
            case 4: 
            case 5: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    private float calcGreen(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 2: 
            case 4: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 0: 
            case 5: {
                return 0.2f;
            }
            case 1: 
            case 3: {
                return 0.7f;
            }
        }
        return 0.0f;
    }

    private float calcBlue(int colorPattern, int colorSpeed, int colorDeterminant) {
        switch (colorPattern) {
            case 3: 
            case 5: {
                return this.calcChangingColor(colorSpeed, colorDeterminant);
            }
            case 1: 
            case 4: {
                return 0.2f;
            }
            case 0: 
            case 2: {
                return 0.7f;
            }
        }
        return 0.0f;
    }
}

