/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.render.IHasTexture;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;

public class EmissiveTextures
implements ISelectiveResourceReloadListener {
    private static final Map<ResourceLocation, Boolean> existsCache = new WeakHashMap<ResourceLocation, Boolean>(64);
    private static float lightMapX;
    private static float lightMapY;
    private static boolean isRendering;

    public static boolean hasEmissive(IHasTexture pixelmon) {
        ResourceLocation location = EmissiveTextures.getEmissive(pixelmon.getTexture());
        if (location == null) {
            return false;
        }
        if (existsCache.containsKey(location)) {
            return existsCache.getOrDefault(location, false);
        }
        if (Pixelmon.proxy.resourceLocationExists(location)) {
            existsCache.put(location, true);
            return true;
        }
        existsCache.put(location, false);
        return false;
    }

    public static boolean emissiveExists(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        if (existsCache.containsKey(rl)) {
            return existsCache.getOrDefault(rl, null);
        }
        if (Pixelmon.proxy.resourceLocationExists(rl)) {
            existsCache.put(rl, true);
            return true;
        }
        return false;
    }

    public static void startEmissive() {
        isRendering = true;
        lightMapX = OpenGlHelper.lastBrightnessX;
        lightMapY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)lightMapY);
    }

    public static void stopEmissive() {
        isRendering = false;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapX, (float)lightMapY);
        lightMapX = 0.0f;
        lightMapY = 0.0f;
    }

    public static boolean isRendering() {
        return isRendering;
    }

    public static ResourceLocation getEmissive(ResourceLocation normal) {
        if ("pixelmon".equals(normal.func_110624_b())) {
            String original = normal.func_110623_a();
            original = original.replace("pokemon-shiny/", "");
            int split = original.lastIndexOf("/") + 1;
            String path = original.substring(0, split);
            String file = original.substring(split);
            return new ResourceLocation("pixelmon", path + "emissive/" + file);
        }
        return null;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.TEXTURES)) {
            existsCache.clear();
        }
    }
}

