/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render;

import com.pixelmonmod.pixelmon.battles.raids.RaidData;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.RenderPixelmon;
import com.pixelmonmod.pixelmon.entities.EntityDen;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.awt.Color;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderDen
extends RenderLivingBase<EntityDen> {
    private static final GenericModelHolder<GenericSmdModel> model = new GenericModelHolder("blocks/den/raid_den.pqc");
    private static final ResourceLocation texture = new ResourceLocation("pixelmon", "textures/blocks/den/raid_den.png");

    public RenderDen(RenderManager renderManagerIn) {
        super(renderManagerIn, model.getModel(), 0.0f);
    }

    public boolean shouldRender(EntityDen livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    @Nullable
    protected ResourceLocation getEntityTexture(EntityDen entity) {
        return null;
    }

    public void doRender(EntityDen entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!entity.isBaseHidden()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            this.renderModel(model, texture);
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void renderMultipass(EntityDen entity, double x, double y, double z, float entityYaw, float partialTicks) {
        Optional<RaidData> optional = entity.getData();
        boolean decoration = entity.isDecoration();
        boolean raid = optional.isPresent();
        boolean animate = entity.isAnimating();
        int beams = entity.getBeams();
        boolean beamOn = entity.isBeamOn();
        boolean beamTaper = entity.isBeamTaper();
        float beamLength = entity.getBeamLength();
        float beamWidth = entity.getBeamWidth();
        if (raid || decoration) {
            ++entity.ticker;
            float f = ((float)entity.ticker + partialTicks) / 8.0f;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            Entity view = Minecraft.func_71410_x().func_175606_aa();
            if (view == null) {
                view = Minecraft.func_71410_x().field_71439_g;
            }
            float tx = (float)(view.field_70169_q + (view.field_70165_t - view.field_70169_q) * (double)partialTicks);
            float tz = (float)(view.field_70166_s + (view.field_70161_v - view.field_70166_s) * (double)partialTicks);
            float angle = (float)(Math.atan2(entity.field_70161_v - (double)tz, entity.field_70165_t - (double)tx) * 180.0 / Math.PI) + 90.0f;
            float dist = entity.func_70032_d(view) - 20.0f;
            float alpha = Math.min(1.0f, 1.0f - dist / 30.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)(-angle + 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179117_G();
            RenderHelper.func_74518_a();
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179141_d();
            GlStateManager.func_179089_o();
            if (raid || beamOn) {
                double rXa = beamWidth <= 0.0f ? -0.3 : (double)(-beamWidth);
                double rXb = beamWidth <= 0.0f ? 0.3 : (double)(-beamWidth);
                double rY = beamLength;
                double rZa = beamWidth <= 0.0f ? -0.3 : (double)(-beamWidth);
                double rZb = beamWidth <= 0.0f ? 0.3 : (double)beamWidth;
                double[] rots = new double[]{Math.sin((double)f * 0.13) * 50.0, Math.sin((double)(-f) * 0.07) * 65.0, Math.cos((double)f * 0.1) * 55.0, Math.sin((double)(-f) * 0.14) * 50.0, Math.sin((double)f * 0.11) * 75.0, Math.cos((double)(-f) * 0.04) * 70.0};
                double[] sizes = new double[]{1.0, 0.75, 0.55, 0.4, 0.2, 0.1};
                Color color = entity.getColorRGBA();
                for (int i = 0; i < Math.min(5, raid ? optional.get().getStars() + 1 : beams); ++i) {
                    double size = sizes[i];
                    GlStateManager.func_179094_E();
                    if (animate) {
                        size += Math.abs(rots[i]) * 0.002;
                    } else {
                        GlStateManager.func_179114_b((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    GlStateManager.func_179137_b((double)((double)i * -0.01), (double)0.0, (double)0.0);
                    bufferbuilder.func_181668_a(beamTaper ? 4 : 7, DefaultVertexFormats.field_181706_f);
                    bufferbuilder.func_181662_b(rXa * size, 0.05, rZa * size).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                    bufferbuilder.func_181662_b(rXb * size, 0.05, rZb * size).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                    if (beamTaper) {
                        bufferbuilder.func_181662_b((rXb + rXa) / 2.0 * size, rY * 2.0, (rZb + rZa) / 2.0 * size).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 0).func_181675_d();
                    } else {
                        bufferbuilder.func_181662_b(rXb * size, rY * 2.0, rZb * size).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                        bufferbuilder.func_181662_b(rXa * size, rY * 2.0, rZa * size).func_181669_b(color.getRed(), color.getGreen(), color.getBlue(), 255).func_181675_d();
                    }
                    tessellator.func_78381_a();
                    GlStateManager.func_179121_F();
                }
            }
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderHelper.func_74519_b();
            if (alpha > 0.0f) {
                entity.getDisplay().ifPresent(display -> {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)0.0, (double)1.5, (double)0.0);
                    GlStateManager.func_179137_b((double)-1.25, (double)0.0, (double)1.25);
                    GlStateManager.func_179139_a((double)1.5, (double)1.5, (double)1.5);
                    GlStateManager.func_179114_b((float)(f / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
                    try {
                        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
                        Render entityClassRenderObject = renderManager.func_78715_a(EntityPixelmon.class);
                        RenderPixelmon rp = (RenderPixelmon)entityClassRenderObject;
                        rp.renderPixelmon((EntityPixelmon)display, 0.0, 0.0, 0.0, partialTicks, true, 1, new float[]{0.0f, 0.0f, 0.0f, alpha});
                        renderManager.field_78735_i = 180.0f;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179121_F();
                });
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179145_e();
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
        }
    }

    public void renderModel(GenericModelHolder<GenericSmdModel> model, ResourceLocation texture) {
        GlStateManager.func_179094_E();
        this.func_110776_a(texture);
        float scale = 0.6f;
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        model.render();
        GlStateManager.func_179121_F();
    }
}

