/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.pixelmonmod.pixelmon.client.models.PixelmonModelRegistry;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity2Client;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumNoForm;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.ItemBadge;
import com.pixelmonmod.pixelmon.items.ItemBadgeCase;
import com.pixelmonmod.pixelmon.items.ItemPixelmonSprite;
import com.pixelmonmod.pixelmon.items.ItemSymbol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderArmorStand;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ArmorStandLayerEquippables
implements LayerRenderer<EntityArmorStand> {
    private final RenderArmorStand renderer;
    private final Map<String, GenericModelHolder<GenericSmdModel>> equippableModels = new HashMap<String, GenericModelHolder<GenericSmdModel>>();
    private static final float[][] bcTranslations = new float[][]{{-0.225f, -0.085f}, {-0.225f, -0.11f}, {-0.225f, -0.145f}, {-0.225f, -0.175f}};
    private static final double[][] bcPositions = new double[][]{{0.08, 0.13}, {0.15, 0.13}, {0.08, 0.2}, {0.15, 0.2}, {0.08, 0.27}, {0.15, 0.27}, {0.08, 0.34}, {0.15, 0.34}};

    public ArmorStandLayerEquippables(RenderArmorStand renderer) {
        this.renderer = renderer;
        this.equippableModels.put("safety_goggles", new GenericModelHolder("playeritems/equippables/safety_goggles.pqc"));
    }

    public static boolean hasEquippables(EntityLivingBase entity) {
        for (ItemStack stack : entity.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable)) continue;
            return true;
        }
        return false;
    }

    public void doRenderLayer(EntityArmorStand player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ModelRenderer left = this.renderer.func_177087_b().field_178724_i;
        ModelRenderer body = this.renderer.func_177087_b().field_78115_e;
        ModelRenderer head = this.renderer.func_177087_b().field_78116_c;
        HashSet<IEquippable> equippables = new HashSet<IEquippable>();
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable)) continue;
            equippables.add((IEquippable)stack.func_77973_b());
        }
        if (!equippables.isEmpty()) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71424_I.func_76320_a("layer_equippables");
            for (IEquippable equippable : equippables) {
                ItemStack stack;
                GlStateManager.func_179094_E();
                Item item = equippable.getEquippableItem();
                if (item == PixelmonItemsHeld.safetyGoggles) {
                    GenericModelHolder<GenericSmdModel> model = this.equippableModels.get(equippable.getEquippableModelKey());
                    ResourceLocation texture = equippable.getEquippableTexture();
                    mc.field_71446_o.func_110577_a(texture);
                    if (player.func_70093_af()) {
                        GlStateManager.func_179109_b((float)0.0f, (float)-0.73f, (float)0.0f);
                    }
                    head.func_78794_c(1.0f);
                    GlStateManager.func_179109_b((float)head.field_82906_o, (float)head.field_82908_p, (float)head.field_82907_q);
                    GlStateManager.func_179109_b((float)0.0f, (float)1.54f, (float)0.0f);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179109_b((float)0.0f, (float)-2.74f, (float)-0.15f);
                    GlStateManager.func_179139_a((double)0.62, (double)0.62, (double)0.62);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    model.render();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else if (item instanceof ItemBadge || item instanceof ItemSymbol) {
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179137_b((double)0.1, (double)0.2, (double)-0.11);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    if (player.func_70093_af()) {
                        GlStateManager.func_179109_b((float)0.0f, (float)-0.22f, (float)-0.11f);
                        GlStateManager.func_179114_b((float)((float)((double)(body.field_78795_f * 180.0f) / Math.PI)), (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                    float s = 0.15f;
                    GlStateManager.func_179152_a((float)s, (float)s, (float)1.0f);
                    Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)player, new ItemStack(equippable.getEquippableItem()), ItemCameraTransforms.TransformType.NONE);
                    GlStateManager.func_179145_e();
                } else if (item instanceof ItemBadgeCase) {
                    ItemBadgeCase.BadgeCase badgeCase;
                    stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
                    if (stack.func_77942_o() && (badgeCase = ItemBadgeCase.BadgeCase.readFromItemStack(stack)) != null) {
                        GlStateManager.func_179140_f();
                        int i = 0;
                        for (ItemStack badge : badgeCase.badges) {
                            GlStateManager.func_179094_E();
                            double[] pos = bcPositions[i];
                            GlStateManager.func_179137_b((double)pos[0], (double)pos[1], (double)-0.11);
                            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                            if (player.func_70093_af()) {
                                float[] translation = bcTranslations[i / 2];
                                GlStateManager.func_179109_b((float)0.0f, (float)translation[0], (float)translation[1]);
                                GlStateManager.func_179114_b((float)((float)((double)(body.field_78795_f * 180.0f) / Math.PI)), (float)1.0f, (float)0.0f, (float)0.0f);
                            }
                            float s = 0.075f;
                            GlStateManager.func_179152_a((float)s, (float)s, (float)1.0f);
                            Minecraft.func_71410_x().func_175597_ag().func_178099_a((EntityLivingBase)player, badge, ItemCameraTransforms.TransformType.NONE);
                            GlStateManager.func_179121_F();
                            ++i;
                        }
                        GlStateManager.func_179145_e();
                    }
                } else if (item instanceof ItemPixelmonSprite && (stack = player.func_184582_a(EntityEquipmentSlot.HEAD)).func_77942_o() && stack.func_77978_p().func_74765_d("ndex") == EnumSpecies.Joltik.getNationalPokedexInteger()) {
                    ModelBase model = PixelmonModelRegistry.getModel(EnumSpecies.Joltik, EnumNoForm.NoForm);
                    ResourceLocation texture = Entity2Client.getTextureFor(EnumSpecies.Joltik, EnumNoForm.NoForm, Gender.Male, "", stack.func_77978_p().func_74767_n("Shiny"));
                    if (model != null && texture != null) {
                        mc.field_71446_o.func_110577_a(texture);
                        if (player.func_70093_af()) {
                            GlStateManager.func_179109_b((float)0.0f, (float)-0.73f, (float)0.0f);
                        }
                        head.func_78794_c(1.0f);
                        GlStateManager.func_179109_b((float)head.field_82906_o, (float)head.field_82908_p, (float)head.field_82907_q);
                        GlStateManager.func_179109_b((float)0.0f, (float)-1.2f, (float)-0.07f);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179091_B();
                        double sf = 0.03;
                        GlStateManager.func_179139_a((double)sf, (double)sf, (double)sf);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 1.0f);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                }
                GlStateManager.func_179121_F();
            }
            mc.field_71424_I.func_76319_b();
        }
    }

    public boolean func_177142_b() {
        return true;
    }
}

