/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.pixelmonmod.pixelmon.client.models.ModelHolder;
import com.pixelmonmod.pixelmon.client.models.blocks.GenericSmdModel;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PixelmonLayerHead
implements LayerRenderer<EntityPlayer> {
    private final ResourceLocation TOP_HAT_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/tophat.png");
    private final ResourceLocation FEZ_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/fez.png");
    private final ResourceLocation FEDORA_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/fedora.png");
    private final ResourceLocation TRAINERHAT_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/trainerhat.png");
    private final ResourceLocation PIKAHOOD_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/pikahood.png");
    private final ResourceLocation EEVEEHOOD_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/eeveehood.png");
    private final ResourceLocation SCORHOOD_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/scorhood.png");
    private final ResourceLocation ESPEON_SCARF_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/espeon_scarf.png");
    private final ResourceLocation FLAREON_SCARF_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/flareon_scarf.png");
    private final ResourceLocation GLACEON_SCARF_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/glaceon_scarf.png");
    private final ResourceLocation JOLTEON_SCARF_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/jolteon_scarf.png");
    private final ResourceLocation LEAFEON_SCARF_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/leafeon_scarf.png");
    private final ResourceLocation SYLVEON_SCARF_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/sylveon_scarf.png");
    private final ResourceLocation UMBREON_SCARF_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/umbreon_scarf.png");
    private final ResourceLocation VAPOREON_SCARF_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/vaporeon_scarf.png");
    private final ResourceLocation WIKI_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/grad_cap.png");
    private final ResourceLocation GOLD_MONOCLE_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/monocle_gold.png");
    private final ResourceLocation BLACK_MONOCLE_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/monocle_black.png");
    private final ResourceLocation QUAGSIRE_MASK_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/quagsire_mask.png");
    private final ResourceLocation QUARANTINE_MASK_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/quarantine_mask.png");
    private final ResourceLocation WELKIN_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/hats/welkin.png");
    private final ModelHolder<GenericSmdModel> TOPHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/tophat.pqc");
    private final ModelHolder<GenericSmdModel> FEZ_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/fez.pqc");
    private final ModelHolder<GenericSmdModel> FEDORA_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/fedora.pqc");
    private final ModelHolder<GenericSmdModel> TRAINERHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/trainerhat.pqc");
    private final ModelHolder<GenericSmdModel> PIKAHOOD_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/pikahood.pqc");
    private final ModelHolder<GenericSmdModel> ESPEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/espeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> FLAREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/flareon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> GLACEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/glaceon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> JOLTEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/jolteon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> LEAFEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/leafeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> SYLVEON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sylveon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> UMBREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/umbreon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> VAPOREON_SCARF = new GenericModelHolder<GenericSmdModel>("playeritems/hats/vaporeon_scarf.pqc");
    private final ModelHolder<GenericSmdModel> WIKI_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/grad_cap.pqc");
    private final ModelHolder<GenericSmdModel> MONOCLE_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/monocle.pqc");
    private final ModelHolder<GenericSmdModel> QUAGSIRE_MASK_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/quagsire_mask.pqc");
    private final ModelHolder<GenericSmdModel> QUARANTINE_MASK_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/quarantine_mask.pqc");
    private final ModelHolder<GenericSmdModel> WELKIN_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/welkin.pqc");
    private final ResourceLocation SPHEAL_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/sphealhat.png");
    private final ResourceLocation SHINYSPHEAL_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/shinysphealhat.png");
    private final ResourceLocation SPHEAL_STITCHED_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/sphealhatstitches.png");
    private final ResourceLocation SHINYSPHEAL_STICHED_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/shinysphealhatstitches.png");
    private final ModelHolder<GenericSmdModel> SPHEALHAT_MODEL = new GenericModelHolder<GenericSmdModel>("playeritems/hats/sphealhat.pqc");
    private ModelRenderer head;
    private final RenderPlayer renderer;
    private final ResourceLocation locationCapBG;
    private final DynamicTexture capBG;

    public PixelmonLayerHead(RenderPlayer renderer) {
        this.renderer = renderer;
        this.capBG = new DynamicTexture(1, 1);
        this.capBG.func_110565_c()[0] = -1;
        this.capBG.func_110564_a();
        this.locationCapBG = Minecraft.func_71410_x().func_110434_K().func_110578_a("capBG", this.capBG);
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        PixelExtrasData extras = PlayerExtraDataStore.get(player);
        if (!extras.isReady() || player.func_82150_aj()) {
            return;
        }
        this.head = this.renderer.func_177087_b().field_78116_c;
        Minecraft.func_71410_x().field_71424_I.func_76320_a("layer_hat");
        if (extras.isEnabled(PixelExtrasData.Category.HAT) && extras.getHatType() != PixelExtrasData.HatType.NONE) {
            this.renderHat(player, extras, partialTicks);
        }
        if (extras.isEnabled(PixelExtrasData.Category.MONOCLE) && (extras.getMonocleType() == PixelExtrasData.MonocleType.QUAGSIRE_MASK || extras.getMonocleType() == PixelExtrasData.MonocleType.QUARANTINE_MASK)) {
            this.renderMask(player, extras, partialTicks);
        } else if (extras.isEnabled(PixelExtrasData.Category.MONOCLE) && extras.getMonocleType() != PixelExtrasData.MonocleType.NONE) {
            this.renderMonocle(player, extras, partialTicks);
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public void renderHat(EntityPlayer player, PixelExtrasData data, float partialTicks) {
        ResourceLocation path;
        ModelHolder<GenericSmdModel> hat;
        block0 : switch (data.getHatType()) {
            case TOP_HAT: {
                hat = this.TOPHAT_MODEL;
                path = this.TOP_HAT_TEXTURE;
                break;
            }
            case FEZ: {
                hat = this.FEZ_MODEL;
                path = this.FEZ_TEXTURE;
                break;
            }
            case FEDORA: {
                hat = this.FEDORA_MODEL;
                path = this.FEDORA_TEXTURE;
                break;
            }
            case TRAINER_CAP: {
                hat = this.TRAINERHAT_MODEL;
                path = this.TRAINERHAT_TEXTURE;
                break;
            }
            case PIKA_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.PIKAHOOD_TEXTURE;
                break;
            }
            case EEVEE_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.EEVEEHOOD_TEXTURE;
                break;
            }
            case SCOR_HOOD: {
                hat = this.PIKAHOOD_MODEL;
                path = this.SCORHOOD_TEXTURE;
                break;
            }
            case WIKI: {
                hat = this.WIKI_MODEL;
                path = this.WIKI_TEXTURE;
                break;
            }
            case WELKIN_HAT: {
                hat = this.WELKIN_MODEL;
                path = this.WELKIN_TEXTURE;
                break;
            }
            case ESPEON_SCARF: {
                hat = this.ESPEON_SCARF;
                path = this.ESPEON_SCARF_TEXTURE;
                break;
            }
            case FLAREON_SCARF: {
                hat = this.FLAREON_SCARF;
                path = this.FLAREON_SCARF_TEXTURE;
                break;
            }
            case GLACEON_SCARF: {
                hat = this.GLACEON_SCARF;
                path = this.GLACEON_SCARF_TEXTURE;
                break;
            }
            case JOLTEON_SCARF: {
                hat = this.JOLTEON_SCARF;
                path = this.JOLTEON_SCARF_TEXTURE;
                break;
            }
            case LEAFEON_SCARF: {
                hat = this.LEAFEON_SCARF;
                path = this.LEAFEON_SCARF_TEXTURE;
                break;
            }
            case SYLVEON_SCARF: {
                hat = this.SYLVEON_SCARF;
                path = this.SYLVEON_SCARF_TEXTURE;
                break;
            }
            case UMBREON_SCARF: {
                hat = this.UMBREON_SCARF;
                path = this.UMBREON_SCARF_TEXTURE;
                break;
            }
            case VAPOREON_SCARF: {
                hat = this.VAPOREON_SCARF;
                path = this.VAPOREON_SCARF_TEXTURE;
                break;
            }
            case SPHEAL_HAT: {
                hat = this.SPHEALHAT_MODEL;
                switch (data.getSphealType()) {
                    default: {
                        path = this.SPHEAL_TEXTURE;
                        break block0;
                    }
                    case SHINY: {
                        path = this.SHINYSPHEAL_TEXTURE;
                        break block0;
                    }
                    case STITCHED: {
                        path = this.SPHEAL_STITCHED_TEXTURE;
                        break block0;
                    }
                    case SHINY_STITCHED: 
                }
                path = this.SHINYSPHEAL_STICHED_TEXTURE;
                break;
            }
            default: {
                return;
            }
        }
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.73f, (float)0.0f);
        }
        this.head.func_78794_c(1.0f);
        GlStateManager.func_179109_b((float)this.head.field_82906_o, (float)this.head.field_82908_p, (float)this.head.field_82907_q);
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        if (data.getHatType() == PixelExtrasData.HatType.TRAINER_CAP) {
            if (data.getColours(PixelExtrasData.Category.HAT)[0] == -1) {
                this.renderer.func_110776_a(this.locationCapBG);
                int i = player.field_70173_aa / 25 + player.func_145782_y();
                int j = EnumDyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f7 = ((float)(player.field_70173_aa % 25) + partialTicks) / 25.0f;
                float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
                float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
                float r = afloat1[0] * (1.0f - f7) + afloat2[0] * f7;
                float g = afloat1[1] * (1.0f - f7) + afloat2[1] * f7;
                float b = afloat1[2] * (1.0f - f7) + afloat2[2] * f7;
                this.capBG.func_110565_c()[0] = 0xFF000000 | (int)((double)(r * 255.0f) + 0.5) << 16 | (int)((double)(g * 255.0f) + 0.5) << 8 | (int)((double)(b * 255.0f) + 0.5);
                this.capBG.func_110564_a();
            } else {
                this.capBG.func_110565_c()[0] = 0xFF000000 | data.getColours(PixelExtrasData.Category.HAT)[0] << 16 | data.getColours(PixelExtrasData.Category.HAT)[1] << 8 | data.getColours(PixelExtrasData.Category.HAT)[2];
                this.capBG.func_110564_a();
            }
            hat.getModel().renderModel(1.0f);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(path);
        hat.getModel().renderModel(1.0f);
        GlStateManager.func_179121_F();
    }

    public void renderMonocle(EntityPlayer player, PixelExtrasData data, float partialTicks) {
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.73f, (float)0.0f);
        }
        this.head.func_78794_c(1.0f);
        GlStateManager.func_179109_b((float)this.head.field_82906_o, (float)this.head.field_82908_p, (float)this.head.field_82907_q);
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)0.15f, (float)-1.45f, (float)-0.29f);
        GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
        ResourceLocation texture = data.getMonocleType() == PixelExtrasData.MonocleType.GOLD_MONOCLE ? this.GOLD_MONOCLE_TEXTURE : (data.getMonocleType() == PixelExtrasData.MonocleType.BLACK_MONOCLE ? this.BLACK_MONOCLE_TEXTURE : this.GOLD_MONOCLE_TEXTURE);
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(texture);
        this.MONOCLE_MODEL.getModel().renderModel(1.0f);
        GlStateManager.func_179121_F();
    }

    public void renderMask(EntityPlayer player, PixelExtrasData data, float partialTicks) {
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.73f, (float)0.0f);
        }
        this.head.func_78794_c(1.0f);
        GlStateManager.func_179109_b((float)this.head.field_82906_o, (float)this.head.field_82908_p, (float)this.head.field_82907_q);
        GlStateManager.func_179109_b((float)0.0f, (float)1.7f, (float)-1.735f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        if (data.getMonocleType() == PixelExtrasData.MonocleType.QUAGSIRE_MASK) {
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(this.QUAGSIRE_MASK_TEXTURE);
            this.QUAGSIRE_MASK_MODEL.getModel().renderModel(1.0f);
        } else {
            Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(this.QUARANTINE_MASK_TEXTURE);
            this.QUARANTINE_MASK_MODEL.getModel().renderModel(1.0f);
        }
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }
}

