/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers.npc;

import com.pixelmonmod.pixelmon.client.models.IPixelmonModel;
import com.pixelmonmod.pixelmon.client.render.RenderNPC;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.enums.EnumCustomModel;
import com.pixelmonmod.pixelmon.enums.EnumMegaItem;
import com.pixelmonmod.pixelmon.enums.EnumMegaItemsUnlocked;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;

public class LayerMegaItemsNPC
implements LayerRenderer<EntityNPC> {
    private final ResourceLocation texture = new ResourceLocation("pixelmon:textures/playeritems/megabraceletoras.png");
    private final ResourceLocation necklaceTexture = new ResourceLocation("pixelmon:textures/playeritems/boost_necklace.png");
    private final ResourceLocation glassesTexture = new ResourceLocation("pixelmon:textures/playeritems/mega_glasses.png");
    private final ResourceLocation anchorTexture = new ResourceLocation("pixelmon:textures/playeritems/mega_anchor.png");
    private final ResourceLocation dynamaxTexture = new ResourceLocation("pixelmon:textures/playeritems/dynamax_band.png");
    private final IPixelmonModel braceletModel = (IPixelmonModel)EnumCustomModel.MegaBraceletORAS.getModel();
    private final IPixelmonModel stoneModel = (IPixelmonModel)EnumCustomModel.MegaBraceletORASStone.getModel();
    private final IPixelmonModel necklace = (IPixelmonModel)EnumCustomModel.MegaBoostNecklace.getModel();
    private final IPixelmonModel glasses = (IPixelmonModel)EnumCustomModel.MegaGlasses.getModel();
    private final IPixelmonModel anchor = (IPixelmonModel)EnumCustomModel.MegaAnchor.getModel();
    private final IPixelmonModel dynamax = (IPixelmonModel)EnumCustomModel.DynamaxBand.getModel();
    private final RenderNPC renderer;

    public LayerMegaItemsNPC(RenderNPC renderer) {
        this.renderer = renderer;
    }

    public void doRenderLayer(EntityNPC npc, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!(npc instanceof NPCTrainer)) {
            return;
        }
        if (!(this.renderer.func_177087_b() instanceof ModelPlayer)) {
            return;
        }
        NPCTrainer trainer = (NPCTrainer)npc;
        boolean oldGenWorld = PixelmonConfig.oldGenDimensions.contains(npc.field_71093_bK);
        EnumOldGenMode oldGenMode = trainer.getOldGen();
        EnumMegaItemsUnlocked itemInUse = trainer.getMegaItem();
        EnumMegaItem megaItem = EnumMegaItem.None;
        if (oldGenMode == EnumOldGenMode.World) {
            if (oldGenWorld && itemInUse.canMega()) {
                megaItem = EnumMegaItem.BraceletORAS;
            } else if (!oldGenWorld && itemInUse.canDynamax()) {
                megaItem = EnumMegaItem.DynamaxBand;
            }
        } else if (oldGenMode == EnumOldGenMode.Mega && itemInUse.canMega()) {
            megaItem = EnumMegaItem.BraceletORAS;
        } else if (oldGenMode == EnumOldGenMode.Dynamax && itemInUse.canDynamax()) {
            megaItem = EnumMegaItem.DynamaxBand;
        }
        if (megaItem == EnumMegaItem.None || trainer.func_82150_aj()) {
            return;
        }
        ModelPlayer biped = (ModelPlayer)this.renderer.func_177087_b();
        ModelRenderer left = biped.field_178724_i;
        ModelRenderer body = biped.field_78115_e;
        ModelRenderer head = biped.field_78116_c;
        GlStateManager.func_179094_E();
        if (megaItem == EnumMegaItem.BraceletORAS) {
            if (npc.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            scale = ((ModelBox)left.field_78804_l.get((int)0)).field_78248_d == 2.0f ? 0.17f : 0.19f;
            biped.func_187073_a(0.0625f, EnumHandSide.LEFT);
            GlStateManager.func_179109_b((float)0.0f, (float)0.4f, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179109_b((float)left.field_82906_o, (float)left.field_82908_p, (float)left.field_82907_q);
            GlStateManager.func_179109_b((float)0.35f, (float)0.0f, (float)0.0f);
            this.renderer.func_110776_a(this.texture);
            GlStateManager.func_179089_o();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.braceletModel.renderAll(0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.stoneModel.renderAll(0.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            if (npc.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            scale = 1.05f;
            if (((ModelBox)left.field_78804_l.get((int)0)).field_78248_d == 2.0f) {
                scale = 1.02f;
            }
            biped.func_187073_a(0.0625f, EnumHandSide.LEFT);
            GlStateManager.func_179109_b((float)0.0f, (float)0.4f, (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179109_b((float)left.field_82906_o, (float)left.field_82908_p, (float)left.field_82907_q);
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179109_b((float)-0.3f, (float)0.0f, (float)0.875f);
            this.renderer.func_110776_a(this.dynamaxTexture);
            GlStateManager.func_179089_o();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.dynamax.renderAll(0.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return true;
    }
}

