/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.player;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.render.custom.FontRendererPixelmon;
import com.pixelmonmod.pixelmon.client.render.layers.LayerEquippables;
import com.pixelmonmod.pixelmon.client.render.player.LayerWrapper;
import com.pixelmonmod.pixelmon.client.render.player.ModelBikeArmor;
import com.pixelmonmod.pixelmon.client.render.player.ModelPlayerOnBike;
import com.pixelmonmod.pixelmon.client.render.player.PixelRenderPlayer;
import com.pixelmonmod.pixelmon.comm.packetHandlers.UIKeyPressPacket;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.entities.bikes.EntityBike;
import com.pixelmonmod.pixelmon.enums.TextJustification;
import com.pixelmonmod.pixelmon.items.IEquippable;
import com.pixelmonmod.pixelmon.items.ItemRelicCrown;
import com.pixelmonmod.pixelmon.items.ItemUIElement;
import java.awt.Color;
import java.util.HashSet;
import java.util.ListIterator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderArmorStand;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerArrow;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerCustomHead;
import net.minecraft.client.renderer.entity.layers.LayerElytra;
import net.minecraft.client.renderer.entity.layers.LayerEntityOnShoulder;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.GuiContainerEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class RenderEvents {
    private ModelPlayer oldModel = null;
    private ModelBiped oldModelArmor = null;
    private ModelBiped oldModelLeggings = null;
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    @SubscribeEvent
    public void onRenderTooltip(RenderTooltipEvent.Pre event) {
        event.setFontRenderer((FontRenderer)FontRendererPixelmon.getInstance());
        if (event.getStack().func_77973_b() instanceof ItemUIElement && event.getStack().func_82833_r().isEmpty()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeyPress(GuiScreenEvent.KeyboardInputEvent.Pre event) {
        if (event.getGui() instanceof GuiContainer) {
            GuiContainer container = (GuiContainer)event.getGui();
            for (Slot slot : container.field_147002_h.field_75151_b) {
                ItemStack stack;
                if (!slot.func_75216_d() || !((stack = slot.func_75211_c()).func_77973_b() instanceof ItemUIElement)) continue;
                int code = Keyboard.getEventKey();
                char key = Keyboard.getEventCharacter();
                Pixelmon.network.sendToServer((IMessage)new UIKeyPressPacket(code, key));
                if (Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i() != code) break;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public void onRenderContainer(GuiContainerEvent.DrawForeground event) {
        for (Slot slot : event.getGuiContainer().field_147002_h.field_75151_b) {
            ItemStack stack;
            if (!slot.func_75216_d() || !((stack = slot.func_75211_c()).func_77973_b() instanceof ItemUIElement) || ItemUIElement.isBakedModel(stack)) continue;
            boolean hover = event.getGuiContainer().getSlotUnderMouse() == slot;
            int x = ItemUIElement.getXOverride(stack).orElse(slot.field_75223_e - 1) + ItemUIElement.getXOffset(stack).orElse(0);
            int y = ItemUIElement.getYOverride(stack).orElse(slot.field_75221_f - 1) + ItemUIElement.getYOffset(stack).orElse(0);
            int z = ItemUIElement.getZLevel(stack).orElse(0);
            float[] rgba = ItemUIElement.getColor(stack, hover).orElse(WHITE);
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179140_f();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)rgba[3]);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)z);
            ItemUIElement.getImage(stack, hover).ifPresent(rl -> {
                int w = ItemUIElement.getImageWidth(stack).orElse(18);
                int h = ItemUIElement.getImageHeight(stack).orElse(18);
                float tw = ItemUIElement.getTextureWidth(stack).orElse(Float.valueOf(18.0f)).floatValue();
                float th = ItemUIElement.getTextureHeight(stack).orElse(Float.valueOf(18.0f)).floatValue();
                float u = ItemUIElement.getImageU(stack).orElse(Float.valueOf(0.0f)).floatValue();
                float v = ItemUIElement.getImageV(stack).orElse(Float.valueOf(0.0f)).floatValue();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(rl);
                Gui.func_146110_a((int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (float)tw, (float)th);
            });
            ItemUIElement.getText(stack, hover).ifPresent(text -> {
                TextJustification j = ItemUIElement.getTextJustification(stack);
                float s = ItemUIElement.getTextScale(stack);
                switch (j) {
                    case RIGHT: {
                        GuiHelper.drawScaledString(text, x, y, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), s);
                        break;
                    }
                    case CENTER: {
                        GuiHelper.drawScaledCenteredString(text, x, y, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), s);
                        break;
                    }
                    case LEFT: {
                        GuiHelper.drawScaledStringRightAligned(text, x, y, new Color(rgba[0], rgba[1], rgba[2], rgba[3]).getRGB(), false, s);
                    }
                }
            });
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void onRenderArmorStand(RenderLivingEvent.Pre<EntityArmorStand> event) {
        if (event.getRenderer() instanceof RenderArmorStand && LayerEquippables.hasEquippables(event.getEntity())) {
            ListIterator i = event.getRenderer().field_177097_h.listIterator();
            this.renderBlockOnArmorStand(event, event.getEntity());
            while (i.hasNext()) {
                LayerRenderer layer = (LayerRenderer)i.next();
                if (!(layer instanceof LayerCustomHead)) continue;
                i.remove();
            }
        }
    }

    private void renderBlockOnArmorStand(RenderLivingEvent.Pre<EntityArmorStand> event, EntityLivingBase entity) {
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (view == null) {
            return;
        }
        HashSet<IEquippable> equippables = new HashSet<IEquippable>();
        for (ItemStack stack : entity.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable)) continue;
            equippables.add((IEquippable)stack.func_77973_b());
        }
        if (!equippables.isEmpty()) {
            for (IEquippable equippable : equippables) {
                if (!(equippable.getEquippableItem() instanceof ItemRelicCrown) || entity.func_184613_cA() || entity.func_184187_bx() != null) continue;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                IBlockState state = PixelmonBlocks.relicCrown.func_176223_P();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                BlockPos blockpos = entity.func_180425_c().func_177982_a(0, 2, 0);
                float yaw = entity.field_70758_at + (entity.field_70759_as - entity.field_70758_at) * event.getPartialRenderTick();
                float pitch = entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * event.getPartialRenderTick();
                double r = 0.335;
                if (entity.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.38f, (float)0.0f);
                }
                double theta = (double)pitch * Math.PI / 180.0;
                double x = 2.0 * r * Math.sin(theta / 2.0);
                double gamma = 90.0 - (180.0 - theta) / 2.0;
                double a = x * Math.sin(gamma);
                double b = x * Math.cos(gamma);
                GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                GlStateManager.func_179137_b((double)0.0, (double)1.75, (double)0.0);
                GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                GlStateManager.func_179137_b((double)0.0, (double)a, (double)b);
                GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                double viewX = view.field_70169_q + (view.field_70165_t - view.field_70169_q) * (double)event.getPartialRenderTick();
                double viewY = view.field_70167_r + (view.field_70163_u - view.field_70167_r) * (double)event.getPartialRenderTick();
                double viewZ = view.field_70166_s + (view.field_70161_v - view.field_70166_s) * (double)event.getPartialRenderTick();
                double playerX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)event.getPartialRenderTick();
                double playerY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)event.getPartialRenderTick();
                double playerZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)event.getPartialRenderTick();
                GlStateManager.func_179137_b((double)(viewX - playerX), (double)(viewY - playerY), (double)(viewZ - playerZ));
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, blockrendererdispatcher.func_184389_a(state), state, BlockPos.field_177992_a, bufferbuilder, false, MathHelper.func_180186_a((Vec3i)blockpos));
                tessellator.func_78381_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (event.getRenderer() instanceof PixelRenderPlayer) {
            LayerRenderer layer;
            ListIterator<LayerWrapper> i;
            PixelRenderPlayer renderPlayer = (PixelRenderPlayer)event.getRenderer();
            this.renderBlockOnPlayer((RenderPlayerEvent)event, event.getEntityPlayer());
            if (LayerEquippables.hasEquippables((EntityLivingBase)player)) {
                i = event.getRenderer().field_177097_h.listIterator();
                while (i.hasNext()) {
                    layer = (LayerRenderer)i.next();
                    if (!(layer instanceof LayerCustomHead)) continue;
                    i.remove();
                }
            }
            if (player.func_184187_bx() instanceof EntityBike) {
                this.oldModel = renderPlayer.func_177087_b();
                renderPlayer.setModel(new ModelPlayerOnBike(0.0f, renderPlayer.isAlex));
                i = event.getRenderer().field_177097_h.listIterator();
                while (i.hasNext()) {
                    layer = (LayerRenderer)i.next();
                    if (layer instanceof LayerArmorBase && (LayerArmorBase)layer instanceof LayerBipedArmor) {
                        LayerBipedArmor layerArmor = (LayerBipedArmor)((LayerArmorBase)layer);
                        this.oldModelArmor = (ModelBiped)layerArmor.field_177186_d;
                        this.oldModelLeggings = (ModelBiped)layerArmor.field_177189_c;
                        layerArmor.field_177186_d = new ModelBikeArmor(1.0f);
                        layerArmor.field_177189_c = new ModelBikeArmor(0.5f);
                        continue;
                    }
                    if (LayerElytra.class.isInstance(layer)) {
                        i.set(new LayerWrapper((LayerRenderer<? extends EntityLivingBase>)layer).setTranslates(0.0, 0.03, -0.25));
                        continue;
                    }
                    if (LayerCustomHead.class.isInstance(layer)) {
                        i.set(new LayerWrapper((LayerRenderer<? extends EntityLivingBase>)new LayerCustomHead(renderPlayer.func_177087_b().field_78116_c)).setTranslates(0.0, 0.05, -0.2f));
                        continue;
                    }
                    if (!LayerArrow.class.isInstance(layer) && !LayerEntityOnShoulder.class.isInstance(layer) && !LayerHeldItem.class.isInstance(layer)) continue;
                    i.set(new LayerWrapper((LayerRenderer<? extends EntityLivingBase>)layer).setEnabled(false));
                }
            }
        }
    }

    private void renderBlockOnPlayer(RenderPlayerEvent event, EntityPlayer player) {
        Entity view = Minecraft.func_71410_x().func_175606_aa();
        if (view == null) {
            return;
        }
        HashSet<IEquippable> equippables = new HashSet<IEquippable>();
        for (ItemStack stack : player.func_184193_aE()) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IEquippable)) continue;
            equippables.add((IEquippable)stack.func_77973_b());
        }
        if (!equippables.isEmpty()) {
            for (IEquippable equippable : equippables) {
                if (!(equippable.getEquippableItem() instanceof ItemRelicCrown) || player.func_184613_cA() || player.func_184187_bx() != null) continue;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                IBlockState state = PixelmonBlocks.relicCrown.func_176223_P();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                BlockPos blockpos = player.func_180425_c().func_177982_a(0, 2, 0);
                float yaw = player.field_70758_at + (player.field_70759_as - player.field_70758_at) * event.getPartialRenderTick();
                float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * event.getPartialRenderTick();
                double r = 0.335;
                if (player.func_70093_af()) {
                    GlStateManager.func_179109_b((float)0.0f, (float)-0.38f, (float)0.0f);
                }
                double theta = (double)pitch * Math.PI / 180.0;
                double x = 2.0 * r * Math.sin(theta / 2.0);
                double gamma = 90.0 - (180.0 - theta) / 2.0;
                double a = x * Math.sin(gamma);
                double b = x * Math.cos(gamma);
                GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                GlStateManager.func_179137_b((double)0.0, (double)1.75, (double)0.0);
                GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
                GlStateManager.func_179137_b((double)0.0, (double)a, (double)b);
                GlStateManager.func_179137_b((double)event.getX(), (double)event.getY(), (double)event.getZ());
                double viewX = view.field_70169_q + (view.field_70165_t - view.field_70169_q) * (double)event.getPartialRenderTick();
                double viewY = view.field_70167_r + (view.field_70163_u - view.field_70167_r) * (double)event.getPartialRenderTick();
                double viewZ = view.field_70166_s + (view.field_70161_v - view.field_70166_s) * (double)event.getPartialRenderTick();
                double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialRenderTick();
                double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialRenderTick();
                double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialRenderTick();
                GlStateManager.func_179137_b((double)(viewX - playerX), (double)(viewY - playerY), (double)(viewZ - playerZ));
                BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                blockrendererdispatcher.func_175019_b().func_187493_a((IBlockAccess)Minecraft.func_71410_x().field_71441_e, blockrendererdispatcher.func_184389_a(state), state, BlockPos.field_177992_a, bufferbuilder, false, MathHelper.func_180186_a((Vec3i)blockpos));
                tessellator.func_78381_a();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        boolean hasCustomHead = false;
        ListIterator i2 = event.getRenderer().field_177097_h.listIterator();
        while (i2.hasNext()) {
            LayerRenderer layer = (LayerRenderer)i2.next();
            if (!(layer instanceof LayerCustomHead)) continue;
            hasCustomHead = true;
            break;
        }
        if (!hasCustomHead) {
            event.getRenderer().func_177094_a((LayerRenderer)new LayerCustomHead(event.getRenderer().func_177087_b().field_78116_c));
        }
        if (this.oldModel != null) {
            if (event.getRenderer() instanceof PixelRenderPlayer) {
                PixelRenderPlayer renderPlayer = (PixelRenderPlayer)event.getRenderer();
                renderPlayer.setModel(this.oldModel);
                ListIterator<Object> i = event.getRenderer().field_177097_h.listIterator();
                while (i.hasNext()) {
                    LayerRenderer layer = (LayerRenderer)i.next();
                    if (this.oldModelArmor != null && layer instanceof LayerArmorBase && (LayerArmorBase)layer instanceof LayerBipedArmor) {
                        LayerBipedArmor layerArmor = (LayerBipedArmor)((LayerArmorBase)layer);
                        layerArmor.field_177186_d = this.oldModelArmor;
                        layerArmor.field_177189_c = this.oldModelLeggings;
                        continue;
                    }
                    if (!(layer instanceof LayerWrapper)) continue;
                    LayerRenderer renderer = ((LayerWrapper)layer).renderer;
                    if (renderer instanceof LayerCustomHead) {
                        LayerCustomHead customHead = new LayerCustomHead(renderPlayer.func_177087_b().field_78116_c);
                        i.set(customHead);
                        continue;
                    }
                    i.set(renderer);
                }
                this.oldModelArmor = null;
                this.oldModelLeggings = null;
            }
            this.oldModel = null;
        }
    }
}

