/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.tileEntities;

import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.blocks.BlockProperties;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityCloningMachine;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelBrokenCloningMachine;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelCloningMachine;
import com.pixelmonmod.pixelmon.client.models.blocks.ModelEntityBlock;
import com.pixelmonmod.pixelmon.client.models.smd.AnimationType;
import com.pixelmonmod.pixelmon.client.render.GenericModelHolder;
import com.pixelmonmod.pixelmon.client.render.tileEntities.TileEntityRenderer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderTileEntityCloningMachine
extends TileEntityRenderer<TileEntityCloningMachine> {
    private static final ResourceLocation cloningMachineTex = new ResourceLocation("pixelmon:textures/blocks/cloner.png");
    private static final ResourceLocation cloningMachineBlocks = new ResourceLocation("pixelmon:textures/gui/clonerBlocks.png");
    private static final GenericModelHolder<ModelCloningMachine> model = new GenericModelHolder<ModelCloningMachine>(ModelCloningMachine.class);
    private static final GenericModelHolder<ModelBrokenCloningMachine> brokenModel = new GenericModelHolder<ModelBrokenCloningMachine>(ModelBrokenCloningMachine.class);
    private EntityPixelmon pokemon;

    public RenderTileEntityCloningMachine() {
        this.flip = false;
    }

    @Override
    public void renderTileEntity(TileEntityCloningMachine machine, IBlockState state, double x, double y, double z, float partialTicks, int destroyStage) {
        this.func_147499_a(cloningMachineTex);
        ((ModelEntityBlock)((Object)(machine.isBroken ? brokenModel : model).getModel())).renderTileEntity(machine, 0.0625f);
        GlStateManager.func_179121_F();
        EnumFacing facing = EnumFacing.NORTH;
        int rotation = super.getRotation(state);
        if (state.func_177230_c() instanceof MultiBlock) {
            facing = (EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING);
        }
        GlStateManager.func_179094_E();
        if (machine.hasMew() && !machine.isBroken && !machine.isFinished) {
            if (this.pokemon == null) {
                this.pokemon = PokemonSpec.from(EnumSpecies.Mew.name).create(this.func_178459_a());
                this.pokemon.getPokemonData().setGrowth(EnumGrowth.Runt);
                this.pokemon.getLvl().setLevel(1);
                this.pokemon.getPokemonData().setShiny(machine.mew.isShiny());
                this.pokemon.initAnimation();
            }
            GlStateManager.func_179094_E();
            if (this.pokemon != null) {
                GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 0.45f), (float)((float)z + 0.5f));
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                this.pokemon.func_70012_b(x, y, z, 0.0f, 0.0f);
                this.pokemon.setAnimation(AnimationType.IDLE);
                if (this.pokemon.getAnimationVariables().hasInt(-1)) {
                    this.pokemon.getAnimationVariables().getCounter((int)-1).value = 30.0f;
                }
                Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)this.pokemon, 0.0, 0.0, 0.0, 0.0f, partialTicks, false);
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(cloningMachineTex);
        if (machine.isBroken) {
            ((ModelBrokenCloningMachine)((Object)brokenModel.getModel())).renderGlass(machine, 0.0625f);
        } else {
            ((ModelCloningMachine)((Object)model.getModel())).renderGlass(machine, 0.0625f);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        if (machine.isBroken) {
            this.renderLeftDisplay(machine, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.error", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
        } else {
            if (machine.isFinished) {
                this.renderLeftDisplay(machine, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.finished", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            } else if (machine.hasMew()) {
                this.renderLeftDisplay(machine, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.scanning", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            } else {
                this.renderLeftDisplay(machine, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.mew", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            }
            if (machine.hasMew()) {
                this.renderRightDisplay(machine, I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.catalyst", (Object[])new Object[0]), facing, x, y, z, 64, false, -1);
            }
            if (!machine.pokemonName.equals("")) {
                if (machine.pixelmon == null) {
                    machine.pixelmon = new PokemonSpec(machine.pokemonName, machine.isShiny ? "s" : "!s", "gr:Runt", "lvl:1").create(this.func_178459_a());
                    machine.pixelmon.initAnimation();
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)x + 0.5f + machine.xboost), (float)((float)y + 0.8f), (float)((float)z + 0.5f + machine.zboost));
                machine.pixelmon.func_70029_a(machine.func_145831_w());
                GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(0.0f + (float)machine.pokemonProgress / 200.0f), (float)(0.0f + (float)machine.pokemonProgress / 200.0f), (float)(0.0f + (float)machine.pokemonProgress / 200.0f));
                Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)machine.pixelmon, 0.0, 0.0, 0.0, 0.0f, 0.0f, false);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void renderLeftDisplay(TileEntityCloningMachine tile, String par2Str, EnumFacing facing, double par3, double par5, double par7, int par9, boolean par10, int par11) {
        int j = 0;
        if (facing == EnumFacing.EAST) {
            j = 270;
        } else if (facing == EnumFacing.NORTH) {
            j = 0;
        } else if (facing == EnumFacing.WEST) {
            j = 90;
        } else if (facing == EnumFacing.SOUTH) {
            j = 180;
        }
        FontRenderer var12 = this.func_147498_b();
        float var13 = 1.6f;
        float var14 = 0.011666667f * var13;
        GlStateManager.func_179094_E();
        if (facing == EnumFacing.NORTH) {
            GlStateManager.func_179109_b((float)((float)par3 + 0.5f), (float)((float)par5 + 0.9f), (float)((float)par7 + 1.22f));
        } else if (facing == EnumFacing.WEST) {
            GlStateManager.func_179109_b((float)((float)par3 + 1.23f), (float)((float)par5 + 0.9f), (float)((float)par7 + 0.5f));
        } else if (facing == EnumFacing.SOUTH) {
            GlStateManager.func_179109_b((float)((float)par3 + 0.5f), (float)((float)par5 + 0.9f), (float)((float)par7 - 0.23f));
        } else {
            GlStateManager.func_179109_b((float)((float)par3 - 0.23f), (float)((float)par5 + 0.9f), (float)((float)par7 + 0.51f));
        }
        GlStateManager.func_179114_b((float)(j + 180), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        if (!par10) {
            GlStateManager.func_179152_a((float)(-var14), (float)(-var14), (float)var14);
        } else {
            GlStateManager.func_179152_a((float)(-var14 + 0.012f), (float)(-var14 + 0.012f), (float)(var14 + 0.012f));
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int var16 = 0;
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179098_w();
        var12.func_78276_b(par2Str, -var12.func_78256_a(par2Str) / 2, var16, par11);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private void renderRightDisplay(TileEntityCloningMachine tile, String par2Str, EnumFacing facing, double par3, double par5, double par7, int par9, boolean par10, int par11) {
        int j = 0;
        if (facing == EnumFacing.EAST) {
            j = 270;
        } else if (facing == EnumFacing.NORTH) {
            j = 0;
        } else if (facing == EnumFacing.WEST) {
            j = 90;
        } else if (facing == EnumFacing.SOUTH) {
            j = 180;
        }
        FontRenderer var12 = this.func_147498_b();
        float var13 = 1.6f;
        float var14 = 0.011666667f * var13;
        GlStateManager.func_179094_E();
        if (facing == EnumFacing.NORTH) {
            GlStateManager.func_179109_b((float)((float)par3 + 3.87f), (float)((float)par5 + 0.9f), (float)((float)par7 + 1.22f));
        } else if (facing == EnumFacing.WEST) {
            GlStateManager.func_179109_b((float)((float)par3 + 1.23f), (float)((float)par5 + 0.9f), (float)((float)par7 - 2.87f));
        } else if (facing == EnumFacing.SOUTH) {
            GlStateManager.func_179109_b((float)((float)par3 - 2.87f), (float)((float)par5 + 0.9f), (float)((float)par7 - 0.23f));
        } else {
            GlStateManager.func_179109_b((float)((float)par3 - 0.23f), (float)((float)par5 + 0.9f), (float)((float)par7 + 3.87f));
        }
        GlStateManager.func_179114_b((float)(j + 180), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        if (!par10) {
            GlStateManager.func_179152_a((float)(-var14), (float)(-var14), (float)var14);
        } else {
            GlStateManager.func_179152_a((float)(-var14 + 0.012f), (float)(-var14 + 0.012f), (float)(var14 + 0.012f));
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        int var16 = 0;
        GlStateManager.func_179152_a((float)0.3f, (float)0.3f, (float)0.3f);
        GlStateManager.func_179090_x();
        var12.func_78256_a(par2Str);
        GlStateManager.func_179098_w();
        if (tile.isFinished) {
            par2Str = I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.retrieve", (Object[])new Object[0]);
        } else if (tile.processingClone || tile.growingPokemon) {
            par2Str = I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.processing", (Object[])new Object[0]);
        }
        var12.func_78276_b(par2Str, -var12.func_78256_a(par2Str) / 2, var16, par11);
        if (!(tile.processingClone || tile.growingPokemon || tile.isFinished)) {
            this.func_147499_a(cloningMachineBlocks);
            GuiHelper.drawImageQuad(-30.0, 10.0, 60.0, 20.0f, 0.0, 0.0, 1.0, 1.0, 0.0f);
            par2Str = I18n.func_135052_a((String)"pixelmon.blocks.cloningmachine.boost", (Object[])new Object[0]) + " " + tile.boostCount + "/3";
            var12.func_78276_b(par2Str, -var12.func_78256_a(par2Str) / 2, var16 + 40, par11);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder worldRenderer = tessellator.func_178180_c();
            int x = -30;
            int w = 60;
            int y = 35;
            int h = 17;
            boolean zLevel = false;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            float boostPercent = (float)tile.boostLevel / 40.0f;
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            worldRenderer.func_181662_b((double)x, (double)(y + h), (double)zLevel + 0.01).func_181666_a(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b((double)(x + w), (double)(y + h), (double)zLevel + 0.01).func_181666_a(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b((double)(x + w), (double)y, (double)zLevel + 0.01).func_181666_a(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).func_181675_d();
            worldRenderer.func_181662_b((double)x, (double)y, (double)zLevel + 0.01).func_181666_a(0.2f + 0.3f * (1.0f - boostPercent), 0.2f + 0.3f * boostPercent, 0.2f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

