/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex.RequestMovesetData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.pokedex.RequestSpawnData;
import com.pixelmonmod.pixelmon.enums.EnumMovesetGroup;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.pokedex.Pokedex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;

@SideOnly(value=Side.CLIENT)
public class ClientPokedex
extends Pokedex {
    Map<Integer, List<Pokedex.PokedexSpawnData>> data = Maps.newHashMap();
    Map<Triple<EnumSpecies, Byte, String>, Map<EnumMovesetGroup, List>> movesets = Maps.newHashMap();

    public void update(Map<Integer, EnumPokedexRegisterStatus> seenMap, Table<Integer, Short, Short> data2) {
        this.setSeenMap(seenMap);
        this.formDex = data2;
    }

    public void update(int npn, List<Pokedex.PokedexSpawnData> spawnData) {
        this.data.put(npn, spawnData);
    }

    public void updateMoveset(EnumSpecies species, byte form, String texture, Map<EnumMovesetGroup, List> moveset) {
        this.movesets.put((Triple<EnumSpecies, Byte, String>)Triple.of((Object)species, (Object)form, (Object)texture), moveset);
    }

    public List<Pokedex.PokedexSpawnData> getSpawnData(int npn) {
        if (!this.data.containsKey(npn)) {
            Pixelmon.network.sendToServer((IMessage)new RequestSpawnData(npn));
            this.data.put(npn, Lists.newArrayList());
        }
        return this.data.get(npn);
    }

    public Map<EnumMovesetGroup, List> getMoveset(EnumSpecies species, byte form, String texture) {
        Triple p = Triple.of((Object)species, (Object)form, (Object)texture);
        if (!this.movesets.containsKey(p)) {
            Pixelmon.network.sendToServer((IMessage)new RequestMovesetData(species, form, texture));
            HashMap m = new HashMap();
            for (EnumMovesetGroup group : EnumMovesetGroup.values()) {
                m.put(group, new ArrayList());
            }
            this.movesets.put((Triple<EnumSpecies, Byte, String>)p, m);
        }
        return this.movesets.get(p);
    }
}

