/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenReplaceMoveScreen;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class NPCTeachMove
implements IMessage {
    UUID pokemonUUID;
    int attackId;
    int npcId;

    @Deprecated
    public NPCTeachMove() {
    }

    public NPCTeachMove(UUID pokemonUUID, int attackId, int npcId) {
        this.pokemonUUID = pokemonUUID;
        this.attackId = attackId;
        this.npcId = npcId;
    }

    public void fromBytes(ByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.attackId = buffer.readInt();
        this.npcId = buffer.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits());
        buffer.writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.writeInt(this.attackId);
        buffer.writeInt(this.npcId);
    }

    public static class Handler
    implements ISyncHandler<NPCTeachMove> {
        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onSyncMessage(NPCTeachMove message, MessageContext ctx) {
            void var6_7;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            Attack attack = new Attack(message.attackId);
            Pokemon pokemon = Pixelmon.storageManager.getParty(player).find(message.pokemonUUID);
            if (pokemon == null) {
                return;
            }
            ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
            Optional<EntityNPC> npc = EntityNPC.locateNPCServer(player.field_70170_p, message.npcId, EntityNPC.class);
            if (!npc.isPresent() || !((double)npc.get().func_70032_d((Entity)player) <= 64.0)) return;
            if (npc.get() instanceof NPCRelearner) {
                List<Attack> attackList = NPCRelearner.getRelearnableMoves(pokemon);
                if (!attackList.contains(attack)) {
                    return;
                }
                NPCRelearner relearner = (NPCRelearner)npc.get();
                ItemStack cost = relearner.getCost();
                if (!cost.func_190926_b()) {
                    arrayList.add(cost);
                }
            } else {
                if (!(npc.get() instanceof NPCTutor)) return;
                NPCTutor tutor = (NPCTutor)npc.get();
                if (tutor.moveList.stream().noneMatch(it -> it.attack() == attack.getMove())) {
                    return;
                }
                if (!pokemon.getBaseStats().canLearn(attack.getMove().getAttackName())) {
                    return;
                }
                for (int i = 0; i < tutor.moveList.size(); ++i) {
                    List<ItemStack> array;
                    if (!tutor.moveList.get(i).attack().isAttack(attack) || (array = tutor.moveList.get(i).costs()).size() < 1) continue;
                    List<ItemStack> list = array;
                }
            }
            if (!var6_7.isEmpty() && !player.field_71075_bZ.field_75098_d) {
                LearnMoveController.addLearnMove(player, pokemon.getUUID(), attack.getActualMove(), LearnMoveController.itemCostCondition((Collection<ItemStack>)var6_7));
            } else {
                LearnMoveController.addLearnMove(player, pokemon.getUUID(), attack.getActualMove());
            }
            if (pokemon.getMoveset().size() >= 4) {
                Pixelmon.network.sendTo((IMessage)new OpenReplaceMoveScreen(pokemon.getUUID(), attack.getActualMove()), player);
                return;
            } else if (LearnMoveController.canLearnMove(player, pokemon.getUUID(), attack.getActualMove())) {
                pokemon.getMoveset().add(attack);
                ChatHandler.sendChat((Entity)player, "pixelmon.stats.learnedmove", pokemon.getDisplayName(), attack.getMove().getTranslatedName());
                return;
            } else {
                ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.RED, "pixelmon.npc.cantpay", new Object[0]);
            }
        }
    }
}

