/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.SpectateEvent;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetAllBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartSpectate;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RequestSpectate
implements IMessage {
    UUID uuid;

    public RequestSpectate() {
    }

    public RequestSpectate(UUID playerId) {
        this.uuid = playerId;
    }

    public void fromBytes(ByteBuf buffer) {
        this.uuid = new UUID(buffer.readLong(), buffer.readLong());
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeLong(this.uuid.getMostSignificantBits());
        buffer.writeLong(this.uuid.getLeastSignificantBits());
    }

    public static class Handler
    implements IMessageHandler<RequestSpectate, IMessage> {
        public IMessage onMessage(RequestSpectate message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> this.processMessage(message, ctx));
            return null;
        }

        private void processMessage(RequestSpectate message, MessageContext ctx) {
            BattleControllerBase base;
            EntityPlayerMP watcher = ctx.getServerHandler().field_147369_b;
            EntityPlayerMP watchedPlayer = (EntityPlayerMP)watcher.field_70170_p.func_152378_a(message.uuid);
            if (watchedPlayer != null && (base = BattleRegistry.getBattle((EntityPlayer)watchedPlayer)) != null && !Pixelmon.EVENT_BUS.post((Event)new SpectateEvent.StartSpectate(watcher, base, watchedPlayer))) {
                PlayerParticipant watchedParticipant = base.getPlayer(watchedPlayer.getDisplayNameString());
                if (watchedParticipant == null) {
                    return;
                }
                Pixelmon.network.sendTo((IMessage)new StartBattle(base.battleIndex, base.getBattleType(watchedParticipant), base.rules), watcher);
                Pixelmon.network.sendTo((IMessage)new SetAllBattlingPokemon(PixelmonInGui.convertToGUI(Arrays.asList(watchedParticipant.allPokemon))), watcher);
                ArrayList<PixelmonWrapper> teamList = watchedParticipant.getTeamPokemonList();
                Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(teamList), watcher);
                Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(PixelmonInGui.convertToGUI(teamList), false), watcher);
                Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(watchedParticipant.getOpponentData(), true), watcher);
                Pixelmon.network.sendTo((IMessage)new StartSpectate(watchedPlayer.func_110124_au(), base.rules.battleType), watcher);
                if (base.getTeam(watchedParticipant).size() > 1) {
                    Pixelmon.network.sendTo((IMessage)new SetPokemonTeamData(watchedParticipant.getAllyData()), watcher);
                }
                base.addSpectator(new Spectator(watcher, watchedPlayer.getDisplayNameString()));
            }
        }
    }
}

