/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.comm.packetHandlers.ISyncHandler;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetPokemonBattleData
implements IMessage {
    PixelmonInGui[] data;
    boolean isOpponent;

    public SetPokemonBattleData() {
    }

    public SetPokemonBattleData(PixelmonInGui[] controlledPokemon) {
        this(controlledPokemon, true);
    }

    public SetPokemonBattleData(PixelmonInGui[] controlledPokemon, boolean isOpponent) {
        this.data = controlledPokemon;
        this.isOpponent = isOpponent;
    }

    public void toBytes(ByteBuf buffer) {
        int numPokemon = this.data.length;
        for (PixelmonInGui d : this.data) {
            if (d != null) continue;
            --numPokemon;
        }
        buffer.writeShort(numPokemon);
        for (PixelmonInGui d : this.data) {
            if (d == null) continue;
            d.encodeInto(buffer);
        }
        buffer.writeBoolean(this.isOpponent);
    }

    public void fromBytes(ByteBuf buffer) {
        this.data = new PixelmonInGui[buffer.readShort()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new PixelmonInGui();
            this.data[i].decodeFrom(buffer);
        }
        this.isOpponent = buffer.readBoolean();
    }

    public static class Handler
    implements ISyncHandler<SetPokemonBattleData> {
        @Override
        public void onSyncMessage(SetPokemonBattleData message, MessageContext ctx) {
            if (message.isOpponent) {
                ClientProxy.battleManager.setOpponents(message.data);
            } else {
                ClientProxy.battleManager.setTeamPokemon(message.data);
            }
        }
    }
}

