/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetStruggle
implements IMessage {
    public boolean[][] targetting;
    public int battleIndex;
    public UUID pokemonUUID;

    public SetStruggle() {
    }

    public SetStruggle(UUID pokemonUUID, boolean[][] targetting, int battleIndex) {
        this.pokemonUUID = pokemonUUID;
        this.battleIndex = battleIndex;
        this.targetting = targetting;
    }

    public void fromBytes(ByteBuf buffer) {
        int i;
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.battleIndex = buffer.readInt();
        this.targetting = new boolean[buffer.readShort()][];
        for (i = 0; i < this.targetting.length; ++i) {
            this.targetting[i] = new boolean[buffer.readShort()];
        }
        for (i = 0; i < this.targetting.length; ++i) {
            for (int j = 0; j < this.targetting[i].length; ++j) {
                this.targetting[i][j] = buffer.readBoolean();
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        PixelmonMethods.toBytesUUID(buffer, this.pokemonUUID);
        buffer.writeInt(this.battleIndex);
        buffer.writeShort(this.targetting.length);
        for (boolean[] aTargetting1 : this.targetting) {
            buffer.writeShort(aTargetting1.length);
        }
        for (boolean[] aTargetting : this.targetting) {
            for (int j = 0; j < aTargetting.length; ++j) {
                buffer.writeBoolean(aTargetting[j]);
            }
        }
    }

    public static class Handler
    implements IMessageHandler<SetStruggle, IMessage> {
        public IMessage onMessage(SetStruggle message, MessageContext ctx) {
            BattleControllerBase bc = BattleRegistry.getBattle(message.battleIndex);
            for (BattleParticipant p : bc.participants) {
                if (!(p instanceof PlayerParticipant) || !((PlayerParticipant)p).player.func_110124_au().equals(ctx.getServerHandler().field_147369_b.func_110124_au())) continue;
                for (PixelmonWrapper pw : p.controlledPokemon) {
                    if (!pw.getPokemonUUID().equals(message.pokemonUUID)) continue;
                    ArrayList<PixelmonWrapper> targets = this.findTargets(message, bc, p);
                    pw.setStruggle(targets);
                }
            }
            return null;
        }

        private ArrayList<PixelmonWrapper> findTargets(SetStruggle message, BattleControllerBase bc, BattleParticipant p) {
            ArrayList<PixelmonWrapper> targets = new ArrayList<PixelmonWrapper>();
            ArrayList<PixelmonWrapper> teamPokemon = bc.getTeamPokemon(p);
            for (int i = 0; i < message.targetting[0].length; ++i) {
                if (!message.targetting[0][i]) continue;
                targets.add(teamPokemon.get(i));
            }
            ArrayList<PixelmonWrapper> opponentPokemon = bc.getOpponentPokemon(p);
            for (int i = 0; i < message.targetting[1].length; ++i) {
                if (!message.targetting[1][i]) continue;
                targets.add(opponentPokemon.get(i));
            }
            return targets;
        }
    }
}

