/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.npc;

import com.pixelmonmod.pixelmon.client.gui.npc.GuiTutor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTutorEditor;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStatsLearnType;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class LoadTutorData
implements IMessage {
    List<NPCTutor.LearnableMove> learnableMoves;
    EnumSet<BaseStatsLearnType> learnTypes = EnumSet.noneOf(BaseStatsLearnType.class);

    public LoadTutorData() {
    }

    public LoadTutorData(List<NPCTutor.LearnableMove> learnableMoves) {
        this.learnableMoves = learnableMoves;
    }

    public LoadTutorData(List<NPCTutor.LearnableMove> learnableMoves, EnumSet<BaseStatsLearnType> learnTypes) {
        this.learnableMoves = learnableMoves;
        this.learnTypes = learnTypes;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        int count = buf.readInt();
        this.learnableMoves = new ArrayList<NPCTutor.LearnableMove>();
        for (i = 0; i < count; ++i) {
            NPCTutor.LearnableMove move = new NPCTutor.LearnableMove();
            move.fromBytes(buf);
            this.learnableMoves.add(move);
        }
        count = buf.readInt();
        this.learnTypes.clear();
        for (i = 0; i < count; ++i) {
            BaseStatsLearnType type = BaseStatsLearnType.fromOrdinal(buf.readByte());
            if (type == null) continue;
            this.learnTypes.add(type);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.learnableMoves.size());
        for (NPCTutor.LearnableMove learnableMove : this.learnableMoves) {
            learnableMove.toBytes(buf);
        }
        buf.writeInt(this.learnTypes.size());
        for (BaseStatsLearnType type : this.learnTypes) {
            buf.writeByte(type.ordinal());
        }
    }

    public static class Handler
    implements IMessageHandler<LoadTutorData, IMessage> {
        public IMessage onMessage(LoadTutorData message, MessageContext ctx) {
            GuiTutor.moveList = message.learnableMoves;
            GuiTutorEditor.learnTypes = message.learnTypes;
            return null;
        }
    }
}

