/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.selection;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.selection.PartySelectionFactory;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SelectionResponsePacket
implements IMessage {
    private List<Integer> selected;

    public SelectionResponsePacket() {
    }

    public SelectionResponsePacket(List<Integer> selected) {
        this.selected = selected;
    }

    public void fromBytes(ByteBuf buf) {
        if (!buf.readBoolean()) {
            this.selected = null;
            return;
        }
        this.selected = Lists.newArrayList();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.selected.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.selected != null);
        if (this.selected == null) {
            return;
        }
        buf.writeInt(this.selected.size());
        for (Integer integer : this.selected) {
            buf.writeInt(integer.intValue());
        }
    }

    public static class Handler
    implements IMessageHandler<SelectionResponsePacket, SelectionResponsePacket> {
        public SelectionResponsePacket onMessage(SelectionResponsePacket message, MessageContext ctx) {
            if (!PartySelectionFactory.inSelection(ctx.getServerHandler().field_147369_b)) {
                return null;
            }
            PartySelectionFactory.SelectionData selectionConsumer = PartySelectionFactory.getSelectionConsumer(ctx.getServerHandler().field_147369_b);
            if (selectionConsumer == null) {
                return null;
            }
            if (message.selected == null) {
                if (selectionConsumer.getConsumer() != null) {
                    selectionConsumer.getConsumer().accept(ctx.getServerHandler().field_147369_b, Collections.emptyList());
                }
                PartySelectionFactory.removeSelection(ctx.getServerHandler().field_147369_b);
                return null;
            }
            List<Pokemon> pokemon = selectionConsumer.getPokemon();
            ArrayList selected = Lists.newArrayList();
            for (Integer integer : message.selected) {
                selected.add(pokemon.get(integer));
            }
            if (selectionConsumer.getConsumer() != null) {
                selectionConsumer.getConsumer().accept(ctx.getServerHandler().field_147369_b, selected);
            }
            PartySelectionFactory.removeSelection(ctx.getServerHandler().field_147369_b);
            return null;
        }
    }
}

