/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.blocks.BlockProperties;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.comm.CommandChatHandler;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.items.PixelmonItemBlock;
import com.pixelmonmod.pixelmon.util.PixelBlockSnapshot;
import com.pixelmonmod.pixelmon.worldGeneration.structure.util.StructureSnapshot;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class BlockSnapShot
extends CommandBase {
    private ArrayList<BlockPos> corners = new ArrayList();
    public static StructureSnapshot snapshot;

    public String func_71517_b() {
        return "psnapshot";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + " <argument>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!(sender instanceof EntityPlayer) || args.length == 0) {
            CommandChatHandler.sendChat(sender, this.func_71518_a(sender), new Object[0]);
            return;
        }
        EntityPlayer player = (EntityPlayer)sender;
        World world = player.field_70170_p;
        if (args[0].equals("set")) {
            this.corners.add(player.func_180425_c());
            if (this.corners.size() > 2) {
                this.corners.remove(0);
            }
            CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.corners", new Object[0]);
            for (BlockPos p : this.corners) {
                CommandChatHandler.sendChat(sender, p.toString(), new Object[0]);
            }
        } else if (args[0].equals("save")) {
            if (this.corners.size() < 2) {
                CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.nobounds", new Object[0]);
                return;
            }
            BlockPos corner0 = this.corners.get(0);
            BlockPos corner1 = this.corners.get(1);
            int x0 = corner0.func_177958_n();
            int x1 = corner1.func_177958_n();
            int y0 = corner0.func_177956_o();
            int y1 = corner1.func_177956_o();
            int z0 = corner0.func_177952_p();
            int z1 = corner1.func_177952_p();
            int minX = Math.min(x0, x1);
            int maxX = Math.max(x0, x1);
            int minY = Math.min(y0, y1);
            int maxY = Math.max(y0, y1);
            int minZ = Math.min(z0, z1);
            int maxZ = Math.max(z0, z1);
            snapshot = StructureSnapshot.from(minX, maxX, minY, maxY, minZ, maxZ, world);
            AxisAlignedBB aabb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List trainers = world.func_72872_a(NPCTrainer.class, aabb);
            for (Object trainer : trainers) {
                Pixelmon.LOGGER.info("Trainer position: " + (((NPCTrainer)((Object)trainer)).field_70165_t - (double)minX) + " " + (((NPCTrainer)((Object)trainer)).field_70163_u - (double)minY) + " " + (((NPCTrainer)((Object)trainer)).field_70161_v - (double)minZ));
            }
            List chattingNPCS = world.func_72872_a(NPCChatting.class, aabb);
            for (NPCChatting npc : chattingNPCS) {
                Pixelmon.LOGGER.info("Chatting NPC position: " + (npc.field_70165_t - (double)minX) + " " + (npc.field_70163_u - (double)minY) + " " + (npc.field_70161_v - (double)minZ));
            }
            if (args.length > 1) {
                String baseDirectory = Pixelmon.modDirectory + "/snapshots/";
                String filename = baseDirectory + args[1] + ".snapshot";
                File saveFile = new File(filename);
                File saveDirPath = new File(baseDirectory);
                if (!saveDirPath.exists()) {
                    saveDirPath.mkdirs();
                }
                try (DataOutputStream out = new DataOutputStream(new FileOutputStream(saveFile));){
                    NBTTagCompound compound = new NBTTagCompound();
                    snapshot.writeToNBT(compound);
                    CompressedStreamTools.func_74800_a((NBTTagCompound)compound, (DataOutput)out);
                    CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.savefile", args[1]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.save", new Object[0]);
            }
        } else if (args[0].equals("read") && args.length > 1) {
            String filename = Pixelmon.modDirectory + "/snapshots/" + args[1] + ".snapshot";
            File saveFile = new File(filename);
            try {
                NBTTagCompound compound = CompressedStreamTools.func_74797_a((File)saveFile);
                snapshot = StructureSnapshot.readFromNBT(compound);
                CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.load", args[1]);
            }
            catch (Exception e) {
                e.printStackTrace();
                CommandChatHandler.sendFormattedChat(sender, TextFormatting.RED, "pixelmon.command.snapshot.errorread", args[1]);
                return;
            }
        } else if (args[0].equals("place")) {
            this.place(server, sender, player, world);
        } else {
            CommandChatHandler.sendChat(sender, this.func_71518_a(sender), new Object[0]);
        }
    }

    private void place(MinecraftServer server, ICommandSender sender, EntityPlayer player, World world) {
        BlockPos newPos;
        int z;
        int x;
        int y;
        if (snapshot == null) {
            CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.nosave", new Object[0]);
            return;
        }
        BlockPos basePos = player.func_180425_c();
        int rotation = (int)Math.abs(player.func_70079_am()) % 360;
        EnumFacing facing = rotation < 45 ? EnumFacing.NORTH : (rotation < 135 ? EnumFacing.EAST : (rotation < 225 ? EnumFacing.SOUTH : (rotation < 315 ? EnumFacing.WEST : EnumFacing.NORTH)));
        ArrayList<BlockPos> multiblocks = new ArrayList<BlockPos>();
        int width = snapshot.getWidth();
        int height = snapshot.getHeight();
        int length = snapshot.getLength();
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (z = 0; z < length; ++z) {
                    PixelBlockSnapshot Psnapshot = snapshot.getBlockAt(x, y, z);
                    Psnapshot.world = world;
                    if (Psnapshot.getReplacedBlock().func_185904_a() == Material.field_151594_q) continue;
                    newPos = this.getPos(x, y, z, basePos, facing);
                    Psnapshot.restoreToLocationWithRotation(newPos, facing, y, false);
                    if (!(world.func_180495_p(newPos).func_177230_c() instanceof MultiBlock)) continue;
                    multiblocks.add(newPos);
                }
            }
        }
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                for (z = 0; z < length; ++z) {
                    PixelBlockSnapshot snapshot = BlockSnapShot.snapshot.getBlockAt(x, y, z);
                    snapshot.world = world;
                    if (snapshot.getReplacedBlock().func_185904_a() == Material.field_151594_q) {
                        newPos = this.getPos(x, y, z, basePos, facing);
                        snapshot.restoreToLocationWithRotation(newPos, facing, y, false);
                        if (!(world.func_180495_p(newPos).func_177230_c() instanceof MultiBlock)) continue;
                        multiblocks.add(newPos);
                        continue;
                    }
                    if (y + 1 >= height) continue;
                    PixelBlockSnapshot nextSnapshot = BlockSnapShot.snapshot.getBlockAt(x, y, z);
                    snapshot.world = world;
                    if (!(snapshot.getReplacedBlock().func_177230_c() instanceof BlockDoublePlant) || !(nextSnapshot.getReplacedBlock().func_177230_c() instanceof BlockDoublePlant)) continue;
                    BlockPos newPos2 = this.getPos(x, y, z, basePos, facing);
                    snapshot.restoreToLocationWithRotation(newPos2, facing, y, false);
                }
            }
        }
        for (BlockPos pos : multiblocks) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!(block instanceof MultiBlock)) continue;
            EnumFacing blockRot = (EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING);
            PixelmonItemBlock.setMultiBlocksWidth(pos, blockRot, world, (MultiBlock)block, block, null);
        }
        for (NBTTagCompound statueTag : snapshot.getStatues()) {
            EntityStatue statue = new EntityStatue(world);
            statue.func_70020_e(statueTag);
            double posX = statue.field_70165_t;
            double posY = statue.field_70163_u;
            double posZ = statue.field_70161_v;
            double x2 = 0.0;
            double y2 = 0.0;
            double z2 = 0.0;
            if (facing == EnumFacing.EAST) {
                x2 = posX + (double)basePos.func_177958_n();
                y2 = posY + (double)basePos.func_177956_o();
                z2 = posZ + (double)basePos.func_177952_p();
            } else if (facing == EnumFacing.SOUTH) {
                x2 = -1.0 * posZ + 1.0 + (double)basePos.func_177958_n();
                y2 = posY + (double)basePos.func_177956_o();
                z2 = posX + (double)basePos.func_177952_p();
            } else if (facing == EnumFacing.WEST) {
                x2 = -1.0 * posX + 1.0 + (double)basePos.func_177958_n();
                y2 = posY + (double)basePos.func_177956_o();
                z2 = -1.0 * posZ + 1.0 + (double)basePos.func_177952_p();
            } else if (facing == EnumFacing.NORTH) {
                x2 = posZ + (double)basePos.func_177958_n();
                y2 = posY + (double)basePos.func_177956_o();
                z2 = -1.0 * posX + 1.0 + (double)basePos.func_177952_p();
            }
            if (facing != EnumFacing.EAST) {
                if (facing == EnumFacing.WEST) {
                    statue.setRotation(statue.getRotation() + 180.0f);
                } else if (facing == EnumFacing.NORTH) {
                    statue.setRotation(statue.getRotation() - 90.0f);
                } else if (facing == EnumFacing.SOUTH) {
                    statue.setRotation(statue.getRotation() + 90.0f);
                }
                statue.field_70126_B = statue.field_70177_z;
            }
            statue.func_70107_b(x2, y2, z2);
            statue.func_184221_a(UUID.randomUUID());
            world.func_72838_d((Entity)statue);
        }
        CommandChatHandler.sendChat(sender, "pixelmon.command.snapshot.place", new Object[0]);
    }

    private BlockPos getPos(int x, int y, int z, BlockPos basePos, EnumFacing facing) {
        if (facing == EnumFacing.EAST) {
            return new BlockPos(x + basePos.func_177958_n(), y + basePos.func_177956_o(), z + basePos.func_177952_p());
        }
        if (facing == EnumFacing.SOUTH) {
            return new BlockPos(-1 * z + basePos.func_177958_n(), y + basePos.func_177956_o(), x + basePos.func_177952_p());
        }
        if (facing == EnumFacing.WEST) {
            return new BlockPos(-1 * x + basePos.func_177958_n(), y + basePos.func_177956_o(), -1 * z + basePos.func_177952_p());
        }
        if (facing == EnumFacing.NORTH) {
            return new BlockPos(z + basePos.func_177958_n(), y + basePos.func_177956_o(), -1 * x + basePos.func_177952_p());
        }
        return null;
    }
}

