/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.events.BreedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.specs.UnbreedableFlag;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.helpers.BreedLogic;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BreedCommand
extends PixelmonCommand {
    public BreedCommand() {
        super("breed", "/breed <username> <party slot #1> <party slot #2>", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1 || args.length == 3) {
            EntityPlayerMP player = BreedCommand.requireEntityPlayer(args[0]);
            PlayerPartyStorage storage = BreedCommand.require(BreedCommand.getPlayerStorage(player), "pixelmon.command.general.invalidplayer", new Object[0]);
            int slot1 = BreedCommand.requireInt(args[1], 1, 6, "pixelmon.command.breed.invalidslot", args[1]);
            int slot2 = BreedCommand.requireInt(args[2], 1, 6, "pixelmon.command.breed.invalidslot", args[2]);
            Pokemon pokemon1 = BreedCommand.require(storage.get(slot1 - 1), "pixelmon.command.breed.nullslot", slot1);
            Pokemon pokemon2 = BreedCommand.require(storage.get(slot2 - 1), "pixelmon.command.breed.nullslot", slot2);
            BreedCommand.require(!pokemon1.isEgg(), "pixelmon.command.breed.egg", pokemon2.getDisplayName());
            BreedCommand.require(!pokemon2.isEgg(), "pixelmon.command.breed.egg", pokemon1.getDisplayName());
            BreedCommand.require(pokemon1 != pokemon2, "pixelmon.command.breed.same", pokemon1.getDisplayName());
            BreedCommand.require(BreedLogic.canBreed(pokemon1, pokemon2), "pixelmon.command.breed.notcompatible", pokemon1.getDisplayName(), pokemon2.getDisplayName());
            if (UnbreedableFlag.UNBREEDABLE.matches(pokemon1)) {
                BreedCommand.endCommand("pixelmon.ranch.cannotbreed", pokemon1.getDisplayName());
            } else if (UnbreedableFlag.UNBREEDABLE.matches(pokemon2)) {
                BreedCommand.endCommand("pixelmon.ranch.cannotbreed", pokemon2.getDisplayName());
            }
            Pokemon egg = BreedLogic.makeEgg(pokemon1, pokemon2);
            BreedEvent.MakeEgg makeEvent = new BreedEvent.MakeEgg(player.func_110124_au(), null, egg, pokemon1, pokemon2);
            if (Pixelmon.EVENT_BUS.post((Event)makeEvent)) {
                return;
            }
            BreedEvent.CollectEgg eggEvent = new BreedEvent.CollectEgg(player.func_110124_au(), null, makeEvent.getEgg());
            if (Pixelmon.EVENT_BUS.post((Event)eggEvent)) {
                return;
            }
            this.sendMessage(sender, "pixelmon.command.breed.giveegg", pokemon1.getDisplayName(), pokemon2.getDisplayName());
            storage.add(eggEvent.getEgg());
        } else {
            sender.func_145747_a(BreedCommand.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]));
            BreedCommand.endCommand(this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return BreedCommand.tabCompleteUsernames(args);
        }
        if (args.length == 2 || args.length == 3) {
            return BreedCommand.tabComplete(args, "1", "2", "3", "4", "5", "6");
        }
        return BreedCommand.tabComplete(args, new String[0]);
    }
}

