/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendarySpawnEvent;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnerCoordinator;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.spawning.LegendarySpawner;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.StringUtils;

public class DoLegendarySpawnCommand
extends PixelmonCommand {
    public DoLegendarySpawnCommand() {
        super("dolegendaryspawn", "/dolegendaryspawn [player]", 4);
        this.aliases.add("legendaryspawn");
        this.aliases.add("spawnlegendary");
    }

    @Override
    protected void execute(ICommandSender sender, String[] args) throws CommandException {
        if (DoLegendarySpawnCommand.getServer().func_184103_al().func_72394_k() == 0) {
            DoLegendarySpawnCommand.endCommand("spawning.error.nooneisonline", new Object[0]);
        }
        EntityPlayerMP target = args.length == 1 ? (StringUtils.equalsAnyIgnoreCase((CharSequence)args[0], (CharSequence[])new CharSequence[]{"any", "random"}) ? (EntityPlayerMP)RandomHelper.getRandomElementFromList(DoLegendarySpawnCommand.getServer().func_184103_al().func_181057_v()) : DoLegendarySpawnCommand.requireEntityPlayer(args[0])) : (sender instanceof EntityPlayerMP ? DoLegendarySpawnCommand.requireEntityPlayer(sender) : (EntityPlayerMP)RandomHelper.getRandomElementFromList(DoLegendarySpawnCommand.getServer().func_184103_al().func_181057_v()));
        boolean isCoordinatorActive = PixelmonSpawning.coordinator.getActive();
        AbstractSpawner abstrSpawner = PixelmonSpawning.coordinator.getSpawner("legendary");
        if (abstrSpawner == null) {
            abstrSpawner = PixelmonSpawning.legendarySpawner;
        }
        LegendarySpawner spawner = (LegendarySpawner)DoLegendarySpawnCommand.require(abstrSpawner, "spawning.error.legendaryspawnermissing", new Object[0]);
        sender.func_145747_a(DoLegendarySpawnCommand.format(TextFormatting.GRAY, "spawning.attemptlegendaryspawn", new Object[0]));
        if (isCoordinatorActive) {
            spawner.forcefullySpawn(target);
        } else {
            this.forcefullySpawn(target, spawner);
        }
        Runnable r = () -> {
            if (spawner.possibleSpawns != null && !spawner.possibleSpawns.isEmpty()) {
                spawner.possibleSpawns.forEach(spawn -> {
                    spawn.spawnInfo.tags.forEach(tag -> BetterSpawnerConfig.intervalTimes.remove(tag));
                    PixelmonCommand.getServer().func_152344_a(() -> spawn.doSpawn(spawner));
                });
                spawner.possibleSpawns = null;
            } else {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.effect.effectfailed", new Object[0]);
                this.sendMessage(sender, TextFormatting.GRAY, "/checkspawns legendary", new Object[0]);
            }
        };
        if (isCoordinatorActive) {
            SpawnerCoordinator.PROCESSOR.execute(r);
        } else {
            Processor.instance.addProcess(r);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return DoLegendarySpawnCommand.tabCompleteUsernames(args);
        }
        return DoLegendarySpawnCommand.tabComplete(args, new String[0]);
    }

    private void forcefullySpawn(@Nullable EntityPlayerMP onlyFocus, LegendarySpawner spawner) {
        ArrayList<ArrayList<EntityPlayerMP>> clusters = new ArrayList<ArrayList<EntityPlayerMP>>();
        ArrayList<EntityPlayerMP> players = new ArrayList<EntityPlayerMP>(DoLegendarySpawnCommand.getServer().func_184103_al().func_181057_v());
        if (onlyFocus == null) {
            while (!players.isEmpty()) {
                ArrayList<EntityPlayerMP> cluster = new ArrayList<EntityPlayerMP>();
                EntityPlayerMP focus = (EntityPlayerMP)players.remove(0);
                cluster.add(focus);
                LegendarySpawner.fillNearby(players, cluster, focus);
                clusters.add(cluster);
            }
        }
        spawner.isBusy = true;
        Processor.instance.addProcess(() -> {
            if (onlyFocus != null) {
                spawner.possibleSpawns = spawner.doLegendarySpawn(onlyFocus);
            } else {
                Collections.shuffle(clusters);
                while (clusters.size() > 0) {
                    for (int i = 0; i < clusters.size(); ++i) {
                        EntityPlayerMP player = (EntityPlayerMP)CollectionHelper.getRandomElement((List)clusters.get(i));
                        ((ArrayList)clusters.get(i)).remove(player);
                        if (((ArrayList)clusters.get(i)).isEmpty()) {
                            clusters.remove(i--);
                        }
                        if (spawner.firesChooseEvent) {
                            LegendarySpawnEvent.ChoosePlayer event = new LegendarySpawnEvent.ChoosePlayer(spawner, player, clusters);
                            if (Pixelmon.EVENT_BUS.post((Event)event) || event.player == null) continue;
                            player = event.player;
                        }
                        spawner.possibleSpawns = spawner.doLegendarySpawn(player);
                        if (spawner.possibleSpawns == null) continue;
                        spawner.isBusy = false;
                        return;
                    }
                }
            }
            spawner.isBusy = false;
        });
    }

    public static class Processor {
        public static final Processor instance = new Processor();
        private ThreadFactory namedThreadFactory = new NamedThreadFactory();
        private ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(), this.namedThreadFactory);

        public void addProcess(Runnable process) {
            this.executor.execute(process);
        }

        private static class NamedThreadFactory
        implements ThreadFactory {
            private NamedThreadFactory() {
            }

            @Override
            public Thread newThread(Runnable arg0) {
                Thread t = new Thread(arg0);
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(new UncaughtExceptionHandler());
                t.setName("DoLegendarySpawnCommand-Spawner");
                return t;
            }
        }

        private static class UncaughtExceptionHandler
        implements Thread.UncaughtExceptionHandler {
            private UncaughtExceptionHandler() {
            }

            @Override
            public void uncaughtException(Thread arg0, Throwable arg1) {
                Pixelmon.LOGGER.error("Caught Exception from \"" + arg0.getName() + "\"", arg1);
            }
        }
    }
}

