/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.mojang.authlib.GameProfile;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.events.PokedexEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.pokedex.EnumPokedexRegisterStatus;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;

public class PokeGiveCommand
extends PixelmonCommand {
    public PokeGiveCommand() {
        super("pokegive", "/pokegive [player] <pokemon>", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length >= 1) {
            this.resendWithMultipleTargets(sender, args, 0);
            GameProfile profile = EnumSpecies.hasPokemonAnyCase(args[0]) && sender.func_184102_h().func_184103_al().func_152612_a(args[0]) == null ? PokeGiveCommand.requireEntityPlayer(sender).func_146103_bH() : PokeGiveCommand.findProfile(args[0]);
            if (profile == null) {
                PokeGiveCommand.endCommand("commands.generic.player.notFound", args[0]);
            }
            EntityPlayerMP player = PokeGiveCommand.getEntityPlayer(profile.getId());
            try {
                if (profile.getName().equalsIgnoreCase(args[0])) {
                    args = Arrays.copyOfRange(args, 1, args.length);
                }
                PokemonSpec spec = PokemonSpec.from(args);
                spec.boss = null;
                PlayerPartyStorage pps = Pixelmon.storageManager.getParty(profile.getId());
                if (spec.name == null) {
                    PokeGiveCommand.endCommand("pixelmon.command.general.invalid", new Object[0]);
                }
                Pokemon pokemon = spec.create();
                if (player != null) {
                    Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent(player, ReceiveType.Command, pokemon));
                }
                if (player != null && BattleRegistry.getBattle((EntityPlayer)player) != null) {
                    Pixelmon.storageManager.getPCForPlayer(profile.getId()).add(pokemon);
                } else {
                    pps.add(pokemon);
                }
                if (!pokemon.isEgg() && !Pixelmon.EVENT_BUS.post((Event)new PokedexEvent(pps.uuid, pokemon, EnumPokedexRegisterStatus.caught, "commandGiven"))) {
                    pps.pokedex.set(pokemon, EnumPokedexRegisterStatus.caught);
                    pps.pokedex.update();
                }
                this.sendMessage(sender, "pixelmon.command.give.givesuccess" + (pokemon.isEgg() ? "egg" : ""), profile.getName(), pokemon.getSpecies().getTranslatedName());
                PokeGiveCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)("pixelmon.command.give.notifygive" + (pokemon.isEgg() ? "egg" : "")), (Object[])new Object[]{sender.func_70005_c_(), profile.getName(), pokemon.getSpecies().getTranslatedName()});
            }
            catch (NullPointerException npe) {
                PokeGiveCommand.endCommand("pixelmon.command.general.notingame", args[0]);
            }
        } else {
            sender.func_145747_a(PokeGiveCommand.format(TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]));
            PokeGiveCommand.endCommand(this.func_71518_a(sender), new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            List<String> list = PokeGiveCommand.tabCompleteUsernames(args);
            if (!list.isEmpty()) {
                return list;
            }
            return PokeGiveCommand.tabCompletePokemon(args);
        }
        return args.length == 2 ? PokeGiveCommand.tabCompletePokemon(args) : PokeGiveCommand.tabComplete(args, new String[0]);
    }
}

