/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;

public class TeachCommand
extends PixelmonCommand {
    public TeachCommand() {
        super("teach", "/teach <player> <slot> <move>", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            this.sendMessage(sender, TextFormatting.RED, this.func_71518_a(sender), new Object[0]);
        } else if (args.length == 1) {
            this.execute(sender, new String[]{sender.func_70005_c_(), "1", args[0]});
        } else if (args.length == 2) {
            this.execute(sender, new String[]{sender.func_70005_c_(), args[0], args[1]});
        } else {
            Attack attack;
            EntityPlayerMP player = TeachCommand.requireEntityPlayer(args[0]);
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
            if (BattleRegistry.getBattle((EntityPlayer)player) != null) {
                TeachCommand.endCommand("pixelmon.command.general.inbattle", new Object[0]);
            }
            if (party.guiOpened) {
                TeachCommand.endCommand("pixelmon.command.teach.busy", player.getDisplayNameString());
            }
            int slot = TeachCommand.requireInt(args[1], 1, 6, "pixelmon.command.teach.slot", new Object[0]);
            Pokemon pokemon = TeachCommand.require(party.get(slot - 1), "pixelmon.command.teach.nothing", player.getDisplayNameString());
            String attackName = StringUtils.join((Object[])args, (String)" ", (int)2, (int)args.length);
            if (Attack.hasAttack(attackName = attackName.replace('_', ' '))) {
                attack = new Attack(attackName);
            } else {
                try {
                    int attackIndex = TeachCommand.requireInt(attackName, "");
                    if (!Attack.hasAttack(attackIndex)) {
                        TeachCommand.endCommand("pixelmon.command.teach.nomove", attackName);
                        return;
                    }
                    attack = new Attack(attackIndex);
                }
                catch (CommandException e) {
                    TeachCommand.endCommand("pixelmon.command.teach.nomove", attackName);
                    return;
                }
            }
            if (attack.getMove().getAttackId() >= 10000 || attack.getMove().getAttackId() < 0) {
                ChatHandler.sendChat((Entity)player, "pixelmon.interaction.tmcantlearn", pokemon.getNickname(), attack.getMove().getTranslatedName());
                return;
            }
            if (!pokemon.getMoveset().hasAttack(attack)) {
                if (pokemon.getMoveset().size() >= 4) {
                    LearnMoveController.sendLearnMove(player, pokemon.getUUID(), attack.getActualMove());
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.teach.sentmove", player.getDisplayNameString(), pokemon.getDisplayName(), attack.getActualMove().getTranslatedName());
                } else {
                    pokemon.getMoveset().add(attack);
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.stats.learnedmove", pokemon.getDisplayName(), attack.getActualMove().getTranslatedName());
                }
            } else {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.teach.knowsmove", player.getDisplayNameString(), pokemon.getDisplayName(), attack.getActualMove().getTranslatedName());
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return TeachCommand.tabCompleteUsernames(args);
        }
        if (args.length == 2) {
            return TeachCommand.tabComplete(args, "1", "2", "3", "4", "5", "6");
        }
        if (args.length == 3) {
            ArrayList<String> list = new ArrayList<String>(AttackBase.getAllAttackNames());
            list.replaceAll(s -> s.replace(" ", "_"));
            return TeachCommand.tabComplete(args, list);
        }
        return TeachCommand.tabComplete(args, new String[0]);
    }
}

