/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands.client;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.GuiExtrasEditor;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayerExtrasPacket;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.IClientCommand;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.StringUtils;

public class RedeemCommand
extends PixelmonCommand
implements IClientCommand {
    @Override
    public String func_71517_b() {
        return "redeem";
    }

    @Override
    public String func_71518_a(ICommandSender icommandsender) {
        return "/redeem <slot number/hat name/remove hat/toggle sash>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayer player = (EntityPlayer)sender;
        PixelExtrasData data = PlayerExtraDataStore.get(player);
        if (args.length == 0) {
            PlayerExtraDataStore.refreshClient(newData -> {
                StringJoiner joiner = new StringJoiner(", ");
                StringBuilder sb = new StringBuilder("Available: ");
                if (newData.hasData()) {
                    for (EnumSpecies species : newData.getAvailableTextures()) {
                        if (species == EnumSpecies.Lugia) {
                            joiner.add("shadow_lugia");
                        }
                        if (species == EnumSpecies.Haunter) {
                            joiner.add("spectral_jeweller");
                            continue;
                        }
                        if (species != EnumSpecies.Wobbuffet) continue;
                        joiner.add("wobeefet");
                    }
                } else {
                    this.sendMessage(sender, "pixelmon.command.redeem.nodata", new Object[0]);
                    return;
                }
                if (sb.length() > 12) {
                    player.func_145747_a((ITextComponent)new TextComponentString(sb.append(joiner).toString()));
                }
                this.sendMessage(sender, "pixelmon.command.redeem.gui", new Object[0]);
            });
        } else if (data.hasData()) {
            if (args.length == 1 && args[0].equalsIgnoreCase("gui")) {
                ClientProxy.scheduleNextTick(() -> {
                    Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiExtrasEditor());
                    return 0;
                });
            } else if (args.length == 2 && StringUtils.equalsAnyIgnoreCase((CharSequence)args[0], (CharSequence[])new CharSequence[]{"enable", "disable", "toggle"}) && StringUtils.equalsAnyIgnoreCase((CharSequence)args[1], (CharSequence[])new CharSequence[]{"hat", "sash", "robe", "monocle"})) {
                PixelExtrasData.Category category;
                PixelExtrasData.Category category2 = args[1].equalsIgnoreCase("hat") ? PixelExtrasData.Category.HAT : (args[1].equalsIgnoreCase("sash") ? PixelExtrasData.Category.SASH : (category = args[1].equalsIgnoreCase("robe") ? PixelExtrasData.Category.ROBE : PixelExtrasData.Category.MONOCLE));
                if (args[0].equalsIgnoreCase("enable")) {
                    data.setEnabled(category, true);
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", category.toString().toLowerCase());
                } else if (args[0].equalsIgnoreCase("disable")) {
                    data.setEnabled(category, false);
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.disabled", category.toString().toLowerCase());
                } else if (args[0].equalsIgnoreCase("toggle")) {
                    data.setEnabled(category, !data.isEnabled(category));
                    if (data.isEnabled(category)) {
                        this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", category.toString().toLowerCase());
                    } else {
                        this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.disabled", category.toString().toLowerCase());
                    }
                    PlayerExtraDataStore.saveAndSend();
                } else {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
                }
            } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)args[0], (CharSequence[])new CharSequence[]{"trainerhat", "trainercap"})) {
                if (data.setHatType(PixelExtrasData.HatType.TRAINER_CAP)) {
                    if (args.length == 4) {
                        try {
                            int r = Integer.parseInt(args[1]);
                            int g = Integer.parseInt(args[2]);
                            int b = Integer.parseInt(args[3]);
                            if (r > 255 || r < -1 || g > 255 || g < 0 || b > 255 || b < 0) {
                                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                            } else {
                                data.setColours(PixelExtrasData.Category.HAT, new int[]{r, g, b});
                            }
                        }
                        catch (NumberFormatException e) {
                            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                        }
                    }
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "trainercap");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("sash")) {
                if (args.length == 2) {
                    if (args[1].equalsIgnoreCase("regular")) {
                        if (data.setSashType(PixelExtrasData.SashType.REGULAR)) {
                            PlayerExtraDataStore.saveAndSend();
                            this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "regular sash");
                        } else {
                            RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                        }
                    } else if (args[1].equalsIgnoreCase("rainbow")) {
                        if (data.setSashType(PixelExtrasData.SashType.RAINBOW)) {
                            PlayerExtraDataStore.saveAndSend();
                            this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "rainbow sash");
                        } else {
                            RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                        }
                    } else if (args[1].equalsIgnoreCase("booster")) {
                        if (data.setSashType(PixelExtrasData.SashType.BOOSTER)) {
                            PlayerExtraDataStore.saveAndSend();
                            this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "booster sash");
                        } else {
                            RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                        }
                    } else if (args[1].equalsIgnoreCase("admin")) {
                        if (data.setSashType(PixelExtrasData.SashType.RANK_ADMIN)) {
                            PlayerExtraDataStore.saveAndSend();
                            this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "admin sash");
                        } else {
                            RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                        }
                    } else if (args[1].equalsIgnoreCase("jr")) {
                        if (data.setSashType(PixelExtrasData.SashType.RANK_JR)) {
                            PlayerExtraDataStore.saveAndSend();
                            this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "jr sash");
                        } else {
                            RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                        }
                    } else if (args[1].equalsIgnoreCase("dev")) {
                        if (data.setSashType(PixelExtrasData.SashType.RANK_DEV)) {
                            PlayerExtraDataStore.saveAndSend();
                            this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "dev sash");
                        } else {
                            RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                        }
                    } else if (args[1].equalsIgnoreCase("modeler")) {
                        if (data.setSashType(PixelExtrasData.SashType.RANK_MODELER)) {
                            PlayerExtraDataStore.saveAndSend();
                            this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "modeler sash");
                        } else {
                            RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                        }
                    } else if (args[1].equalsIgnoreCase("support")) {
                        if (data.setSashType(PixelExtrasData.SashType.RANK_SUPPORT)) {
                            PlayerExtraDataStore.saveAndSend();
                            this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "support sash");
                        } else {
                            RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                        }
                    } else {
                        this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
                    }
                } else if (args.length == 4 && data.getSashType() == PixelExtrasData.SashType.REGULAR) {
                    try {
                        int r = Integer.parseInt(args[1]);
                        int g = Integer.parseInt(args[2]);
                        int b = Integer.parseInt(args[3]);
                        if (r > 255 || r < -1 || g > 255 || g < 0 || b > 255 || b < 0) {
                            this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                        } else {
                            data.setColours(PixelExtrasData.Category.SASH, new int[]{r, g, b});
                        }
                    }
                    catch (NumberFormatException e) {
                        this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.trainerhat.invalidcolour", new Object[0]);
                    }
                    PlayerExtraDataStore.saveAndSend();
                }
            } else if (args[0].equalsIgnoreCase("tophat")) {
                if (data.setHatType(PixelExtrasData.HatType.TOP_HAT)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "tophat");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("fez")) {
                if (data.setHatType(PixelExtrasData.HatType.FEZ)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "fez");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("fedora")) {
                if (data.setHatType(PixelExtrasData.HatType.FEDORA)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "fedora");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("blackmonocle")) {
                if (data.setMonocleType(PixelExtrasData.MonocleType.BLACK_MONOCLE)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "blackmonocle");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("goldmonocle")) {
                if (data.setMonocleType(PixelExtrasData.MonocleType.GOLD_MONOCLE)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "goldmonocle");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("pikahood")) {
                if (data.setHatType(PixelExtrasData.HatType.PIKA_HOOD)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "pikahood");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("eeveehood")) {
                if (data.setHatType(PixelExtrasData.HatType.EEVEE_HOOD)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "eeveehood");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("scorhood")) {
                if (data.setHatType(PixelExtrasData.HatType.SCOR_HOOD)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "scorhood");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("wizardrobe") || args[0].equalsIgnoreCase("wizardrobe") || args[0].equalsIgnoreCase("robe")) {
                if (data.setRobeType(PixelExtrasData.RobeType.WIZARD)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "wizardrobe");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("alterrobe") || args[0].equalsIgnoreCase("alter")) {
                if (data.setRobeType(PixelExtrasData.RobeType.ALTER)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "alterrobe");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("wiki") || args[0].equalsIgnoreCase("grandcap")) {
                if (data.setHatType(PixelExtrasData.HatType.WIKI)) {
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "grandcap");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (args[0].equalsIgnoreCase("spheal_hat") || args[0].equalsIgnoreCase("sphealhat")) {
                if (data.setHatType(PixelExtrasData.HatType.SPHEAL_HAT)) {
                    data.randomiseSpheal();
                    PlayerExtraDataStore.saveAndSend();
                    this.sendMessage(sender, TextFormatting.GREEN, "pixelmon.command.general.enabled", "sphealhat");
                } else {
                    RedeemCommand.endCommand("pixelmon.command.general.cannot", new Object[0]);
                }
            } else if (!data.getAvailableTextures().isEmpty()) {
                try {
                    int slot = Integer.parseInt(args[0]);
                    Pixelmon.network.sendToServer((IMessage)PlayerExtrasPacket.getSetTexturePacket(slot));
                }
                catch (NumberFormatException e) {
                    this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
                }
            } else {
                this.sendMessage(sender, TextFormatting.RED, "pixelmon.command.general.invalid", new Object[0]);
            }
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        EntityPlayer player = (EntityPlayer)sender;
        PixelExtrasData data = PlayerExtraDataStore.get(player);
        if (!data.hasData()) {
            return Lists.newArrayList();
        }
        ArrayList list = Lists.newArrayList();
        if (data.hasData() && args.length == 1) {
            for (PixelExtrasData.HatType hatType : data.getAvailableHats()) {
                list.add(hatType.toString().toLowerCase().replace("_", ""));
            }
            for (PixelExtrasData.MonocleType monocleType : data.getAvailableMonocles()) {
                list.add(monocleType.toString().toLowerCase().replace("_", ""));
            }
            for (PixelExtrasData.RobeType robeType : data.getAvailableRobes()) {
                list.add(robeType.toString().toLowerCase() + "robe");
            }
            list.add("enable");
            list.add("disable");
            list.add("toggle");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("sash")) {
            for (PixelExtrasData.SashType sashType : data.getAvailableSashs()) {
                list.add(sashType.toString().toLowerCase().replace("rank_", ""));
            }
        }
        if (args.length == 2 && StringUtils.equalsAnyIgnoreCase((CharSequence)args[0], (CharSequence[])new CharSequence[]{"enable", "disable", "toggle"})) {
            list.add("sash");
            list.add("robe");
            list.add("hat");
            list.add("monocle");
        }
        return RedeemCommand.func_175762_a((String[])args, (Collection)list);
    }

    public boolean allowUsageWithoutPrefix(ICommandSender sender, String message) {
        return false;
    }
}

