/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.commands.quests;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.command.PixelmonCommand;
import com.pixelmonmod.pixelmon.quests.QuestProgress;
import com.pixelmonmod.pixelmon.quests.QuestRegistry;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.playerData.QuestData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class QuestDataCommand
extends PixelmonCommand {
    public QuestDataCommand() {
        super("questdata", "/questdata <quest> {numeric,literal} <key> [value]", 2);
    }

    @Override
    public void execute(ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 3 || args.length == 4) {
            boolean set;
            EntityPlayerMP player = QuestDataCommand.requireEntityPlayer(sender.func_70005_c_());
            boolean bl = set = args.length == 4;
            if (!args[1].equalsIgnoreCase("literal") && !args[1].equalsIgnoreCase("numeric")) {
                this.sendMessage(sender, "pixelmon.command.questdata.invalidargs", new Object[0]);
                return;
            }
            boolean numeric = args[1].equalsIgnoreCase("numeric");
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
            QuestData data = party.getQuestData();
            QuestProgress progress = QuestDataCommand.require(data.getProgressForQuest(args[0], true), "pixelmon.command.invalidquest", new Object[0]);
            if (set) {
                if (numeric) {
                    progress.setData(args[2], QuestDataCommand.requireInt(args[3], "commands.generic.num.invalid"));
                } else {
                    progress.setData(args[2], args[3]);
                }
                progress.sendTo(player);
                QuestDataCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.questdata.set.notify", (Object[])new Object[]{sender.func_70005_c_(), args[1], args[2], args[3], args[0].replace("_", " ")});
                this.sendMessage(sender, "pixelmon.command.questdata.set", args[1], args[2], args[3], args[0].replace("_", " "));
            } else {
                Object result = numeric ? progress.getDataLong(args[2]) : progress.getDataString(args[2]);
                QuestDataCommand.func_152374_a((ICommandSender)sender, (ICommand)this, (int)0, (String)"pixelmon.command.questdata.get.notify", (Object[])new Object[]{sender.func_70005_c_(), args[1], args[2], args[0].replace("_", " ")});
                this.sendMessage(sender, "pixelmon.command.questdata.get", args[1], args[2], result, args[0].replace("_", " "));
            }
        } else {
            this.sendMessage(sender, "pixelmon.command.questdata.invalidargs", new Object[0]);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        switch (args.length) {
            case 1: {
                return QuestDataCommand.tabComplete(args, QuestRegistry.getInstance().getQuestFilepaths(true));
            }
            case 2: {
                return Arrays.asList("numeric", "literal");
            }
        }
        return QuestDataCommand.tabComplete(args, new String[0]);
    }
}

