/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen1TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen2TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen3TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen4TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen5TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen6TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen7TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.ItemTM;
import com.pixelmonmod.pixelmon.items.ItemTechnicalMove;
import com.pixelmonmod.pixelmon.items.heldItems.ItemBlankTechnicalMachine;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PixelmonItemsTMs {
    public static final List<Item> HMs = new ArrayList<Item>();
    public static Item gen8TM;
    public static Item gen8BlankTM;
    public static Item gen8TR;
    public static Item gen8BlankTR;
    public static Item gen7TM;
    public static Item gen7BlankTM;
    public static Item gen6TM;
    public static Item gen6BlankTM;
    public static Item gen5TM;
    public static Item gen5BlankTM;
    public static Item gen4TM;
    public static Item gen4BlankTM;
    public static Item gen3TM;
    public static Item gen3BlankTM;
    public static Item gen2TM;
    public static Item gen2BlankTM;
    public static Item gen1TM;
    public static Item gen1BlankTM;
    private static final List<String> HMNames;

    public static ItemStack createStackFor(ITechnicalMove move) {
        return PixelmonItemsTMs.createStackFor(move, 1);
    }

    public static ItemStack createStackFor(ITechnicalMove move, int count) {
        ItemStack stack;
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74777_a("tm", (short)move.getId());
        if (move instanceof Gen8TechnicalRecords) {
            stack = new ItemStack(gen8TR, count, 0);
        } else if (move instanceof Gen8TechnicalMachines) {
            stack = new ItemStack(gen8TM, count, 0);
        } else if (move instanceof Gen7TechnicalMachines) {
            stack = new ItemStack(gen7TM, count, 0);
        } else if (move instanceof Gen6TechnicalMachines) {
            stack = new ItemStack(gen6TM, count, 0);
        } else if (move instanceof Gen5TechnicalMachines) {
            stack = new ItemStack(gen5TM, count, 0);
        } else if (move instanceof Gen4TechnicalMachines) {
            stack = new ItemStack(gen4TM, count, 0);
        } else if (move instanceof Gen3TechnicalMachines) {
            stack = new ItemStack(gen3TM, count, 0);
        } else if (move instanceof Gen2TechnicalMachines) {
            stack = new ItemStack(gen2TM, count, 0);
        } else if (move instanceof Gen1TechnicalMachines) {
            stack = new ItemStack(gen1TM, count, 0);
        } else {
            return null;
        }
        stack.func_77982_d(compound);
        return stack;
    }

    static void load() {
        for (String hm : HMNames) {
            HMs.add(new ItemTM(hm, HMNames.indexOf(hm) + 1));
        }
        gen8TM = new ItemTechnicalMove("tm_gen8");
        gen8BlankTM = new ItemBlankTechnicalMachine("tm8");
        gen8TR = new ItemTechnicalMove("tr_gen8");
        gen8BlankTR = new ItemBlankTechnicalMachine("tr8");
        gen7TM = new ItemTechnicalMove("tm_gen7");
        gen7BlankTM = new ItemBlankTechnicalMachine("tm_gen7");
        gen6TM = new ItemTechnicalMove("tm_gen6");
        gen6BlankTM = new ItemBlankTechnicalMachine("tm_gen6");
        gen5TM = new ItemTechnicalMove("tm_gen5");
        gen5BlankTM = new ItemBlankTechnicalMachine("tm_gen5");
        gen4TM = new ItemTechnicalMove("tm_gen4");
        gen4BlankTM = new ItemBlankTechnicalMachine("tm_gen4");
        gen3TM = new ItemTechnicalMove("tm_gen3");
        gen3BlankTM = new ItemBlankTechnicalMachine("tm_gen3");
        gen2TM = new ItemTechnicalMove("tm_gen2");
        gen2BlankTM = new ItemBlankTechnicalMachine("tm_gen2");
        gen1TM = new ItemTechnicalMove("tm_gen1");
        gen1BlankTM = new ItemBlankTechnicalMachine("tm_gen1");
    }

    static void registerItems(RegistryEvent.Register<Item> event) {
        PixelmonItemsTMs.load();
        for (Item item : HMs) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        event.getRegistry().register((IForgeRegistryEntry)gen8TM);
        event.getRegistry().register((IForgeRegistryEntry)gen8BlankTM);
        event.getRegistry().register((IForgeRegistryEntry)gen8TR);
        event.getRegistry().register((IForgeRegistryEntry)gen8BlankTR);
        event.getRegistry().register((IForgeRegistryEntry)gen7TM);
        event.getRegistry().register((IForgeRegistryEntry)gen7BlankTM);
        event.getRegistry().register((IForgeRegistryEntry)gen6TM);
        event.getRegistry().register((IForgeRegistryEntry)gen6BlankTM);
        event.getRegistry().register((IForgeRegistryEntry)gen5TM);
        event.getRegistry().register((IForgeRegistryEntry)gen5BlankTM);
        event.getRegistry().register((IForgeRegistryEntry)gen4TM);
        event.getRegistry().register((IForgeRegistryEntry)gen4BlankTM);
        event.getRegistry().register((IForgeRegistryEntry)gen3TM);
        event.getRegistry().register((IForgeRegistryEntry)gen3BlankTM);
        event.getRegistry().register((IForgeRegistryEntry)gen2TM);
        event.getRegistry().register((IForgeRegistryEntry)gen2BlankTM);
        event.getRegistry().register((IForgeRegistryEntry)gen1TM);
        event.getRegistry().register((IForgeRegistryEntry)gen1BlankTM);
    }

    static void registerRenderers() {
        try {
            for (Item item : HMs) {
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
            }
            for (Item base : new Item[]{gen8BlankTM, gen8BlankTR, gen7BlankTM, gen6BlankTM, gen5BlankTM, gen4BlankTM, gen3BlankTM, gen2BlankTM, gen1BlankTM}) {
                ModelLoader.setCustomModelResourceLocation((Item)base, (int)0, (ModelResourceLocation)new ModelResourceLocation(base.getRegistryName(), "inventory"));
            }
            for (Item base : new Item[]{gen8TM, gen8TR, gen7TM, gen6TM, gen5TM, gen4TM, gen3TM, gen2TM, gen1TM}) {
                ModelLoader.setCustomModelResourceLocation((Item)base, (int)0, (ModelResourceLocation)new ModelResourceLocation(base.getRegistryName(), "inventory"));
                for (ITechnicalMove move : ITechnicalMove.getAllFor(((ItemTechnicalMove)base).type())) {
                    ModelLoader.setCustomModelResourceLocation((Item)base, (int)move.getId(), (ModelResourceLocation)new ModelResourceLocation(base.getRegistryName(), "inventory"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        HMNames = Lists.newArrayList((Object[])new String[]{"Cut", "Fly", "Surf", "Strength", "Defog", "Rock Smash", "Waterfall", "Rock Climb", "Whirlpool", "Dive"});
    }
}

