/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.NPCChatEvent;
import com.pixelmonmod.pixelmon.api.events.npc.NPCEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.SetNPCData;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumNPCType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.ItemFishingRod;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class NPCFisherman
extends NPCChatting {
    public NPCFisherman(World world) {
        super(world);
        this.npcLocation = SpawnLocationType.LandVillager;
    }

    @Override
    public String getDisplayText() {
        return I18n.func_74838_a((String)"pixelmon.npc.fishermanname");
    }

    @Override
    public String getTexture() {
        return "pixelmon:textures/steve/oldfisherman.png";
    }

    @Override
    public boolean interactWithNPC(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (Pixelmon.EVENT_BUS.post((Event)new NPCEvent.Interact(this, EnumNPCType.OldFisherman, (EntityPlayer)playerMP))) {
                return false;
            }
            String loc = playerMP.field_71148_cg;
            ArrayList<String> chat = new ArrayList<String>();
            if (!itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemFishingRod) {
                chat.add("gui.oldfisherman.assess");
                if (!itemstack.func_77942_o()) {
                    itemstack.func_77982_d(new NBTTagCompound());
                }
                if (itemstack.func_77973_b() != PixelmonItems.oasFishingRod) {
                    if (!itemstack.func_77978_p().func_74764_b("rodQuality")) {
                        int quality = this.getRodQuality();
                        itemstack.func_77978_p().func_74768_a("rodQuality", quality);
                        chat.add("gui.oldfisherman.rod.quality" + quality);
                    } else {
                        chat.add("gui.oldfisherman.alreadychecked");
                    }
                } else {
                    chat.add("gui.oldfisherman.rod.oas");
                }
            } else {
                boolean hasLog = false;
                for (ItemStack stack1 : playerMP.field_71071_by.field_70462_a) {
                    if (stack1.func_77973_b() != PixelmonItems.fishingLog) continue;
                    hasLog = true;
                    break;
                }
                if (playerMP.field_71071_by.field_184439_c.get(0) != null && ((ItemStack)playerMP.field_71071_by.field_184439_c.get(0)).func_77973_b() == PixelmonItems.fishingLog) {
                    hasLog = true;
                }
                ItemStack log = new ItemStack(PixelmonItems.fishingLog);
                for (Pokemon pokemon : Pixelmon.storageManager.getParty(playerMP).getAll()) {
                    if (!hasLog && pokemon != null && pokemon.getSpecies() == EnumSpecies.Magikarp && pokemon.getFormEnum().getForm() > 0) {
                        playerMP.func_191521_c(log);
                        chat.add("gui.oldfisherman.givekarplog");
                        break;
                    }
                    if (!hasLog && pokemon != null && pokemon.getSpecies() == EnumSpecies.Shellos && pokemon.getFormEnum().getForm() > 1) {
                        playerMP.func_191521_c(log);
                        chat.add("gui.oldfisherman.giveshelloslog");
                        break;
                    }
                    if (hasLog || pokemon == null || pokemon.getSpecies() != EnumSpecies.Clobbopus || pokemon.getFormEnum().getForm() <= 0) continue;
                    playerMP.func_191521_c(log);
                    chat.add("gui.oldfisherman.givecloblog");
                    break;
                }
                if (chat.isEmpty()) {
                    chat.add("gui.oldfisherman.general");
                    chat.add("gui.oldfisherman.general2");
                }
            }
            NPCChatEvent event = new NPCChatEvent(this, player, chat);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            Pixelmon.network.sendTo((IMessage)new SetNPCData(this.getName(loc), event.getChat()), (EntityPlayerMP)player);
            OpenScreen.open(player, EnumGuiScreen.NPCChat, this.getId());
        } else {
            this.field_70714_bg.field_75782_a.clear();
        }
        return true;
    }

    @Override
    public String getName(String langCode) {
        return "Old Fisherman";
    }

    public int getRodQuality() {
        double percent = new Random().nextDouble();
        if (percent <= 0.3856) {
            return 0;
        }
        if (percent <= 0.5785) {
            return 1;
        }
        if (percent <= 0.7079) {
            return 2;
        }
        if (percent <= 0.8044) {
            return 3;
        }
        if (percent <= 0.8815) {
            return 4;
        }
        if (percent <= 0.9449) {
            return 5;
        }
        return 6;
    }

    @Override
    public void func_70024_g(double par1, double par3, double par5) {
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.initDefaultAI();
    }
}

