/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.raids.WeightedItemStacks;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.RemapHandler;
import com.pixelmonmod.pixelmon.entities.npcs.registry.BaseShopItem;
import com.pixelmonmod.pixelmon.entities.npcs.registry.NPCRegistryShopkeepers;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonDropInformation;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity8HoldsItems;
import com.pixelmonmod.pixelmon.enums.EnumBossMode;
import com.pixelmonmod.pixelmon.enums.EnumMegaPokemon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import com.pixelmonmod.pixelmon.items.heldItems.ItemBlankTechnicalMachine;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class DropItemRegistry {
    public static ArrayList<ItemStack> tier1 = new ArrayList();
    public static ArrayList<ItemStack> tier2 = new ArrayList();
    public static ArrayList<ItemStack> tier3 = new ArrayList();
    public static ArrayList<ItemStack> ultraSpace = new ArrayList();
    public static Map<EnumSpecies, Set<PokemonDropInformation>> pokemonDrops = new HashMap<EnumSpecies, Set<PokemonDropInformation>>();
    public static HashMap<EnumBossMode, ArrayList<ItemStack>> bossDrops = new HashMap();
    public static HashMap<Integer, HashMap<EnumType, WeightedItemStacks>> raidDrops = new HashMap();
    private static final Set<String> futureDrops = new HashSet<String>(Arrays.asList("pixelmon:clever_wing", "pixelmon:genius_wing", "pixelmon:honey"));

    public static void registerDropItems() throws FileNotFoundException {
        Pixelmon.LOGGER.info("Registering all drops.");
        String path = Pixelmon.modDirectory + "/pixelmon/drops/";
        File dropsDir = new File(path);
        if (PixelmonConfig.useExternalJSONFilesDrops && !dropsDir.isDirectory()) {
            File baseDir = new File(Pixelmon.modDirectory + "/pixelmon");
            if (!baseDir.isDirectory()) {
                baseDir.mkdir();
            }
            Pixelmon.LOGGER.info("Creating drops directory.");
            dropsDir.mkdir();
            DropItemRegistry.extractDropsDir(dropsDir);
        }
        InputStream iStream = !PixelmonConfig.useExternalJSONFilesDrops ? DropItemRegistry.class.getResourceAsStream("/assets/pixelmon/drops/pokechestdrops.json") : new FileInputStream(new File(dropsDir, "pokechestdrops.json"));
        JsonObject json = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonObject();
        DropItemRegistry.registerTierDrops(json, "tier1", tier1);
        DropItemRegistry.registerTierDrops(json, "tier2", tier2);
        DropItemRegistry.registerTierDrops(json, "tier3", tier3);
        DropItemRegistry.registerTierDrops(json, "ultraSpace", ultraSpace);
        DropItemRegistry.registerPokemonDrops();
        iStream = !PixelmonConfig.useExternalJSONFilesDrops ? DropItemRegistry.class.getResourceAsStream("/assets/pixelmon/drops/raiddrops.json") : new FileInputStream(new File(dropsDir, "raiddrops.json"));
        JsonObject jsonObject = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonObject();
        DropItemRegistry.registerRaidDrops(jsonObject);
        iStream = !PixelmonConfig.useExternalJSONFilesDrops ? DropItemRegistry.class.getResourceAsStream("/assets/pixelmon/drops/bossdrops.json") : new FileInputStream(new File(dropsDir, "bossdrops.json"));
        jsonObject = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonObject();
        DropItemRegistry.registerBossDrops(jsonObject);
        iStream = !PixelmonConfig.useExternalJSONFilesDrops ? DropItemRegistry.class.getResourceAsStream("/assets/pixelmon/drops/blankimprintrate.json") : new FileInputStream(new File(dropsDir, "blankimprintrate.json"));
        jsonObject = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonObject();
        DropItemRegistry.registerBlankImprintRates(jsonObject);
    }

    private static void registerPokemonDrops() throws FileNotFoundException {
        String path = Pixelmon.modDirectory + "/pixelmon/drops/";
        File dropsDir = new File(path);
        InputStream iStream = !PixelmonConfig.useExternalJSONFilesDrops ? DropItemRegistry.class.getResourceAsStream("/assets/pixelmon/drops/pokedrops.json") : new FileInputStream(new File(dropsDir, "pokedrops.json"));
        JsonArray json = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonArray();
        DropItemRegistry.registerPokemonDrops(json);
    }

    private static void registerBlankImprintRates(JsonObject jsonObject) {
        int rate;
        ItemBlankTechnicalMachine.maxImprintCount.clear();
        for (Gen8TechnicalMachines gen8TechnicalMachines : Gen8TechnicalMachines.values()) {
            rate = jsonObject.getAsJsonObject(gen8TechnicalMachines.prefix()).get(gen8TechnicalMachines.getAttackName()).getAsInt();
            ItemBlankTechnicalMachine.maxImprintCount.put(gen8TechnicalMachines, rate);
        }
        for (Enum enum_ : Gen8TechnicalRecords.values()) {
            rate = jsonObject.getAsJsonObject(enum_.prefix()).get(enum_.getAttackName()).getAsInt();
            ItemBlankTechnicalMachine.maxImprintCount.put((ITechnicalMove)((Object)enum_), rate);
        }
    }

    private static void registerBossDrops(JsonObject jsonObject) {
        for (EnumBossMode bossMode : EnumBossMode.values()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            DropItemRegistry.registerBossDropArray(jsonObject, bossMode.name().toLowerCase(), items);
            bossDrops.put(bossMode, items);
        }
    }

    private static void registerBossDropArray(JsonObject jsonObject, String key, List<ItemStack> dropArray) {
        if (jsonObject.has(key)) {
            JsonArray megaDropsArray = jsonObject.get(key).getAsJsonArray();
            for (int i = 0; i < megaDropsArray.size(); ++i) {
                String itemString = megaDropsArray.get(i).getAsString();
                ItemStack itemStack = DropItemRegistry.parseItem(itemString, "bossdrops.json");
                if (itemStack == null) {
                    if (futureDrops.contains(itemString)) continue;
                    Pixelmon.LOGGER.error("Boss drop item not found: " + itemString);
                    continue;
                }
                dropArray.add(itemStack);
            }
        }
    }

    private static void registerRaidDrops(JsonObject jsonObject) {
        for (int i = 1; i <= 5; ++i) {
            HashMap<EnumType, WeightedItemStacks> items = new HashMap<EnumType, WeightedItemStacks>();
            for (EnumType type : EnumType.values()) {
                items.put(type, WeightedItemStacks.create());
            }
            items.put(null, WeightedItemStacks.create());
            DropItemRegistry.registerRaidDropMap(jsonObject, String.valueOf(i), items);
            raidDrops.put(i, items);
        }
    }

    private static void registerRaidDropMap(JsonObject jsonObject, String key, HashMap<EnumType, WeightedItemStacks> map) {
        if (jsonObject.has(key)) {
            JsonObject outer = jsonObject.get(key).getAsJsonObject();
            HashSet<EnumType> types = new HashSet<EnumType>(Arrays.asList(EnumType.values()));
            types.add(null);
            for (EnumType type : types) {
                WeightedItemStacks stacks = map.get(type);
                if (!outer.has(type == null ? "Any" : type.name())) continue;
                JsonArray inner = outer.get(type == null ? "Any" : type.name()).getAsJsonArray();
                for (int i = 0; i < inner.size(); ++i) {
                    JsonObject itemWithWeight = inner.get(i).getAsJsonObject();
                    if (!itemWithWeight.has("item") || !itemWithWeight.has("weight")) continue;
                    String itemString = itemWithWeight.get("item").getAsString();
                    int itemWeight = itemWithWeight.get("weight").getAsInt();
                    ItemStack itemStack = DropItemRegistry.parseItem(itemString, "raiddrops.json");
                    if (itemStack == null) {
                        if (futureDrops.contains(itemString)) continue;
                        Pixelmon.LOGGER.error("Raid drop item not found: " + itemString);
                        continue;
                    }
                    stacks.add(itemWeight, itemStack);
                }
            }
        }
    }

    private static void registerPokemonDrops(JsonArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject pokemonDropObject = jsonArray.get(i).getAsJsonObject();
            String pokemonName = pokemonDropObject.get("pokemon").getAsString();
            PokemonSpec pokemon = new PokemonSpec(pokemonName, pokemonDropObject.has("form") ? "form:" + pokemonDropObject.get("form").getAsInt() : "");
            if (pokemon.name == null || !EnumSpecies.hasPokemon(pokemon.name)) continue;
            PokemonDropInformation drop = new PokemonDropInformation(pokemon, pokemonDropObject);
            pokemonDrops.merge(EnumSpecies.getFromNameAnyCaseNoTranslate(pokemon.name), Sets.newHashSet((Object[])new PokemonDropInformation[]{drop}), (oldSet, newSet) -> {
                oldSet.add(drop);
                return oldSet;
            });
        }
    }

    private static void registerTierDrops(JsonObject json, String tierName, List<ItemStack> tierList) {
        if (json.has(tierName)) {
            JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)json, (String)tierName);
            for (int i = 0; i < jsonArray.size(); ++i) {
                ItemStack tm;
                String itemName = jsonArray.get(i).getAsString();
                Item item = null;
                ResourceLocation loc = new ResourceLocation(itemName);
                item = (Item)Item.field_150901_e.func_82594_a((Object)loc);
                if (item == null && (tm = RemapHandler.findNewTMFor(itemName, 1)) != null) {
                    if (NPCRegistryShopkeepers.shopItems.containsKey(itemName)) {
                        BaseShopItem bItem = NPCRegistryShopkeepers.shopItems.get(itemName);
                        tierList.add(bItem.itemStack);
                        continue;
                    }
                    tierList.add(tm);
                    continue;
                }
                if (item == null) {
                    Pixelmon.LOGGER.info("Item not found: " + itemName + " in pokechestdrops.json.");
                    continue;
                }
                if (NPCRegistryShopkeepers.shopItems.containsKey(itemName)) {
                    BaseShopItem bItem = NPCRegistryShopkeepers.shopItems.get(itemName);
                    tierList.add(bItem.itemStack);
                    continue;
                }
                tierList.add(new ItemStack(item));
            }
        }
    }

    private static void extractDropsDir(File dropsDir) {
        ServerNPCRegistry.extractFile("/assets/pixelmon/drops/pokechestdrops.json", dropsDir, "pokechestdrops.json");
        ServerNPCRegistry.extractFile("/assets/pixelmon/drops/pokedrops.json", dropsDir, "pokedrops.json");
        ServerNPCRegistry.extractFile("/assets/pixelmon/drops/bossdrops.json", dropsDir, "bossdrops.json");
        ServerNPCRegistry.extractFile("/assets/pixelmon/drops/blankimprintrate.json", dropsDir, "blankimprintrate.json");
        ServerNPCRegistry.extractFile("/assets/pixelmon/drops/raiddrops.json", dropsDir, "raiddrops.json");
    }

    public static ItemStack getTier1Drop() {
        return RandomHelper.getRandomElementFromList(tier1);
    }

    public static ItemStack getTier2Drop() {
        return RandomHelper.getRandomElementFromList(tier2);
    }

    public static ItemStack getTier3Drop() {
        return RandomHelper.getRandomElementFromList(tier3);
    }

    public static ItemStack getUltraSpaceDrop() {
        return RandomHelper.getRandomElementFromList(ultraSpace);
    }

    public static ArrayList<ItemStack> getDropsForPokemon(Entity8HoldsItems pixelmon) {
        ArrayList drops = Lists.newArrayList();
        pokemonDrops.get(pixelmon.getSpecies()).stream().filter(d -> d.pokemon.matches(pixelmon.getPokemonData())).forEach(dropInfo -> drops.addAll(dropInfo.getDrops(pixelmon)));
        return drops;
    }

    public static ItemStack parseItem(String name, String filename) {
        ResourceLocation location;
        Item item;
        String[] splits = name.split(":");
        int data = 0;
        if (splits.length > 2) {
            data = Integer.parseInt(splits[2]);
            name = splits[0] + ":" + splits[1];
        }
        if ((item = (Item)Item.field_150901_e.func_82594_a((Object)(location = new ResourceLocation(name)))) == null) {
            if (!futureDrops.contains(name)) {
                Pixelmon.LOGGER.info("Item not found: " + name + " in " + filename);
            }
            return null;
        }
        return new ItemStack(item, 1, data);
    }

    public static ArrayList<ItemStack> getBossDrops(Entity8HoldsItems pixelmon, EntityPlayerMP player) {
        int form;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        EnumBossMode bossMode = pixelmon.getBossMode();
        DropItemRegistry.addRandomBossDrops(drops, (List<ItemStack>)bossDrops.get((Object)bossMode), bossMode.getCandyChance());
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
        EnumSpecies pokemon = pixelmon.getBaseStats().getSpecies();
        if (bossMode.isMegaBossPokemon() && pokemon.hasMega() && (form = pixelmon.getPokemonData().getForm()) > 0) {
            if (EnumMegaPokemon.getMega(pokemon).getMegaEvoItems()[form - 1] == ItemStack.field_190927_a.func_77973_b()) {
                return drops;
            }
            if (!storage.isMegaItemObtained(pokemon, form)) {
                drops.add(new ItemStack(EnumMegaPokemon.getMega(pokemon).getMegaEvoItems()[form - 1]));
                storage.obtainedItem(pokemon, form, player);
            } else if (RandomHelper.getRandomChance(0.025f)) {
                drops.add(new ItemStack(EnumMegaPokemon.getMega(pokemon).getMegaEvoItems()[form - 1]));
            }
        }
        return drops;
    }

    private static void addRandomBossDrops(List<ItemStack> drops, List<ItemStack> bossDropStore, float candyChance) {
        ItemStack megaDrop;
        if (RandomHelper.getRandomChance(candyChance)) {
            drops.add(new ItemStack(PixelmonItems.rareCandy));
        }
        if ((megaDrop = RandomHelper.getRandomElementFromList(bossDropStore)) == null) {
            return;
        }
        megaDrop = megaDrop.func_77946_l();
        megaDrop.func_190920_e(1);
        drops.add(megaDrop);
    }
}

