/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.npcs.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.raids.RegisterRaidEvent;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.eventhandler.Event;

public class RaidSpawningRegistry {
    public static ArrayList<Tuple<ArrayList<String>, HashMap<Integer, ArrayList<Tuple<EnumSpecies, Optional<IEnumForm>>>>>> raids = new ArrayList();
    public static HashMap<String, HashMap<Integer, ArrayList<Tuple<EnumSpecies, Optional<IEnumForm>>>>> map = new HashMap();

    public static void registerRaidSpawning() throws FileNotFoundException {
        Pixelmon.LOGGER.info("Registering raid spawning.");
        String path = Pixelmon.modDirectory + "/pixelmon/raids/";
        File raidsDir = new File(path);
        if (PixelmonConfig.useExternalJSONFilesSpawning && !raidsDir.isDirectory()) {
            File baseDir = new File(Pixelmon.modDirectory + "/pixelmon");
            if (!baseDir.isDirectory()) {
                baseDir.mkdir();
            }
            Pixelmon.LOGGER.info("Creating raids directory.");
            raidsDir.mkdir();
            RaidSpawningRegistry.extractRaidsDir(raidsDir);
        }
        InputStream iStream = !PixelmonConfig.useExternalJSONFilesSpawning ? RaidSpawningRegistry.class.getResourceAsStream("/assets/pixelmon/raids/raids.json") : new FileInputStream(new File(raidsDir, "raids.json"));
        JsonObject json = new JsonParser().parse((Reader)new InputStreamReader(iStream, StandardCharsets.UTF_8)).getAsJsonObject();
        RaidSpawningRegistry.registerRaidSpawns(json);
        RaidSpawningRegistry.remap();
    }

    private static void registerRaidSpawns(JsonObject json) {
        raids.clear();
        for (Map.Entry entry : json.entrySet()) {
            if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
            JsonObject inner = (JsonObject)entry.getValue();
            JsonArray biomes = inner.getAsJsonArray("biomes");
            JsonArray species = inner.getAsJsonArray("species");
            ArrayList<String> finalBiomes = new ArrayList<String>();
            for (JsonElement element : biomes) {
                finalBiomes.add(element.getAsString());
            }
            HashMap<Integer, ArrayList<Tuple<EnumSpecies, Optional<IEnumForm>>>> finalSpecies = new HashMap<Integer, ArrayList<Tuple<EnumSpecies, Optional<IEnumForm>>>>();
            for (int i = 1; i <= 5; ++i) {
                finalSpecies.put(i, new ArrayList());
            }
            RegisterRaidEvent.Register event = new RegisterRaidEvent.Register(finalSpecies);
            Pixelmon.EVENT_BUS.post((Event)event);
            if (!event.shouldUseDefaults()) continue;
            for (JsonElement element : species) {
                String str = element.getAsString();
                try {
                    String[] split = str.split("-");
                    String[] starStrs = split[0].split(",");
                    EnumSpecies pokemon = EnumSpecies.valueOf(split[1]);
                    if (!PixelmonConfig.raidHaveLegendaries && pokemon.isLegendary() || !PixelmonConfig.raidHaveUltraBeasts && pokemon.isUltraBeast() || PixelmonConfig.raidBlacklist.contains(pokemon.getPokemonName())) continue;
                    IEnumForm form = null;
                    if (split.length > 2) {
                        form = pokemon.getFormEnum(split[2]);
                    }
                    for (String starStr : starStrs) {
                        int star = Integer.parseInt(starStr);
                        RegisterRaidEvent.AddDefault e1 = new RegisterRaidEvent.AddDefault(finalSpecies, star, (Tuple<EnumSpecies, Optional<IEnumForm>>)new Tuple((Object)pokemon, Optional.ofNullable(form)));
                        if (Pixelmon.EVENT_BUS.post((Event)e1)) continue;
                        finalSpecies.get(e1.getStars()).add(e1.getRaid());
                    }
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Failed to parse raid string: " + str);
                }
            }
            raids.add((Tuple<ArrayList<String>, HashMap<Integer, ArrayList<Tuple<EnumSpecies, Optional<IEnumForm>>>>>)new Tuple(finalBiomes, finalSpecies));
        }
    }

    public static void remap() {
        map.clear();
        for (Tuple<ArrayList<String>, HashMap<Integer, ArrayList<Tuple<EnumSpecies, Optional<IEnumForm>>>>> group : raids) {
            for (String biome : (ArrayList)group.func_76341_a()) {
                if (!map.containsKey(biome = biome.toLowerCase(Locale.ROOT).replace("_", " "))) {
                    map.put(biome, new HashMap());
                    for (int i = 1; i <= 5; ++i) {
                        map.get(biome).put(i, new ArrayList());
                    }
                }
                for (Map.Entry entry : ((HashMap)group.func_76340_b()).entrySet()) {
                    map.get(biome).get(entry.getKey()).addAll((Collection)entry.getValue());
                }
            }
        }
    }

    private static void extractRaidsDir(File raidsDir) {
        ServerNPCRegistry.extractFile("/assets/pixelmon/raids/raids.json", raidsDir, "raids.json");
    }
}

