/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.battles.tasks.EnforcedSwitchTask;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EmergencyExit
extends AbilityBase {
    @Override
    public void tookDamageTargetAfterMove(PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        if (user == target) {
            return;
        }
        if (user.bc.simulateMode) {
            return;
        }
        if ((float)target.lastHP >= 50.0f && target.getHealthPercent() <= 50.0f && !target.isFainted()) {
            if (target.getParticipant() instanceof WildPixelmonParticipant) {
                user.willTryFlee = true;
                target.bc.endBattle(EnumBattleEndCause.FLEE);
            } else {
                BattleParticipant targetParticipant = target.getParticipant();
                ParticipantType targetType = targetParticipant.getType();
                if (!targetParticipant.hasMorePokemonReserve()) {
                    return;
                }
                target.bc.sendToAll("pixelmon.effect.escape", target.getNickname());
                target.setUpSwitchMove();
                if (targetType == ParticipantType.Player) {
                    Pixelmon.network.sendTo((IMessage)new EnforcedSwitchTask(target.bc.getPositionOfPokemon(target, targetParticipant)), target.getPlayerOwner());
                } else {
                    target.bc.switchPokemon(target.getPokemonUUID(), target.getBattleAI().getNextSwitch(target), true);
                }
            }
        }
    }
}

