/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import net.minecraft.entity.player.EntityPlayerMP;

public class Illusion
extends AbilityBase {
    public EnumSpecies disguisedPokemon = null;
    public String disguisedNickname = null;
    public String disguisedTexture = null;
    public Gender disguisedGender = null;
    public int disguisedForm = -1;
    public boolean disguisedShiny = false;

    @Override
    public void beforeSwitch(PixelmonWrapper newPokemon) {
        if (newPokemon.bc.simulateMode) {
            return;
        }
        BattleParticipant participant = newPokemon.getParticipant();
        if (participant instanceof WildPixelmonParticipant) {
            return;
        }
        PixelmonWrapper disguised = null;
        for (int i = participant.allPokemon.length - 1; i >= 0; --i) {
            PixelmonWrapper pw = participant.allPokemon[i];
            if (pw.isFainted()) continue;
            if (!pw.getPokemonUUID().equals(newPokemon.getPokemonUUID())) {
                disguised = pw;
                this.disguisedTexture = disguised.getRealTextureNoCheck();
                if (this.disguisedTexture.equals(newPokemon.getRealTextureNoCheck())) {
                    this.disguisedTexture = null;
                    return;
                }
                this.disguisedPokemon = disguised.getSpecies();
                this.disguisedNickname = disguised.getNickname();
                this.disguisedGender = disguised.getGender();
                this.disguisedForm = disguised.getForm();
                this.disguisedShiny = disguised.getInnerLink().isShiny();
                break;
            }
            return;
        }
        if (disguised == null) {
            return;
        }
        newPokemon.entity.transformServer(disguised.getSpecies(), this.disguisedForm, this.disguisedTexture);
        if (newPokemon.getPlayerOwner() != null) {
            this.updateOwner(newPokemon);
        }
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.entity.transformedTexture == null && this.disguisedPokemon != null) {
            newPokemon.entity.transformServer(this.disguisedPokemon, this.disguisedForm, this.disguisedTexture);
        }
    }

    @Override
    public void tookDamageTarget(int damage, PixelmonWrapper user, PixelmonWrapper target, Attack a) {
        this.fade(target);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.fade(pokemon);
    }

    private void fade(PixelmonWrapper target) {
        if (this.disguisedPokemon != null && !target.bc.simulateMode) {
            this.disguisedPokemon = null;
            this.disguisedNickname = null;
            this.disguisedTexture = null;
            this.disguisedGender = null;
            target.bc.sendToAll("pixelmon.abilities.illusion", target.getNickname());
            target.entity.cancelTransform();
            target.bc.participants.stream().filter(participant -> participant instanceof PlayerParticipant).forEach(participant -> ((PlayerParticipant)participant).updateOpponentPokemon());
            if (target.getPlayerOwner() != null) {
                this.updateOwner(target);
            }
        }
    }

    private void updateOwner(PixelmonWrapper pokemon) {
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        EntityPlayerMP player = oldPokemon.getPlayerOwner();
        if (oldPokemon.bc.simulateMode || player != null) {
            // empty if block
        }
    }

    @Override
    public void applyEndOfBattleEffect(PixelmonWrapper pokemon) {
        EntityPlayerMP player = pokemon.getPlayerOwner();
        if (player != null) {
            // empty if block
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }
}

