/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.PickupEvent;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.registry.DropItemRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Pickup
extends AbilityBase {
    private ItemHeld consumedItem = NoItem.noItem;
    private PixelmonWrapper consumer;

    @Override
    public void onItemConsumed(PixelmonWrapper pokemon, PixelmonWrapper consumer, ItemHeld heldItem) {
        if (pokemon != consumer && !pokemon.bc.simulateMode) {
            this.consumedItem = heldItem;
            this.consumer = consumer;
        }
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pokemon) {
        if (pokemon != this.consumer && !pokemon.bc.simulateMode) {
            if (!pokemon.hasHeldItem() && this.consumedItem != NoItem.noItem && this.consumer != null && this.consumer.getConsumedItem() != NoItem.noItem && pokemon.bc.getActivePokemon().contains(this.consumer)) {
                pokemon.setHeldItem(this.consumedItem);
                this.consumer.setConsumedItem(null);
                pokemon.bc.sendToAll("pixelmon.abilities.pickup", pokemon.getNickname(), this.consumedItem.getLocalizedName());
                pokemon.enableReturnHeldItem();
            }
            this.consumedItem = null;
            this.consumer = null;
        }
    }

    @Override
    public boolean needNewInstance() {
        return true;
    }

    public static void pickupItem(PlayerParticipant player) {
        if (PixelmonConfig.pickupRate > 0) {
            for (PixelmonWrapper pw : player.allPokemon) {
                int rand;
                if (!(pw.getAbility() instanceof Pickup) || pw.hasHeldItem() || !RandomHelper.getRandomChance(1.0f / (float)PixelmonConfig.pickupRate)) continue;
                int level = pw.getLevelNum();
                ItemStack foundItem = level <= 50 ? DropItemRegistry.getTier1Drop() : (level <= 80 ? ((rand = RandomHelper.getRandomNumberBetween(1, 100)) < 91 ? DropItemRegistry.getTier1Drop() : DropItemRegistry.getTier2Drop()) : ((rand = RandomHelper.getRandomNumberBetween(1, 100)) < 80 ? DropItemRegistry.getTier1Drop() : (rand < 100 ? DropItemRegistry.getTier2Drop() : DropItemRegistry.getTier3Drop())));
                if (foundItem == null) continue;
                ItemStack itemCopy = foundItem.func_77946_l();
                itemCopy.func_190920_e(1);
                PickupEvent event = new PickupEvent(pw, player, itemCopy);
                if (Pixelmon.EVENT_BUS.post((Event)event)) continue;
                player.player.field_71071_by.func_70441_a(event.stack);
            }
        }
    }
}

