/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.abilities;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.Rainy;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;

public class PrimordialSea
extends AbilityBase {
    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        if (newPokemon.bc.globalStatusController.canWeatherChange(new Rainy(true))) {
            newPokemon.bc.globalStatusController.addGlobalStatus(new Rainy(true));
            newPokemon.bc.sendToAll("pixelmon.abilities.primordialsea", newPokemon.getNickname());
        }
    }

    private void checkForRemoval(PixelmonWrapper pokemon) {
        if (pokemon.bc.globalStatusController.getWeatherIgnoreAbility() instanceof Rainy && pokemon.bc.globalStatusController.getWeatherIgnoreAbility().extreme) {
            for (PixelmonWrapper pw : pokemon.bc.getActivePokemon()) {
                if (pw == pokemon || !(pw.getBattleAbility() instanceof PrimordialSea)) continue;
                return;
            }
            pokemon.bc.globalStatusController.removeGlobalStatus(StatusType.Rainy);
            pokemon.bc.globalStatusController.triggerWeatherChange(null);
            pokemon.bc.sendToAll("pixelmon.status.rainstopped", new Object[0]);
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.checkForRemoval(oldPokemon);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.checkForRemoval(pokemon);
    }

    @Override
    public void onDamageReceived(PixelmonWrapper user, PixelmonWrapper pokemon, Attack a, int damage, DamageTypeEnum damagetype) {
        if (pokemon.isFainted()) {
            this.checkForRemoval(pokemon);
        }
    }

    @Override
    public boolean canBeIgnored() {
        return false;
    }
}

