/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.AI.AIExecuteAction;
import com.pixelmonmod.pixelmon.AI.AIFlying;
import com.pixelmonmod.pixelmon.AI.AIFlyingPersistent;
import com.pixelmonmod.pixelmon.AI.AIIsInBattle;
import com.pixelmonmod.pixelmon.AI.AIMoveTowardsBlock;
import com.pixelmonmod.pixelmon.AI.AIMoveTowardsTarget;
import com.pixelmonmod.pixelmon.AI.AISwimming;
import com.pixelmonmod.pixelmon.AI.AITargetNearest;
import com.pixelmonmod.pixelmon.AI.AITeleportAway;
import com.pixelmonmod.pixelmon.AI.AITempt;
import com.pixelmonmod.pixelmon.AI.AIWander;
import com.pixelmonmod.pixelmon.blocks.enums.EnumSpawnerAggression;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity4Interactions;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumAggression;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;

public class AIHelper {
    int i = 0;

    public void populateTasks(Entity4Interactions entity, EntityAITasks tasks) {
        EntityPixelmon pixelmon = (EntityPixelmon)entity;
        if (!tasks.field_75782_a.isEmpty()) {
            tasks.field_75782_a.clear();
        }
        this.initBaseAI(pixelmon, tasks);
        if (!(pixelmon.getSpawnLocation() != SpawnLocationType.Land || entity.getBaseStats().canFly().booleanValue() || entity.getBaseStats().IsRideable().booleanValue() && entity.getBaseStats().getTypeList().contains(EnumType.Water))) {
            this.initGroundAI(pixelmon, tasks);
        } else if (entity.getBaseStats().canFly().booleanValue() && entity.getFlyingParameters() != null) {
            if (pixelmon.getSpawnLocation() == SpawnLocationType.AirPersistent) {
                this.initFlyingPersistentAI(pixelmon, tasks);
            } else {
                this.initFlyingAI(pixelmon, tasks);
            }
        } else if (pixelmon.getSpawnLocation() == SpawnLocationType.Water) {
            this.initSwimmingAI(pixelmon, tasks);
        } else {
            this.initGroundAI(pixelmon, tasks);
        }
    }

    public PathNavigate createNavigator(Entity4Interactions pixelmon) {
        if (!(pixelmon.getSpawnLocation() != SpawnLocationType.Land || pixelmon.getBaseStats().canFly().booleanValue() || pixelmon.getBaseStats().IsRideable().booleanValue() && pixelmon.getBaseStats().getTypeList().contains(EnumType.Water))) {
            return new PathNavigateGround((EntityLiving)pixelmon, pixelmon.field_70170_p);
        }
        if (pixelmon.getBaseStats().canFly().booleanValue() && pixelmon.getFlyingParameters() != null) {
            if (pixelmon.getSpawnLocation() == SpawnLocationType.AirPersistent) {
                return new PathNavigateFlying((EntityLiving)pixelmon, pixelmon.field_70170_p);
            }
            return new PathNavigateFlying((EntityLiving)pixelmon, pixelmon.field_70170_p);
        }
        if (pixelmon.getSpawnLocation() == SpawnLocationType.Water) {
            return new PathNavigateGround((EntityLiving)pixelmon, pixelmon.field_70170_p);
        }
        return new PathNavigateGround((EntityLiving)pixelmon, pixelmon.field_70170_p);
    }

    private void initBaseAI(EntityPixelmon pixelmon, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIIsInBattle(pixelmon));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIMoveTowardsTarget((EntityCreature)pixelmon, 15.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIExecuteAction((EntityCreature)pixelmon));
        if (!(pixelmon.getSpawnLocation() == SpawnLocationType.Water || pixelmon.getBaseStats().IsRideable().booleanValue() && pixelmon.getBaseStats().getTypeList().contains(EnumType.Water))) {
            if ((PixelmonConfig.isAggressionAllowed || pixelmon.spawner != null && pixelmon.spawner.aggression == EnumSpawnerAggression.Aggressive) && pixelmon.aggression == EnumAggression.aggressive) {
                tasks.func_75776_a(this.i++, (EntityAIBase)new AITargetNearest((EntityCreature)pixelmon, 10.0f, true));
            } else if (pixelmon.aggression == EnumAggression.timid) {
                tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)pixelmon, EntityPlayer.class, 16.0f, (double)0.23f, (double)0.4f));
            }
        }
        if (pixelmon.func_70902_q() != null) {
            tasks.func_75776_a(this.i++, (EntityAIBase)new AIMoveTowardsBlock(pixelmon, 25.0f));
        }
    }

    private void initFlyingPersistentAI(EntityPixelmon pixelmon, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)pixelmon, 1.0, 10.0f, 4.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)pixelmon, false, PixelmonItems.rareCandy, PixelmonItems.mint));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIFlyingPersistent(pixelmon));
    }

    private void initSwimmingAI(EntityPixelmon pixelmon, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)pixelmon, 1.0, 10.0f, 4.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)pixelmon, false, PixelmonItems.rareCandy, PixelmonItems.mint));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AISwimming(pixelmon));
    }

    private void initFlyingAI(EntityPixelmon pixelmon, EntityAITasks tasks) {
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAISwimming((EntityLiving)pixelmon));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)pixelmon, 1.0, 10.0f, 4.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)pixelmon, false, PixelmonItems.rareCandy, PixelmonItems.mint));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)pixelmon, EntityPixelmon.class, 8.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIFlying(pixelmon));
    }

    private void initGroundAI(EntityPixelmon entity, EntityAITasks tasks) {
        if (entity.getBaseStats().getTypeList().contains(EnumType.Fire)) {
            if (entity.func_70661_as() instanceof PathNavigateGround) {
                ((PathNavigateGround)entity.func_70661_as()).func_179693_d(true);
            }
            if (entity.func_70661_as() instanceof PathNavigateFlying) {
                ((PathNavigateFlying)entity.func_70661_as()).func_192877_c(true);
            }
        }
        if (entity.getSpecies() == EnumSpecies.Abra) {
            tasks.func_75776_a(this.i++, (EntityAIBase)new AITeleportAway(entity));
        }
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAISwimming((EntityLiving)entity));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)entity, 1.0, 10.0f, 4.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AITempt((EntityCreature)entity, false, PixelmonItems.rareCandy, PixelmonItems.mint));
        tasks.func_75776_a(this.i++, (EntityAIBase)new AIWander((EntityCreature)entity));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)entity, EntityPixelmon.class, 8.0f));
        tasks.func_75776_a(this.i++, (EntityAIBase)new EntityAILookIdle((EntityLiving)entity));
    }
}

