/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.helpers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.enums.ReceiveType;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.events.MegaEvolutionEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolutionStage;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.EvolvePokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.evolution.OpenEvolutionGUI;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.config.PixelmonItemsPokeballs;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MirrorArmor;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Pressure;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumNecrozma;
import com.pixelmonmod.pixelmon.enums.forms.EnumNoForm;
import com.pixelmonmod.pixelmon.items.heldItems.ItemMegaStone;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.AirSaver;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EvolutionQuery {
    EntityPixelmon pixelmon;
    Evolution evolution = null;
    PokemonSpec newPokemon;
    public UUID pokemonUUID;
    boolean fromLevelUp;
    int level;
    int newForm;
    EntityPlayerMP player;
    boolean normalEvolution = true;
    EvolutionStage stage;
    private AirSaver airSaver;
    int ticks = 0;

    public EvolutionQuery(EntityPixelmon pixelmon, Evolution evolution, int form) {
        this.pixelmon = pixelmon;
        this.newPokemon = evolution.to.copy();
        this.pokemonUUID = pixelmon.getPokemonData().getUUID();
        this.evolution = evolution;
        this.level = pixelmon.getLvl().getLevel();
        this.fromLevelUp = evolution instanceof LevelingEvolution;
        if (form > -1) {
            this.newPokemon.form = (byte)form;
        }
        if (pixelmon.func_70902_q() != null) {
            this.player = (EntityPlayerMP)pixelmon.func_70902_q();
            this.airSaver = new AirSaver(this.player);
        }
        this.sendQuery();
        pixelmon.field_70714_bg.field_75782_a.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvolutionQuery(EntityPixelmon pixelmon, int form) {
        this.normalEvolution = false;
        this.pixelmon = pixelmon;
        this.pokemonUUID = pixelmon.getPokemonData().getUUID();
        this.fromLevelUp = false;
        this.newForm = form;
        if (pixelmon.func_70902_q() != null) {
            this.player = (EntityPlayerMP)pixelmon.func_70902_q();
            this.airSaver = new AirSaver(this.player);
        }
        this.level = pixelmon.getLvl().getLevel();
        pixelmon.field_70714_bg.field_75782_a.clear();
        this.setStage(EvolutionStage.PreAnimation);
        this.updateAllAround(this.stage);
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            EvolutionQueryList.queryList.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tick(World world) {
        if (this.pixelmon.field_70170_p != world) {
            return;
        }
        if (this.airSaver != null) {
            this.airSaver.tick();
        }
        if (this.stage == EvolutionStage.Choice) {
            return;
        }
        ++this.ticks;
        if (this.stage == EvolutionStage.PreChoice) {
            if (this.ticks >= this.stage.ticks) {
                this.ticks = 0;
                this.setStage(EvolutionStage.Choice);
            }
        } else if (this.stage == EvolutionStage.PreAnimation) {
            if (this.ticks >= this.stage.ticks) {
                this.ticks = 0;
                this.setStage(EvolutionStage.PostAnimation);
                this.updateAllAround(this.stage);
                this.doEvoSwitch();
            }
        } else if (this.stage == EvolutionStage.PostAnimation && this.ticks >= this.stage.ticks) {
            this.ticks = 0;
            this.setStage(EvolutionStage.End);
            if (this.evolution != null) {
                this.evolution.finishedEvolving(this.pixelmon);
            }
            this.updateAllAround(this.stage);
            List<EvolutionQuery> list = EvolutionQueryList.queryList;
            synchronized (list) {
                EvolutionQueryList.queryList.remove(this);
            }
        }
    }

    private void setStage(EvolutionStage stage) {
        this.stage = stage;
        this.pixelmon.evoStage = stage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery() {
        if (this.pixelmon.hasOwner()) {
            Pixelmon.network.sendTo((IMessage)new OpenEvolutionGUI(this.pokemonUUID, this.newPokemon.name), this.player);
            this.updateAllAround(EvolutionStage.Choice);
            this.removeExisting();
            List<EvolutionQuery> list = EvolutionQueryList.queryList;
            synchronized (list) {
                EvolutionQueryList.queryList.add(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExisting() {
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            for (int i = 0; i < EvolutionQueryList.queryList.size(); ++i) {
                EvolutionQuery query = EvolutionQueryList.queryList.get(i);
                if (!query.pokemonUUID.equals(this.pokemonUUID)) continue;
                EvolutionQueryList.queryList.remove(i);
                break;
            }
        }
    }

    void accept() {
        this.setStage(EvolutionStage.PreAnimation);
        this.ticks = 0;
        this.updateAllAround(this.stage);
    }

    void doEvoSwitch() {
        if (this.pixelmon.field_70128_L) {
            return;
        }
        EntityPixelmon pre = (EntityPixelmon)PixelmonEntityList.createEntityFromNBT(this.pixelmon.func_189511_e(new NBTTagCompound()), this.pixelmon.field_70170_p);
        pre.func_184221_a(UUID.randomUUID());
        if (this.normalEvolution) {
            if (this.newPokemon.name == null) {
                System.out.println("EVOLVE FAULT: " + this.player.func_70005_c_() + " - " + this.pixelmon.func_70005_c_());
                return;
            }
            this.checkMagbyJump();
            this.pixelmon.evolve(this.newPokemon);
            if (this.pixelmon.getSpecies() == pre.getSpecies()) {
                Pixelmon.LOGGER.error("Evolution: " + this);
            }
            this.checkShedinja();
            this.checkForLearnMoves();
            this.checkForEvolutionMoves();
            this.checkCorvisquire();
            this.evolution.finishedEvolving(this.pixelmon);
            Pixelmon.EVENT_BUS.post((Event)new EvolveEvent.PostEvolve(this.player, pre, this.evolution, this.pixelmon));
            if (!this.pixelmon.getPokemonName().equals(EnumSpecies.Shedinja.name)) {
                Pixelmon.EVENT_BUS.post((Event)new PixelmonReceivedEvent(this.player, ReceiveType.Evolution, this.pixelmon.getPokemonData()));
            }
        } else {
            ItemMegaStone megaStone;
            Pokemon pokemon = this.pixelmon.getPokemonData();
            boolean isUltraburst = PixelmonWrapper.canUltraBurst(pokemon.getSpecies(), pokemon.getHeldItemAsItemHeld(), pokemon.getForm()) && this.newForm == EnumNecrozma.ULTRA.getForm();
            ItemMegaStone itemMegaStone = megaStone = pokemon.getHeldItemAsItemHeld() instanceof ItemMegaStone ? (ItemMegaStone)pokemon.getHeldItemAsItemHeld() : null;
            if (this.pixelmon.getFormEnum().getForm() != this.newForm) {
                this.pixelmon.setForm(this.newForm);
            }
            this.pixelmon.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
            if (this.pixelmon.battleController == null) {
                this.pixelmon.resetAI();
                this.pixelmon.setBlockTarget((int)this.pixelmon.field_70165_t, (int)this.pixelmon.field_70163_u, (int)this.pixelmon.field_70161_v, EnumFacing.SOUTH, null);
            }
            Pixelmon.EVENT_BUS.post((Event)new MegaEvolutionEvent.PostEvolve(this.player, pre, megaStone, isUltraburst, this.pixelmon));
        }
    }

    private void removeEntity() {
        this.pixelmon.unloadEntity();
    }

    void decline() {
        this.removeEntity();
    }

    private void checkCorvisquire() {
        if (this.pixelmon.getBaseStats().getSpecies() == EnumSpecies.Corvisquire) {
            int slot = this.pixelmon.getPokemonData().getAbilitySlot();
            if (slot == 0) {
                this.pixelmon.getPokemonData().setAbility(new Pressure());
            } else if (slot == 2) {
                this.pixelmon.getPokemonData().setAbility(new MirrorArmor());
            }
        }
    }

    private void checkMagbyJump() {
        PokemonStorage party;
        if (this.pixelmon.getBaseStats().getSpecies() == EnumSpecies.Magby && (party = this.pixelmon.getPokemonData().getStorage()) != null) {
            for (Pokemon poke : party.getAll()) {
                if (poke == null || poke.getSpecies() != EnumSpecies.Slugma || poke.getFormEnum() == EnumNoForm.NoForm) continue;
                this.newPokemon.form = poke.getFormEnum().getForm();
                break;
            }
        }
    }

    private void checkShedinja() {
        PokemonStorage party;
        if (this.pixelmon.getBaseStats().getSpecies() == EnumSpecies.Ninjask && (party = (PokemonStorage)this.pixelmon.getPokemonData().getStorageAndPosition().func_76341_a()).hasSpace()) {
            EntityPlayerMP player;
            EntityPlayerMP entityPlayerMP = player = party instanceof PlayerPartyStorage ? ((PlayerPartyStorage)party).getPlayer() : null;
            if (player != null && player.field_71071_by.func_174925_a(PixelmonItemsPokeballs.pokeBall, 0, 1, null) == 1) {
                Pokemon shedinja = Pixelmon.pokemonFactory.create(new PokemonSpec(EnumSpecies.Shedinja.name, "lvl:" + this.pixelmon.getPokemonData().getLevel()));
                shedinja.getMoveset().clear();
                shedinja.getMoveset().addAll(this.pixelmon.getPokemonData().getMoveset());
                shedinja.setStatus((StatusPersist)this.pixelmon.getPokemonData().getStatus().copy());
                shedinja.setShiny(this.pixelmon.getPokemonData().isShiny());
                shedinja.setGrowth(this.pixelmon.getPokemonData().getGrowth());
                shedinja.setFriendship(this.pixelmon.getPokemonData().getFriendship());
                shedinja.setNature(this.pixelmon.getPokemonData().getNature());
                shedinja.setExperience(this.pixelmon.getPokemonData().getExperience());
                shedinja.getEVs().fillFromArray(this.pixelmon.getPokemonData().getEVs().getArray());
                shedinja.getIVs().CopyIVs(this.pixelmon.getPokemonData().getIVs());
                shedinja.setOriginalTrainer(this.pixelmon.getPokemonData().getOriginalTrainerUUID(), this.pixelmon.getPokemonData().getOriginalTrainer());
                party.add(shedinja);
            }
        }
    }

    private void checkForLearnMoves() {
        if (this.pixelmon.getBaseStats() == null) {
            return;
        }
        int level = this.pixelmon.getLvl().getLevel();
        if (level == 1) {
            level = 0;
        }
        if (!this.pixelmon.getBaseStats().getMovesAtLevel(level).isEmpty()) {
            ArrayList<Attack> newAttacks = this.pixelmon.getBaseStats().getMovesAtLevel(level);
            Moveset moveset = this.pixelmon.getPokemonData().getMoveset();
            newAttacks.stream().filter(a -> !moveset.hasAttack((Attack)a)).forEach(a -> {
                if (moveset.size() >= 4) {
                    LearnMoveController.sendLearnMove(this.player, this.pixelmon.func_110124_au(), a.getActualMove());
                } else {
                    moveset.add((Attack)a);
                    this.pixelmon.update(EnumUpdateType.Moveset);
                    if (BattleRegistry.getBattle((EntityPlayer)this.pixelmon.func_70902_q()) != null) {
                        ChatHandler.sendBattleMessage((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.getMove().getTranslatedName());
                    } else {
                        ChatHandler.sendChat((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.getMove().getTranslatedName());
                    }
                }
            });
        }
    }

    public void checkForEvolutionMoves() {
        if (this.evolution.moves == null || this.evolution.moves.isEmpty()) {
            return;
        }
        ArrayList<AttackBase> evoMoves = new ArrayList<AttackBase>();
        for (String moveName : this.evolution.moves) {
            AttackBase ab = AttackBase.getAttackBase(moveName).orElse(null);
            if (ab == null) {
                Pixelmon.LOGGER.error("Unknown move in evolution. To: " + this.evolution.to.name + ". Move: " + moveName);
                continue;
            }
            evoMoves.add(ab);
            if (this.pixelmon.relearnableEvolutionMoves.contains(ab.getAttackId())) continue;
            this.pixelmon.relearnableEvolutionMoves.add(ab.getAttackId());
        }
        this.pixelmon.update(EnumUpdateType.Moveset);
        for (AttackBase ab : evoMoves) {
            Attack a = new Attack(ab);
            Moveset moveset = this.pixelmon.getPokemonData().getMoveset();
            if (moveset.hasAttack(a)) continue;
            if (moveset.size() >= 4) {
                LearnMoveController.sendLearnMove(this.player, this.pixelmon.func_110124_au(), a.getActualMove());
                continue;
            }
            moveset.add(a);
            this.pixelmon.update(EnumUpdateType.Moveset);
            if (BattleRegistry.getBattle((EntityPlayer)this.pixelmon.func_70902_q()) != null) {
                ChatHandler.sendBattleMessage((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.getMove().getTranslatedName());
                continue;
            }
            ChatHandler.sendChat((Entity)this.pixelmon.func_70902_q(), "pixelmon.stats.learnedmove", this.pixelmon.getNickname(), a.getMove().getTranslatedName());
        }
    }

    public boolean isEnded() {
        return this.stage == EvolutionStage.End;
    }

    private void updateAllAround(EvolutionStage currentStage) {
        Object owner = this.pixelmon.func_70902_q();
        if (owner == null) {
            owner = this.pixelmon;
        }
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(owner.field_71093_bK, owner.field_70165_t, owner.field_70163_u, owner.field_70161_v, 60.0);
        Pixelmon.network.sendToAllAround((IMessage)new EvolvePokemon(this.pokemonUUID, currentStage), point);
    }
}

