/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.pokemon.ItemFormChangeEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.particle.ParticleSystems;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.PlayParticleSystem;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.interactions.formChanges.IFormChange;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumKyurem;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class KyuremFormChange
implements IFormChange {
    @Override
    public boolean isValidItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item == PixelmonItemsHeld.dnaSplicers;
    }

    @Override
    public boolean isValidPokemon(EntityPixelmon pixelmon) {
        return pixelmon.isPokemon(EnumSpecies.Kyurem) && !pixelmon.isEvolving();
    }

    @Override
    public boolean execute(EntityPixelmon pixelmon, ItemStack stack, EntityPlayerMP player) {
        PlayerPartyStorage storage = Pixelmon.storageManager.getParty(player);
        if (pixelmon.getFormEnum() != EnumKyurem.NORMAL) {
            ItemFormChangeEvent event;
            NBTTagCompound fusedPokemonNBT = pixelmon.getPokemonData().getPersistentData().func_74775_l("FusedPokemon");
            Pokemon fused = null;
            if (!fusedPokemonNBT.func_82582_d()) {
                try {
                    fused = Pixelmon.pokemonFactory.create(fusedPokemonNBT);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (fused == null) {
                    Pixelmon.LOGGER.error("Couldn't get fused Pok\u00e9mon from NBT for player: " + player.func_70005_c_());
                }
            }
            if (Pixelmon.EVENT_BUS.post((Event)(event = new ItemFormChangeEvent(player, stack, pixelmon, fused)))) {
                return false;
            }
            if (fused != null) {
                storage.add(event.fusion);
            }
            pixelmon.getEntityData().func_82580_o("FusedPokemon");
            pixelmon.func_130014_f_().func_184148_a(null, pixelmon.field_70165_t, pixelmon.field_70163_u, pixelmon.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.NEUTRAL, 1.0f, 0.1f);
            Pixelmon.network.sendToDimension((IMessage)new PlayParticleSystem(ParticleSystems.DISCHARGE, pixelmon.field_70165_t, pixelmon.field_70163_u, pixelmon.field_70161_v, pixelmon.field_71093_bK, pixelmon.getPixelmonScale(), pixelmon.getPokemonData().isShiny(), EnumSpecies.Zekrom.name.equals(fusedPokemonNBT.func_74779_i("Name")) ? 0.5 : 1.0, 0.5, EnumSpecies.Zekrom.name.equals(fusedPokemonNBT.func_74779_i("Name")) ? 1.0 : 0.5, 0.0), pixelmon.field_71093_bK);
            pixelmon.getPokemonData().getMoveset().replaceMove("Fusion Bolt", new Attack("Scary Face"));
            pixelmon.getPokemonData().getMoveset().replaceMove("Fusion Flare", new Attack("Scary Face"));
            pixelmon.getPokemonData().getMoveset().replaceMove("Freeze Shock", new Attack("Glaciate"));
            pixelmon.getPokemonData().getMoveset().replaceMove("Ice Burn", new Attack("Glaciate"));
            pixelmon.getPokemonData().setForm(EnumKyurem.NORMAL);
        } else {
            Pokemon pokemon = storage.findOne(p -> !p.isEgg() && p.isPokemon(EnumSpecies.Reshiram, EnumSpecies.Zekrom));
            if (pokemon == null) {
                ChatHandler.sendFormattedChat((ICommandSender)player, TextFormatting.RED, "pixelmon.interaction.kyurem.notfound", pixelmon.func_145748_c_());
                return true;
            }
            ItemFormChangeEvent event = new ItemFormChangeEvent(player, stack, pixelmon, pokemon);
            if (Pixelmon.EVENT_BUS.post((Event)event)) {
                return false;
            }
            pixelmon.func_130014_f_().func_184148_a(null, pixelmon.field_70165_t, pixelmon.field_70163_u, pixelmon.field_70161_v, SoundEvents.field_187853_gC, SoundCategory.NEUTRAL, 0.3f, 0.2f);
            Pixelmon.network.sendToDimension((IMessage)new PlayParticleSystem(ParticleSystems.RADIALTHUNDER, pixelmon.field_70165_t, pixelmon.field_70163_u, pixelmon.field_70161_v, pixelmon.field_71093_bK, pixelmon.getPixelmonScale(), pixelmon.getPokemonData().isShiny(), pokemon.isPokemon(EnumSpecies.Zekrom) ? 0.5 : 1.0, 0.5, pokemon.isPokemon(EnumSpecies.Zekrom) ? 1.0 : 0.5), pixelmon.field_71093_bK);
            pokemon.ifEntityExists(EntityPixelmon::retrieve);
            storage.set((StoragePosition)pokemon.getStorageAndPosition().func_76340_b(), null);
            NBTTagCompound pokenbt = new NBTTagCompound();
            pokemon.writeToNBT(pokenbt);
            pixelmon.getPokemonData().getPersistentData().func_74782_a("FusedPokemon", (NBTBase)pokenbt);
            if (pokemon.isPokemon(EnumSpecies.Zekrom)) {
                pixelmon.setForm(EnumKyurem.BLACK);
                pixelmon.getPokemonData().getMoveset().replaceMove("Scary Face", new Attack("Fusion Bolt"));
                pixelmon.getPokemonData().getMoveset().replaceMove("Glaciate", new Attack("Freeze Shock"));
            } else {
                pixelmon.setForm(EnumKyurem.WHITE);
                pixelmon.getPokemonData().getMoveset().replaceMove("Scary Face", new Attack("Fusion Flare"));
                pixelmon.getPokemonData().getMoveset().replaceMove("Glaciate", new Attack("Ice Burn"));
            }
        }
        return true;
    }
}

