/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.moveSkills;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.IlluminatePositionsPacket;
import com.pixelmonmod.pixelmon.config.BlockRevealParser;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class OreSense {
    public static int durationTicks = 300;
    public static int maxSearchRadius = 10;

    public static MoveSkill createMoveSkill() {
        MoveSkill moveSkill = new MoveSkill("ore_sense").setName("pixelmon.moveskill.ore_sense.name").describe("pixelmon.moveskill.ore_sense.description1", "pixelmon.moveskill.ore_sense.description2").setIcon(new ResourceLocation("pixelmon", "textures/gui/overlay/externalMoves/oresense.png")).setAnyMoves("Magnet Rise", "Metal Sound", "Steel Beam").setIntrinsicSpecs(Lists.newArrayList((Object[])new PokemonSpec[]{new PokemonSpec("ab:MagnetPull")})).setDefaultCooldownTicks(2400).setUsePP(true);
        return moveSkill.setBehaviourNoTarget(pixelmon -> {
            final World world = pixelmon.field_70170_p;
            final BlockPos middle = pixelmon.func_180425_c();
            new Timer().schedule(new TimerTask((EntityPixelmon)pixelmon){
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
                final /* synthetic */ EntityPixelmon val$pixelmon;
                {
                    this.val$pixelmon = entityPixelmon;
                }

                @Override
                public void run() {
                    ArrayList<BlockPos> oreLocations = new ArrayList<BlockPos>();
                    for (int x = middle.func_177958_n() - maxSearchRadius; x <= middle.func_177958_n() + maxSearchRadius; ++x) {
                        for (int y = middle.func_177956_o() - maxSearchRadius; y <= middle.func_177956_o() + maxSearchRadius; ++y) {
                            for (int z = middle.func_177952_p() - maxSearchRadius; z <= middle.func_177952_p() + maxSearchRadius; ++z) {
                                IBlockState state = world.func_180495_p((BlockPos)this.pos.func_181079_c(x, y, z));
                                if (!OreSense.isAnOre(state.func_177230_c())) continue;
                                oreLocations.add(new BlockPos((Vec3i)this.pos));
                            }
                        }
                    }
                    world.func_73046_m().func_152344_a(() -> {
                        EntityPlayerMP player = (EntityPlayerMP)this.val$pixelmon.func_70902_q();
                        if (player == null) {
                            return;
                        }
                        HashMap<BlockPos, Tuple<Integer, Integer>> locationColors = new HashMap<BlockPos, Tuple<Integer, Integer>>();
                        for (BlockPos pos : oreLocations) {
                            Tuple<Integer, Integer> entry;
                            int color;
                            Block block = world.func_180495_p(pos).func_177230_c();
                            if (block.getRegistryName() == null || (color = ((Integer)(entry = BlockRevealParser.getEntryForBlock(block.getRegistryName().toString())).func_76341_a()).intValue()) == -1) continue;
                            locationColors.put(pos, entry);
                        }
                        if (locationColors.isEmpty()) {
                            ChatHandler.sendFormattedChat((ICommandSender)this.val$pixelmon.func_70902_q(), TextFormatting.RED, "pixelmon.moveskill.ore_sense.none", new Object[0]);
                        } else {
                            ChatHandler.sendFormattedChat((ICommandSender)this.val$pixelmon.func_70902_q(), TextFormatting.WHITE, "pixelmon.moveskill.ore_sense.some", this.val$pixelmon.func_145748_c_());
                            Pixelmon.network.sendTo((IMessage)new IlluminatePositionsPacket(world2.field_73011_w.getDimension(), durationTicks, locationColors), player);
                        }
                    });
                }
            }, 1L);
            return moveSkill.cooldownTicks;
        });
    }

    private static boolean isAnOre(Block block) {
        if (block.getRegistryName() != null) {
            String blockName = block.getRegistryName().toString();
            return BlockRevealParser.getEntryForBlock(blockName) != null;
        }
        return false;
    }
}

