/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.EnumHeroDuo;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class CanCrownedSpec
extends SpecValue<Boolean>
implements ISpecType {
    public CanCrownedSpec(boolean value) {
        super("cancrowned", value);
    }

    @Override
    public List<String> getKeys() {
        return Lists.newArrayList((Object[])new String[]{"cancrowned"});
    }

    @Override
    public SpecValue<?> parse(@Nullable String arg) {
        try {
            return new CanCrownedSpec(arg == null || Boolean.parseBoolean(arg));
        }
        catch (Exception e) {
            return new CanCrownedSpec(true);
        }
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        return new CanCrownedSpec(nbt.func_74767_n(this.key));
    }

    public void writeToNBT(NBTTagCompound nbt, SpecValue value) {
        nbt.func_74757_a(this.key, ((Boolean)value.value).booleanValue());
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return CanCrownedSpec.class;
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return this.key + ":" + value.value.toString();
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
    }

    @Override
    public void apply(Pokemon pokemon) {
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        return pokemon.getFormEnum() == EnumHeroDuo.HERO && (pokemon.getSpecies() == EnumSpecies.Zacian && pokemon.getHeldItemAsItemHeld() == PixelmonItemsHeld.rustedSword || pokemon.getSpecies() == EnumSpecies.Zamazenta && pokemon.getHeldItemAsItemHeld() == PixelmonItemsHeld.rustedShield);
    }

    @Override
    public SpecValue<Boolean> clone() {
        return new CanCrownedSpec((Boolean)this.value);
    }
}

