/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class CustomTextureSpec
extends SpecValue<String>
implements ISpecType {
    public String value;
    public List<String> keys;

    public CustomTextureSpec(List<String> keys, String value) {
        super(keys.get(0), value);
        this.keys = keys;
        this.value = value;
    }

    @Override
    public List<String> getKeys() {
        return this.keys;
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return CustomTextureSpec.class;
    }

    @Override
    public Class<String> getValueClass() {
        return String.class;
    }

    public CustomTextureSpec parse(String arg) {
        return new CustomTextureSpec(this.keys, arg);
    }

    @Override
    public String toParameterForm(SpecValue<?> specValue) {
        return this.key + ":" + this.value;
    }

    @Override
    public SpecValue<String> clone() {
        return new CustomTextureSpec(this.keys, this.value);
    }

    public SpecValue<String> readFromNBT(NBTTagCompound nbt) {
        return this.parse(nbt.func_74779_i(this.key));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, SpecValue<?> value) {
        nbt.func_74778_a(this.key, (String)value.value);
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        if (this.value.equalsIgnoreCase("*")) {
            return !pokemon.getCustomTexture().isEmpty();
        }
        return pokemon.getCustomTexture().equalsIgnoreCase(this.value);
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
        pixelmon.getPokemonData().setCustomTexture(this.value);
    }

    @Override
    public void apply(Pokemon pokemon) {
        pokemon.setCustomTexture(this.value);
    }
}

