/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class IVEVSpec
extends SpecValue<Integer>
implements ISpecType {
    public StatsType stat;
    public String nbtTag;
    public List<String> keys;
    public boolean isIVs = true;
    public Operation operation = Operation.SET;

    public IVEVSpec(List<String> keys, String nbtTag, StatsType stat, boolean isIVs, int value, Operation operation) {
        super(keys.get(0), value);
        this.keys = keys;
        this.stat = stat;
        this.nbtTag = nbtTag;
        this.isIVs = isIVs;
        if (operation != null) {
            this.operation = operation;
        }
    }

    @Override
    public List<String> getKeys() {
        return this.keys;
    }

    public IVEVSpec parse(String arg) {
        if (arg == null) {
            return null;
        }
        Operation operation = Operation.SET;
        if (arg.contains("+")) {
            operation = Operation.ADD;
        } else if (arg.contains("-")) {
            operation = Operation.SUBTRACT;
        }
        arg = arg.replace("+", "");
        arg = arg.replace("-", "");
        int amount = -1;
        try {
            amount = Integer.parseInt(arg);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (amount < 0 || amount > (this.isIVs ? 31 : 252)) {
            return null;
        }
        return new IVEVSpec(this.keys, this.nbtTag, this.stat, this.isIVs, amount, operation);
    }

    public IVEVSpec readFromNBT(NBTTagCompound nbt) {
        return this.parse(nbt.func_74779_i(this.key));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, SpecValue<?> value) {
        nbt.func_74778_a(value.key, this.operation.sign + value.value);
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return this.getClass();
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return value.key + ":" + ((IVEVSpec)value).operation.sign + value.value.toString();
    }

    @Override
    public Class<Integer> getValueClass() {
        return Integer.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
        if (this.operation == Operation.SET) {
            if (this.isIVs) {
                pixelmon.getPokemonData().getIVs().setStat(this.stat, (Integer)this.value);
            } else {
                pixelmon.getPokemonData().getEVs().setStat(this.stat, (Integer)this.value);
            }
        } else {
            int multiplier = this.operation == Operation.ADD ? 1 : -1;
            int change = multiplier * (Integer)this.value;
            if (this.isIVs) {
                pixelmon.getPokemonData().getIVs().addStat(this.stat, change);
            } else {
                pixelmon.getPokemonData().getEVs().addStat(this.stat, change);
            }
        }
    }

    @Override
    public void apply(Pokemon pokemon) {
        if (this.operation == Operation.SET) {
            if (this.isIVs) {
                pokemon.getIVs().setStat(this.stat, (Integer)this.value);
            } else {
                pokemon.getEVs().setStat(this.stat, (Integer)this.value);
            }
        } else {
            int multiplier = this.operation == Operation.ADD ? 1 : -1;
            int change = multiplier * (Integer)this.value;
            if (this.isIVs) {
                pokemon.getIVs().addStat(this.stat, change);
            } else {
                pokemon.getEVs().addStat(this.stat, change);
            }
        }
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        if (this.operation == Operation.SET) {
            return this.isIVs ? pixelmon.getPokemonData().getIVs().getStat(this.stat) == ((Integer)this.value).intValue() : pixelmon.getPokemonData().getEVs().getStat(this.stat) == ((Integer)this.value).intValue();
        }
        if (this.operation == Operation.ADD) {
            return this.isIVs ? pixelmon.getPokemonData().getIVs().getStat(this.stat) >= (Integer)this.value : pixelmon.getPokemonData().getEVs().getStat(this.stat) >= (Integer)this.value;
        }
        return this.isIVs ? pixelmon.getPokemonData().getIVs().getStat(this.stat) <= (Integer)this.value : pixelmon.getPokemonData().getEVs().getStat(this.stat) <= (Integer)this.value;
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        if (this.operation == Operation.SET) {
            return this.isIVs ? pokemon.getIVs().getStat(this.stat) == ((Integer)this.value).intValue() : pokemon.getEVs().getStat(this.stat) == ((Integer)this.value).intValue();
        }
        if (this.operation == Operation.ADD) {
            return this.isIVs ? pokemon.getIVs().getStat(this.stat) >= (Integer)this.value : pokemon.getEVs().getStat(this.stat) >= (Integer)this.value;
        }
        return this.isIVs ? pokemon.getIVs().getStat(this.stat) <= (Integer)this.value : pokemon.getEVs().getStat(this.stat) <= (Integer)this.value;
    }

    @Override
    public SpecValue<Integer> clone() {
        return new IVEVSpec(this.keys, this.nbtTag, this.stat, this.isIVs, (Integer)this.value, this.operation);
    }

    public static enum Operation {
        ADD("+"),
        SUBTRACT("-"),
        SET("");

        public final String sign;

        private Operation(String sign) {
            this.sign = sign;
        }
    }
}

