/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.specs;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.ISpecType;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.SpecValue;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class IsLegendarySpec
extends SpecValue<Boolean>
implements ISpecType {
    public IsLegendarySpec(boolean value) {
        super("islegendary", value);
    }

    @Override
    public List<String> getKeys() {
        return Lists.newArrayList((Object[])new String[]{"legendary", "islegendary"});
    }

    @Override
    public SpecValue<?> parse(@Nullable String arg) {
        try {
            return new IsLegendarySpec(Boolean.parseBoolean(arg));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public SpecValue<?> readFromNBT(NBTTagCompound nbt) {
        return new IsLegendarySpec(nbt.func_74767_n(this.key));
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, SpecValue<?> value) {
        nbt.func_74757_a(this.key, ((Boolean)value.value).booleanValue());
    }

    @Override
    public Class<? extends SpecValue<?>> getSpecClass() {
        return IsLegendarySpec.class;
    }

    @Override
    public String toParameterForm(SpecValue<?> value) {
        return "islegendary:" + value.value.toString();
    }

    @Override
    public Class<Boolean> getValueClass() {
        return Boolean.class;
    }

    @Override
    public void apply(EntityPixelmon pixelmon) {
        this.apply(pixelmon.getPokemonData());
    }

    @Override
    public void apply(Pokemon pokemon) {
        if (((Boolean)this.value).booleanValue()) {
            pokemon.setSpecies(CollectionHelper.getRandomElement(EnumSpecies.legendaries), true);
        } else {
            pokemon.setSpecies(EnumSpecies.randomPoke(false), true);
        }
    }

    @Override
    public boolean matches(EntityPixelmon pixelmon) {
        return this.matches(pixelmon.getPokemonData());
    }

    @Override
    public boolean matches(Pokemon pokemon) {
        return pokemon.isLegendary() == ((Boolean)this.value).booleanValue();
    }

    @Override
    public SpecValue<Boolean> clone() {
        return new IsLegendarySpec((Boolean)this.value);
    }
}

