/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.SpawnLocationType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Aggression;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStatsLoader;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.EntityBoundsData;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.FlyingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.MountedFlying;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.RidingOffsets;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.SwimmingParameters;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.LevelCondition;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.types.LevelingEvolution;
import com.pixelmonmod.pixelmon.enums.EnumEggGroup;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.ExperienceGroup;
import com.pixelmonmod.pixelmon.enums.forms.EnumNoForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen1TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen2TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen3TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen4TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen5TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen6TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen7TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.SoundEvent;
import org.apache.commons.lang3.tuple.Pair;

public class BaseStats {
    @Deprecated
    public static final transient Gson GSON = BaseStatsLoader.GSON;
    public static final transient EnumMap<EnumSpecies, BaseStats> allBaseStats = Maps.newEnumMap(EnumSpecies.class);
    @Deprecated
    public String pixelmonName;
    @Deprecated
    public EnumSpecies pokemon;
    @Deprecated
    public transient int nationalPokedexNumber;
    @Deprecated
    public int form = 0;
    @Deprecated
    public LinkedHashMap<StatsType, Integer> stats = null;
    @Deprecated
    public Integer catchRate = null;
    @Deprecated
    public Double malePercent = null;
    @Deprecated
    public Integer spawnLevel = null;
    @Deprecated
    public Integer spawnLevelRange = null;
    @Deprecated
    public Integer baseExp = null;
    @Deprecated
    public Integer baseFriendship = null;
    @Deprecated
    public ArrayList<EnumType> types = null;
    @Deprecated
    public Float height = null;
    @Deprecated
    public Float width = null;
    @Deprecated
    public Float length = null;
    @Deprecated
    public Boolean isRideable = null;
    @Deprecated
    public Boolean canFly = null;
    @Deprecated
    public Boolean canSurf = null;
    @Deprecated
    public Boolean canShoulder = null;
    public String[] preEvolutions = null;
    public transient PokemonSpec[] specPreEvolutions = null;
    public transient EnumSpecies[] legacyPreEvolutions = null;
    @Deprecated
    public ExperienceGroup experienceGroup = null;
    @Deprecated
    public Aggression aggression = null;
    public SwimmingParameters swimmingParameters = null;
    public FlyingParameters flyingParameters = null;
    public MountedFlying mountedFlying = null;
    public SpawnLocationType[] spawnLocations = null;
    public LinkedHashMap<StatsType, Integer> evYields = null;
    public RidingOffsets ridingOffsets = null;
    @Deprecated
    public Float hoverHeight = null;
    @Deprecated
    public Float weight = null;
    private EntityBoundsData bounding_box = null;
    @Deprecated
    public ArrayList<Evolution> evolutions = null;
    @Deprecated
    public String[] abilities = null;
    public EnumEggGroup[] eggGroups = null;
    @Deprecated
    public Integer eggCycles = null;
    @Deprecated
    public LinkedHashMap<Integer, LinkedHashSet<Attack>> levelUpMoves = null;
    @Deprecated
    public LinkedHashSet<Attack> tmMoves = null;
    @Deprecated
    public LinkedHashSet<Attack> tutorMoves = null;
    @Deprecated
    public LinkedHashSet<Attack> eggMoves = null;
    private LinkedHashSet<Attack> transferMoves = null;
    private LinkedHashSet<AttackBase> hmMoves = null;
    private LinkedHashSet<Gen8TechnicalRecords> trMoves = null;
    private LinkedHashSet<Gen8TechnicalMachines> tmMoves8 = null;
    private LinkedHashSet<Gen7TechnicalMachines> tmMoves7 = null;
    private LinkedHashSet<Gen6TechnicalMachines> tmMoves6 = null;
    private LinkedHashSet<Gen5TechnicalMachines> tmMoves5 = null;
    private LinkedHashSet<Gen4TechnicalMachines> tmMoves4 = null;
    private LinkedHashSet<Gen3TechnicalMachines> tmMoves3 = null;
    private LinkedHashSet<Gen2TechnicalMachines> tmMoves2 = null;
    private LinkedHashSet<Gen1TechnicalMachines> tmMoves1 = null;
    public LinkedHashMap<Integer, BaseStats> forms = null;
    public transient BaseStats parent = null;
    private final transient HashMap<SoundType, ArrayList<SoundEvent>> sounds = new HashMap();
    private transient boolean[] soundRegistered = new boolean[]{false, false, false};
    public transient int minLevel = 1;
    public transient int maxLevel = PixelmonServerConfig.maxLevel;

    BaseStats() {
    }

    public EnumSpecies getSpecies() {
        return this.pokemon;
    }

    public String getPokemonName() {
        return this.pixelmonName;
    }

    public int getFormNumber() {
        return this.form;
    }

    public IEnumForm getEnumForm() {
        return this.getSpecies().getFormEnum(this.getFormNumber());
    }

    public int getStat(StatsType stat) {
        return this.stats.getOrDefault(stat, -1);
    }

    @Deprecated
    public int get(StatsType stat) {
        return this.stats.getOrDefault(stat, -1);
    }

    public int getCatchRate() {
        return this.catchRate;
    }

    public double getMalePercent() {
        return this.malePercent;
    }

    public boolean isMaleOnly() {
        return this.malePercent >= 100.0;
    }

    public boolean isFemaleOnly() {
        return this.malePercent == 0.0;
    }

    public boolean isGenderless() {
        return this.malePercent < 0.0;
    }

    public Gender getRandomGender(Random random) {
        if (this.isGenderless()) {
            return Gender.None;
        }
        if (this.isFemaleOnly()) {
            return Gender.Female;
        }
        if (this.isMaleOnly()) {
            return Gender.Male;
        }
        return random.nextDouble() * 100.0 < this.malePercent ? Gender.Male : Gender.Female;
    }

    public int getSpawnLevel() {
        return this.spawnLevel;
    }

    public int getSpawnLevelRange() {
        return this.spawnLevelRange;
    }

    public int getBaseExp() {
        return this.baseExp;
    }

    public int getBaseFriendship() {
        return this.baseFriendship;
    }

    public List<EnumType> getTypeList() {
        return this.types;
    }

    public EnumType getType1() {
        return this.types.get(0);
    }

    public EnumType getType2() {
        return this.types.size() > 1 ? this.types.get(1) : null;
    }

    @Deprecated
    public Float getHeight() {
        return this.height;
    }

    @Deprecated
    public Float getWidth() {
        return Float.valueOf((float)this.getBoundsData().getWidth());
    }

    @Deprecated
    public Float getLength() {
        return Float.valueOf((float)this.getBoundsData().getWidth());
    }

    public Boolean IsRideable() {
        return this.isRideable;
    }

    public Boolean canFly() {
        return this.canFly;
    }

    public Boolean canSurf() {
        return this.canSurf;
    }

    public Boolean canShoulder() {
        return this.canShoulder;
    }

    public ExperienceGroup getExperienceGroup() {
        return this.experienceGroup;
    }

    public Aggression getAggression() {
        return this.aggression;
    }

    public List<SpawnLocationType> getSpawnLocations() {
        return this.spawnLocations != null ? ImmutableList.copyOf((Object[])this.spawnLocations) : Collections.emptyList();
    }

    @Deprecated
    public float getHoverHeight() {
        return 0.0f;
    }

    public EntityBoundsData getBoundsData() {
        if (this.bounding_box == null) {
            this.bounding_box = new EntityBoundsData(this.width != null ? Double.parseDouble(this.width.toString()) : 1.0, this.height != null ? Double.parseDouble(this.height.toString()) : 1.0, (this.height != null ? this.height.floatValue() : 1.0f) * 0.85f);
        }
        return this.bounding_box;
    }

    @Deprecated
    public boolean hovers() {
        return false;
    }

    public float getWeight() {
        return this.weight.floatValue();
    }

    @Nonnull
    public List<Evolution> getEvolutions() {
        return this.evolutions != null ? ImmutableList.copyOf(this.evolutions) : Collections.emptyList();
    }

    public String[] getAbilitiesArray() {
        return this.abilities;
    }

    public List<AbilityBase> getAllAbilities() {
        return Arrays.stream(this.abilities).filter(Objects::nonNull).map(AbilityBase::getAbility).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public Optional<AbilityBase> getHiddenAbility() {
        return this.abilities[2] != null ? AbilityBase.getAbility(this.abilities[2]) : Optional.empty();
    }

    public boolean hasAbility(String ability) {
        int n = 0;
        String[] stringArray = this.abilities;
        int n2 = stringArray.length;
        if (n < n2) {
            String ab = stringArray[n];
            return ab != null && ab.toLowerCase().replace(" ", "").equals(ability.toLowerCase().replace(" ", ""));
        }
        return false;
    }

    public EnumEggGroup[] getEggGroupsArray() {
        return this.eggGroups;
    }

    public List<EnumEggGroup> getEggGroups() {
        return Lists.newArrayList((Object[])this.eggGroups);
    }

    public boolean hasEggGroup(EnumEggGroup group) {
        return this.getEggGroups().contains((Object)group);
    }

    public Integer getEggCycles() {
        return this.eggCycles;
    }

    public BaseStats getParent() {
        return this.parent == null ? this : this.parent;
    }

    public void expand(BaseStats comparison) {
        this.nationalPokedexNumber = comparison.nationalPokedexNumber;
        for (Field f : this.getClass().getDeclaredFields()) {
            try {
                String name = f.getName();
                if (name.equals("forms")) continue;
                Object o1 = f.get(this);
                Object o2 = f.get(comparison);
                EnumSpecies species = comparison.getSpecies();
                if (species.getFormEnum(this.form).isRegionalForm() && (name.equals("transferMoves") || name.equals("trMoves") || name.startsWith("tmMoves")) || o1 != null || o2 == null) continue;
                f.set(this, o2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<Pair<Integer, AttackBase>> getFormatLevelMoves() {
        ArrayList<Pair<Integer, AttackBase>> check = new ArrayList<Pair<Integer, AttackBase>>();
        for (Map.Entry<Integer, List<AttackBase>> entry : this.getLevelupMoves().entrySet()) {
            Integer lv = entry.getKey();
            List<AttackBase> ab = entry.getValue();
            for (AttackBase a : ab) {
                check.add((Pair<Integer, AttackBase>)Pair.of((Object)lv, (Object)a));
            }
        }
        check.sort(Comparator.comparingInt(Pair::getLeft));
        return check;
    }

    public void addSound(SoundType type, SoundEvent sound) {
        ArrayList stats = Lists.newArrayList((Object[])new BaseStats[]{this});
        if (this.forms != null) {
            stats.addAll(this.forms.values());
        }
        for (BaseStats form : stats) {
            ArrayList<SoundEvent> list = form.sounds.getOrDefault((Object)type, new ArrayList());
            if (!this.soundRegistered[type.ordinal()]) {
                list.clear();
            }
            list.add(sound);
            form.sounds.put(type, list);
            if (this != form) continue;
            this.soundRegistered[type.ordinal()] = true;
        }
    }

    public SoundEvent getSound(SoundType type) {
        ArrayList<SoundEvent> list = this.sounds.get((Object)type);
        if (list == null) {
            return null;
        }
        return RandomHelper.getRandomElementFromList(list);
    }

    private boolean hasSound(SoundType type) {
        return this.sounds.containsKey((Object)type);
    }

    public boolean hasSoundForGender(Gender gender) {
        return this.sounds.containsKey((Object)(gender == Gender.Male ? SoundType.Male : SoundType.Female)) || this.sounds.containsKey((Object)SoundType.Neutral);
    }

    public SoundEvent getSoundForGender(Gender gender) {
        if (gender == Gender.Male) {
            if (this.hasSound(SoundType.Male)) {
                return this.getSound(SoundType.Male);
            }
        } else if (gender == Gender.Female && this.hasSound(SoundType.Female)) {
            return this.getSound(SoundType.Female);
        }
        if (this.hasSound(SoundType.Neutral)) {
            return this.getSound(SoundType.Neutral);
        }
        return null;
    }

    public void calculateMinMaxLevels() {
        this.maxLevel = this.getHighestFeasibleLevel();
        if (this.maxLevel == -1) {
            this.maxLevel = PixelmonServerConfig.maxLevel;
        }
        this.minLevel = 1;
        if (this.legacyPreEvolutions != null && this.legacyPreEvolutions.length > 0) {
            for (EnumSpecies preEvo : this.legacyPreEvolutions) {
                try {
                    BaseStats preEvoBS;
                    if (preEvo == null) continue;
                    IEnumForm formEnum = preEvo.getFormEnum(this.form);
                    if (formEnum == null) {
                        formEnum = EnumNoForm.NoForm;
                    }
                    if ((preEvoBS = preEvo.getBaseStats(formEnum)) == null) break;
                    int level = preEvoBS.getHighestFeasibleLevel();
                    if (level <= this.minLevel) continue;
                    this.minLevel = level;
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.maxLevel < this.minLevel) {
            this.minLevel = this.maxLevel;
        }
    }

    public int getHighestFeasibleLevel() {
        int maxLevel = -1;
        if (!this.getEvolutions().isEmpty()) {
            for (Evolution evolution : this.getEvolutions()) {
                int level;
                if (evolution == null) continue;
                if (evolution instanceof LevelingEvolution && (level = ((LevelingEvolution)evolution).getLevel()) > maxLevel) {
                    maxLevel = level;
                }
                for (LevelCondition condition : evolution.getConditionsOfType(LevelCondition.class)) {
                    if (condition.level <= maxLevel) continue;
                    maxLevel = condition.level;
                }
            }
        }
        return maxLevel;
    }

    public void initLevelupMoves() {
        if (this.levelUpMoves.containsKey(0)) {
            if (!this.levelUpMoves.containsKey(1)) {
                this.levelUpMoves.put(1, new LinkedHashSet());
            }
            this.levelUpMoves.get(1).addAll((Collection<Attack>)this.levelUpMoves.get(0));
            this.levelUpMoves.remove(0);
        }
    }

    public Map<Integer, List<AttackBase>> getLevelupMoves() {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<Integer, LinkedHashSet<Attack>> entry : this.levelUpMoves.entrySet()) {
            int key = entry.getKey() == 0 ? 1 : entry.getKey();
            map.put(key, entry.getValue().stream().map(Attack::getActualMove).collect(ImmutableList.toImmutableList()));
        }
        return map;
    }

    public ArrayList<Attack> getMovesUpToLevel(int level) {
        LinkedHashSet<Attack> attacks = new LinkedHashSet<Attack>();
        for (int i = 0; i <= level; ++i) {
            if (this.levelUpMoves == null || !this.levelUpMoves.containsKey(i)) continue;
            attacks.addAll((Collection<Attack>)this.levelUpMoves.get(i));
        }
        return new ArrayList<Attack>(BaseStats.severReferences(attacks));
    }

    public ArrayList<Attack> getMovesAtLevel(int level) {
        if (level == 0 || level == 1) {
            level = 1;
        }
        if (this.levelUpMoves != null && this.levelUpMoves.containsKey(level)) {
            return new ArrayList<Attack>(BaseStats.severReferences((Collection<Attack>)this.levelUpMoves.get(level)));
        }
        return new ArrayList<Attack>();
    }

    public Moveset loadMoveset(int level) {
        ArrayList<Attack> attackList = this.getMovesUpToLevel(level);
        while (attackList.size() > 4) {
            if (PixelmonConfig.useRecentLevelMoves) {
                attackList.remove(0);
                continue;
            }
            RandomHelper.removeRandomElementFromList(attackList);
        }
        if (attackList.isEmpty()) {
            attackList.add(new Attack("Tackle"));
        }
        Moveset moveset = new Moveset();
        moveset.addAll(BaseStats.severReferences(attackList));
        return moveset;
    }

    @Deprecated
    public LinkedHashSet<Attack> getTMHMMoves() {
        if (this.tmMoves != null) {
            return BaseStats.severReferences(this.tmMoves);
        }
        return new LinkedHashSet<Attack>();
    }

    public List<AttackBase> getLegacyTMMoves() {
        if (this.tmMoves != null) {
            return this.tmMoves.stream().map(Attack::getActualMove).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public List<ITechnicalMove> getTMMovesFor(int gen) {
        switch (gen) {
            case 1: {
                return this.tmMoves1 != null ? new ArrayList<Gen1TechnicalMachines>(this.tmMoves1) : Collections.emptyList();
            }
            case 2: {
                return this.tmMoves2 != null ? new ArrayList<Gen2TechnicalMachines>(this.tmMoves2) : Collections.emptyList();
            }
            case 3: {
                return this.tmMoves3 != null ? new ArrayList<Gen3TechnicalMachines>(this.tmMoves3) : Collections.emptyList();
            }
            case 4: {
                return this.tmMoves4 != null ? new ArrayList<Gen4TechnicalMachines>(this.tmMoves4) : Collections.emptyList();
            }
            case 5: {
                return this.tmMoves5 != null ? new ArrayList<Gen5TechnicalMachines>(this.tmMoves5) : Collections.emptyList();
            }
            case 6: {
                return this.tmMoves6 != null ? new ArrayList<Gen6TechnicalMachines>(this.tmMoves6) : Collections.emptyList();
            }
            case 7: {
                return this.tmMoves7 != null ? new ArrayList<Gen7TechnicalMachines>(this.tmMoves7) : Collections.emptyList();
            }
            case 8: {
                return this.tmMoves8 != null ? new ArrayList<Gen8TechnicalMachines>(this.tmMoves8) : Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public ArrayList<Attack> getTutorMoves() {
        if (this.tutorMoves != null) {
            return new ArrayList<Attack>(BaseStats.severReferences(this.tutorMoves));
        }
        return new ArrayList<Attack>();
    }

    public ArrayList<Attack> getTransferMoves() {
        if (this.transferMoves != null) {
            return new ArrayList<Attack>(BaseStats.severReferences(this.transferMoves));
        }
        return new ArrayList<Attack>();
    }

    public ArrayList<Attack> getEggMoves() {
        if (this.eggMoves != null) {
            return new ArrayList<Attack>(BaseStats.severReferences(this.eggMoves));
        }
        return new ArrayList<Attack>();
    }

    public List<ITechnicalMove> getTMMoves() {
        if (this.tmMoves8 == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.tmMoves8);
    }

    public List<ITechnicalMove> getTrMoves() {
        if (this.trMoves == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.trMoves);
    }

    public List<AttackBase> getHmMoves() {
        if (this.hmMoves == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf(this.hmMoves);
    }

    public ArrayList<Attack> getAllMoves() {
        ArrayList<Attack> moves = new ArrayList<Attack>();
        if (this.levelUpMoves != null && !this.levelUpMoves.isEmpty()) {
            for (Map.Entry<Integer, LinkedHashSet<Attack>> entry : this.levelUpMoves.entrySet()) {
                moves.addAll(BaseStats.severReferences((Collection<Attack>)entry.getValue()));
            }
        }
        moves.addAll(this.getLegacyTMMoves().stream().map(Attack::new).collect(Collectors.toList()));
        moves.addAll(this.getTMMoves().stream().map(ITechnicalMove::getAttack).map(Attack::new).collect(Collectors.toList()));
        moves.addAll(this.getTrMoves().stream().map(ITechnicalMove::getAttack).map(Attack::new).collect(Collectors.toList()));
        moves.addAll(this.getHmMoves().stream().map(Attack::new).collect(Collectors.toList()));
        moves.addAll(this.getTutorMoves());
        moves.addAll(this.getTransferMoves());
        moves.addAll(this.getEggMoves());
        ArrayList<Attack> distinctMoves = new ArrayList<Attack>();
        for (Attack attack : moves) {
            if (distinctMoves.contains(attack)) continue;
            distinctMoves.add(attack);
        }
        return distinctMoves;
    }

    public boolean canLearn(String attackName) {
        ArrayList<Attack> allMoves = this.getAllMoves();
        for (Attack attack : allMoves) {
            if (!attack.isAttack(attackName)) continue;
            return true;
        }
        return false;
    }

    public boolean canLearn(ITechnicalMove move) {
        if (PixelmonServerConfig.superUniversalTMs) {
            return this.canLearn(move.getAttackName()) || this.getTMMovesFor(move.getGeneration()).contains(move) || this.canLearnViaOtherSet(move);
        }
        if (PixelmonServerConfig.universalTMs) {
            return this.canLearnTMTRHM(move.getAttackName()) || this.getTMMovesFor(move.getGeneration()).contains(move) || this.canLearnViaOtherSet(move);
        }
        return this.trMoves != null && this.trMoves.contains(move) || this.tmMoves8 != null && this.tmMoves8.contains(move) || this.tmMoves7 != null && this.tmMoves7.contains(move) || this.tmMoves6 != null && this.tmMoves6.contains(move) || this.tmMoves5 != null && this.tmMoves5.contains(move) || this.tmMoves4 != null && this.tmMoves4.contains(move) || this.tmMoves3 != null && this.tmMoves3.contains(move) || this.tmMoves2 != null && this.tmMoves2.contains(move) || this.tmMoves1 != null && this.tmMoves1.contains(move);
    }

    public boolean canLearnHM(AttackBase attack) {
        if (PixelmonServerConfig.superUniversalTMs) {
            return this.canLearn(attack.getAttackName());
        }
        if (PixelmonServerConfig.universalTMs) {
            return this.canLearnTMTRHM(attack.getAttackName());
        }
        return this.hmMoves.contains(attack);
    }

    public boolean canLearnViaOtherSet(ITechnicalMove move) {
        return !(move instanceof Gen8TechnicalRecords) && this.trMoves != null && this.isMoveInSet(this.trMoves, move.getAttackName()) || !(move instanceof Gen8TechnicalMachines) && this.tmMoves8 != null && this.isMoveInSet(this.tmMoves8, move.getAttackName()) || !(move instanceof Gen7TechnicalMachines) && this.tmMoves7 != null && this.isMoveInSet(this.tmMoves7, move.getAttackName()) || !(move instanceof Gen6TechnicalMachines) && this.tmMoves6 != null && this.isMoveInSet(this.tmMoves6, move.getAttackName()) || !(move instanceof Gen5TechnicalMachines) && this.tmMoves5 != null && this.isMoveInSet(this.tmMoves5, move.getAttackName()) || !(move instanceof Gen4TechnicalMachines) && this.tmMoves4 != null && this.isMoveInSet(this.tmMoves4, move.getAttackName()) || !(move instanceof Gen3TechnicalMachines) && this.tmMoves3 != null && this.isMoveInSet(this.tmMoves3, move.getAttackName()) || !(move instanceof Gen2TechnicalMachines) && this.tmMoves2 != null && this.isMoveInSet(this.tmMoves2, move.getAttackName()) || !(move instanceof Gen1TechnicalMachines) && this.tmMoves1 != null && this.isMoveInSet(this.tmMoves1, move.getAttackName());
    }

    public Set<AttackBase> getAllTMTRHMMoves() {
        HashSet<AttackBase> moves = new HashSet<AttackBase>();
        moves.addAll(this.getLegacyTMMoves());
        moves.addAll(this.getTMMoves().stream().map(ITechnicalMove::getAttack).collect(Collectors.toList()));
        moves.addAll(this.getTrMoves().stream().map(ITechnicalMove::getAttack).collect(Collectors.toList()));
        moves.addAll(this.getHmMoves());
        return moves;
    }

    public boolean canLearnTMTRHM(String attackName) {
        Set<AttackBase> moves = this.getAllTMTRHMMoves();
        for (AttackBase attack : moves) {
            if (!attack.isAttack(attackName)) continue;
            return true;
        }
        return false;
    }

    public boolean isMoveInSet(LinkedHashSet<? extends ITechnicalMove> tms, String attack) {
        for (ITechnicalMove iTechnicalMove : tms) {
            if (!attack.equalsIgnoreCase(iTechnicalMove.getAttackName())) continue;
            return true;
        }
        return false;
    }

    public boolean canLearn(AttackBase attack, BaseStatsLearnType ... types) {
        for (BaseStatsLearnType type : types) {
            if (!type.canLearn(this, attack)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static void loadAllBaseStats() {
        BaseStatsLoader.loadAllBaseStats();
    }

    private static LinkedHashSet<Attack> severReferences(Collection<Attack> attacks) {
        LinkedHashSet<Attack> newAttacks = new LinkedHashSet<Attack>(attacks.size());
        for (Attack oldAttack : attacks) {
            if (oldAttack == null) continue;
            newAttacks.add(new Attack(oldAttack.getActualMove()));
        }
        return newAttacks;
    }

    public static enum SoundType {
        Neutral,
        Male,
        Female;

    }
}

