/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import java.util.List;
import java.util.function.BiPredicate;

public enum BaseStatsLearnType {
    LEVELUP_MOVES((bs, ab) -> {
        for (List<AttackBase> list : bs.getLevelupMoves().values()) {
            if (!list.contains(ab)) continue;
            return true;
        }
        return false;
    }),
    ALL_TR_MOVES((bs, ab) -> {
        for (ITechnicalMove tr : bs.getTrMoves()) {
            if (tr.getAttack() != ab) continue;
            return true;
        }
        return false;
    }),
    ALL_TM_MOVES((bs, ab) -> {
        for (int i = 1; i <= 8; ++i) {
            for (ITechnicalMove tm : bs.getTMMovesFor(i)) {
                if (tm.getAttack() != ab) continue;
                return true;
            }
        }
        return false;
    }),
    HM_MOVES((bs, ab) -> bs.getHmMoves().contains(ab)),
    TUTOR_MOVES((bs, ab) -> bs.getTutorMoves().stream().map(Attack::getMove).anyMatch(it -> it == ab)),
    TRANSFER_MOVES((bs, ab) -> bs.getTransferMoves().stream().map(Attack::getMove).anyMatch(it -> it == ab)),
    EGG_MOVES((bs, ab) -> bs.getEggMoves().stream().map(Attack::getMove).anyMatch(it -> it == ab)),
    GEN8_TM_MOVES(BaseStatsLearnType.technicalMachine(8)),
    GEN7_TM_MOVES(BaseStatsLearnType.technicalMachine(7)),
    GEN6_TM_MOVES(BaseStatsLearnType.technicalMachine(6)),
    GEN5_TM_MOVES(BaseStatsLearnType.technicalMachine(5)),
    GEN4_TM_MOVES(BaseStatsLearnType.technicalMachine(4)),
    GEN3_TM_MOVES(BaseStatsLearnType.technicalMachine(3)),
    GEN2_TM_MOVES(BaseStatsLearnType.technicalMachine(2)),
    GEN1_TM_MOVES(BaseStatsLearnType.technicalMachine(1));

    public static final BaseStatsLearnType[] GEN8_DEFAULT;
    private BiPredicate<BaseStats, AttackBase> canLearn;
    private static final BaseStatsLearnType[] VALUES;

    private BaseStatsLearnType(BiPredicate<BaseStats, AttackBase> canLearn) {
        this.canLearn = canLearn;
    }

    public boolean canLearn(BaseStats bs, AttackBase ab) {
        return this.canLearn.test(bs, ab);
    }

    public static BaseStatsLearnType fromOrdinal(int orinal) {
        if (orinal >= 0 && orinal < VALUES.length) {
            return VALUES[orinal];
        }
        return null;
    }

    private static BiPredicate<BaseStats, AttackBase> technicalMachine(int gen) {
        return (bs, ab) -> {
            for (ITechnicalMove tm : bs.getTMMovesFor(gen)) {
                if (tm.getAttack() != ab) continue;
                return true;
            }
            return false;
        };
    }

    static {
        GEN8_DEFAULT = new BaseStatsLearnType[]{LEVELUP_MOVES, ALL_TR_MOVES, HM_MOVES, TUTOR_MOVES, TRANSFER_MOVES, EGG_MOVES, GEN8_TM_MOVES};
        VALUES = BaseStatsLearnType.values();
    }
}

