/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.AttackBaseAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.AttackTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvoConditionTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.Evolution;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.EvolutionTypeAdapter;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.evolution.conditions.EvoCondition;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class BaseStatsLoader {
    public static final transient Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Evolution.class, (Object)new EvolutionTypeAdapter()).registerTypeAdapter(EvoCondition.class, (Object)new EvoConditionTypeAdapter()).registerTypeAdapter(Attack.class, (Object)new AttackTypeAdapter()).registerTypeAdapter(AttackBase.class, (Object)new AttackBaseAdapter()).registerTypeAdapter(PokemonSpec.class, (Object)PokemonSpec.SPEC_ADAPTER).registerTypeHierarchyAdapter(ITechnicalMove.class, (Object)new ITechnicalMove.Adapter()).create();

    /*
     * WARNING - void declaration
     */
    public static void loadAllBaseStats() {
        if (PixelmonConfig.useExternalJSONFilesStats) {
            new File("./pixelmon/stats/").mkdirs();
        }
        for (EnumSpecies species : EnumSpecies.values()) {
            try {
                void var4_11;
                void var4_9;
                if (!PixelmonConfig.useExternalJSONFilesStats) {
                    BaseStats.allBaseStats.put(species, BaseStatsLoader.getBaseStatsFromAssets(species));
                    continue;
                }
                Object var4_7 = null;
                try {
                    BaseStats baseStats = BaseStatsLoader.getBaseStatsFromExternal(species, true);
                }
                catch (Exception e) {
                    Pixelmon.LOGGER.error("Could not load external base stat file for {}", (Object)species.name());
                    e.printStackTrace();
                }
                if (var4_9 == null) {
                    Pixelmon.LOGGER.warn("Failed to load external base stat file for {}, Loading internal instead", (Object)species.name());
                    BaseStats baseStats = BaseStatsLoader.getBaseStatsFromAssets(species);
                }
                BaseStats.allBaseStats.put(species, (BaseStats)var4_11);
            }
            catch (Exception exception) {
                Pixelmon.LOGGER.error("Could not load base stats for {}, file: {}.json, external: {}", (Object)species.getPokemonName(), (Object)(PixelmonConfig.useExternalJSONFilesStats ? species.name() : species.getNationalPokedexNumber()), (Object)PixelmonConfig.useExternalJSONFilesStats);
                exception.printStackTrace();
            }
        }
        for (BaseStats stat : BaseStats.allBaseStats.values()) {
            ArrayList stats = Lists.newArrayList((Object[])new BaseStats[]{stat});
            if (stat.forms != null) {
                stats.addAll(stat.forms.values());
            }
            stat.initLevelupMoves();
            if (stat.forms != null) {
                for (Map.Entry entry : stat.forms.entrySet()) {
                    ((BaseStats)entry.getValue()).initLevelupMoves();
                    if (((BaseStats)entry.getValue()).form != 0) continue;
                    ((BaseStats)entry.getValue()).form = (Integer)entry.getKey();
                }
            }
            for (BaseStats baseStats : stats) {
                AttackBase ab;
                for (Attack a : baseStats.getTutorMoves()) {
                    ab = a.getActualMove();
                    if (NPCTutor.allTutorMoves.contains(ab)) continue;
                    NPCTutor.allTutorMoves.add(ab);
                }
                for (Attack a : baseStats.getTransferMoves()) {
                    ab = a.getActualMove();
                    if (NPCTutor.allTransferMoves.contains(ab)) continue;
                    NPCTutor.allTransferMoves.add(ab);
                }
                baseStats.calculateMinMaxLevels();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BaseStats getBaseStatsFromAssets(EnumSpecies species) throws IOException {
        String path = "/assets/pixelmon/stats/" + species.getNationalPokedexNumber() + ".json";
        try (InputStreamReader reader = new InputStreamReader(BaseStats.class.getResourceAsStream(path));){
            BaseStats bs = (BaseStats)GSON.fromJson((Reader)reader, BaseStats.class);
            BaseStatsLoader.prepare(species, bs);
            BaseStats baseStats = bs;
            return baseStats;
        }
        catch (Exception e) {
            Pixelmon.LOGGER.error("Couldn't load internal stat JSON: " + path);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static BaseStats getBaseStatsFromExternal(EnumSpecies species, boolean exportIfMissing) throws IOException {
        File file = new File("./pixelmon/stats/" + species.name() + ".json");
        if (!file.exists()) {
            if (!exportIfMissing) return null;
            String path = "/assets/pixelmon/stats/" + species.getNationalPokedexNumber() + ".json";
            try (InputStream iStream = BaseStats.class.getResourceAsStream(path);){
                Files.copy(iStream, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                Pixelmon.LOGGER.error("Failed to export base stat file {}", (Object)path);
                e.printStackTrace();
            }
        }
        if (!file.exists()) return null;
        try (FileReader reader = new FileReader(file);){
            BaseStats bs = (BaseStats)BaseStats.GSON.fromJson((Reader)reader, BaseStats.class);
            BaseStatsLoader.prepare(species, bs);
            BaseStats baseStats = bs;
            return baseStats;
        }
    }

    private static void prepare(EnumSpecies species, BaseStats bs) {
        bs.nationalPokedexNumber = species.getNationalPokedexInteger();
        String[] stringArray = bs.preEvolutions = bs.preEvolutions == null ? new String[]{} : bs.preEvolutions;
        if (bs.forms != null && !bs.forms.isEmpty()) {
            for (BaseStats form : bs.forms.values()) {
                form.expand(bs);
            }
        }
        ArrayList<EnumSpecies> legacyPreEvolutions = new ArrayList<EnumSpecies>();
        ArrayList<PokemonSpec> specPreEvolutions = new ArrayList<PokemonSpec>();
        for (String preEvolution : bs.preEvolutions) {
            PokemonSpec spec = new PokemonSpec(preEvolution.split(" "));
            if (spec == null) continue;
            Optional<EnumSpecies> s = EnumSpecies.getFromName(spec.name);
            if (!s.isPresent() || s.get() == null) {
                Pixelmon.LOGGER.error("Found Invalid pokemonSpec in preEvolutions for " + species.name() + ".json matching \"" + spec.toString() + "\"");
                continue;
            }
            legacyPreEvolutions.add(s.get());
            specPreEvolutions.add(spec);
        }
        bs.specPreEvolutions = new PokemonSpec[specPreEvolutions == null ? 0 : specPreEvolutions.size()];
        specPreEvolutions.toArray(bs.specPreEvolutions);
        bs.legacyPreEvolutions = new EnumSpecies[legacyPreEvolutions == null ? 0 : legacyPreEvolutions.size()];
        legacyPreEvolutions.toArray(bs.legacyPreEvolutions);
    }
}

