/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;

public enum Gender implements IEnumForm
{
    Male,
    Female,
    None;


    @Override
    public String getSpriteSuffix(boolean shiny) {
        return this == None ? "" : "-" + this.name().toLowerCase();
    }

    @Override
    public String getFormSuffix() {
        return this == None ? "" : this.name().toLowerCase();
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.gender.form." + this.name().toLowerCase();
    }

    public boolean isCompatible(Gender otherGender) {
        return this == Male && otherGender == Female || this == Female && otherGender == Male;
    }

    public static Gender getGender(short ord) {
        for (Gender g : Gender.values()) {
            if (g.ordinal() != ord) continue;
            return g;
        }
        return Male;
    }

    public static Gender getGender(String name) {
        for (Gender gender : Gender.values()) {
            if (!gender.name().toLowerCase().startsWith(name.toLowerCase())) continue;
            return gender;
        }
        return null;
    }

    public static Gender getRandomGender(BaseStats baseStats) {
        if (baseStats.getMalePercent() < 0.0) {
            return None;
        }
        if (RandomHelper.rand.nextDouble() * 100.0 < baseStats.getMalePercent()) {
            return Male;
        }
        return Female;
    }

    @Override
    public String getName() {
        return this.name();
    }
}

