/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.events.pokemon.MovesetEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import io.netty.buffer.ByteBuf;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.eventhandler.Event;

public class Moveset
extends AbstractList<Attack>
implements RandomAccess,
Cloneable {
    public Pokemon pokemon = null;
    public Attack[] attacks = new Attack[4];
    private final List<AttackBase> reminderMoves = Lists.newArrayList();

    public Moveset() {
    }

    public Moveset(Attack[] attacks) {
        this.attacks = attacks;
    }

    public Moveset(int index, Attack a) {
        this.attacks[0] = a;
    }

    public Moveset withPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
        return this;
    }

    @Override
    public Attack get(int index) {
        if (index < 0 || index > 3) {
            return null;
        }
        return this.attacks[index];
    }

    @Override
    public boolean add(Attack a) {
        if (this.size() >= 4) {
            return false;
        }
        this.set(this.size(), a);
        return true;
    }

    @Override
    public Attack set(int index, Attack a) {
        Attack previousAttack = this.attacks[index];
        this.attacks[index] = a;
        this.tryNotifyPokemon();
        if (this.pokemon == null || this.pokemon.getOwnerPlayer() == null) {
            return previousAttack;
        }
        if (previousAttack != null) {
            Pixelmon.EVENT_BUS.post((Event)new MovesetEvent.ForgotMoveEvent(this.pokemon, this, previousAttack));
        }
        if (a != null) {
            Pixelmon.EVENT_BUS.post((Event)new MovesetEvent.LearntMoveEvent(this.pokemon, this, previousAttack, a));
        }
        return previousAttack;
    }

    public void tryNotifyPokemon() {
        if (this.pokemon != null) {
            this.pokemon.markDirty(EnumUpdateType.Moveset);
        }
    }

    public void swap(int index, int index2) {
        Attack a = this.attacks[index];
        this.attacks[index] = this.attacks[index2];
        this.attacks[index2] = a;
        this.tryNotifyPokemon();
    }

    @Override
    public Attack remove(int index) {
        Attack a = this.get(index);
        int oldSize = this.size();
        for (int i = index + 1; i < this.size(); ++i) {
            this.set(i - 1, this.get(i));
        }
        this.set(oldSize - 1, null);
        return a;
    }

    @Override
    public boolean removeIf(Predicate<? super Attack> predicate) {
        for (int i = 0; i < this.attacks.length; ++i) {
            if (!predicate.test(this.attacks[i])) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Attack)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.attacks[i] != o) continue;
            this.set(i, null);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.attacks[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (this.isEmpty()) {
            return false;
        }
        if (o instanceof Attack) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.attacks[i].equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.attacks = new Attack[4];
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.size(); ++i) {
            Attack attack = this.get(i);
            if (attack == null || attack.getActualMove() == null || attack.getActualMove().getAttackId() == -1) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74777_a("MoveID", (short)attack.getActualMove().getAttackId());
            compound.func_74774_a("MovePP", (byte)attack.pp);
            if (attack.ppLevel != 0) {
                compound.func_74774_a("MovePPLevel", (byte)attack.ppLevel);
            }
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74782_a("Moveset", (NBTBase)list);
        NBTTagList relearn = new NBTTagList();
        this.reminderMoves.forEach(ab -> relearn.func_74742_a((NBTBase)new NBTTagInt(ab.getAttackId())));
        nbt.func_74782_a("RelrnMoves", (NBTBase)relearn);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list;
        this.clear();
        if (nbt.func_74764_b("Moveset")) {
            list = nbt.func_150295_c("Moveset", 10);
            for (NBTBase base : list) {
                NBTTagCompound compound = (NBTTagCompound)base;
                short moveID = compound.func_74765_d("MoveID");
                short movePP = compound.func_74765_d("MovePP");
                short movePPLevel = compound.func_74765_d("MovePPLevel");
                Attack attack = new Attack(moveID);
                if (moveID == -1 || attack.getActualMove() == null) continue;
                attack.pp = movePP;
                attack.ppLevel = movePPLevel;
                this.add(attack);
            }
        } else if (nbt.func_74764_b("PixelmonNumberMoves")) {
            int numMoves = nbt.func_74771_c("PixelmonNumberMoves");
            for (int i = 0; i < numMoves; ++i) {
                Attack a = null;
                if (!nbt.func_74764_b("PixelmonMoveID" + i) && nbt.func_74764_b("PixelmonMoveName" + i)) {
                    a = new Attack(nbt.func_74779_i("PixelmonMoveName" + i));
                    if (a.getActualMove() == null) {
                        a = null;
                    }
                } else {
                    short id = nbt.func_74765_d("PixelmonMoveID" + i);
                    if (id != -1 && (a = new Attack(id)).getActualMove() == null) {
                        a = null;
                    }
                }
                if (a == null) continue;
                if (nbt.func_74764_b("PixelmonMovePP" + i)) {
                    a.pp = nbt.func_74771_c("PixelmonMovePP" + i);
                }
                if (nbt.func_74764_b("PixelmonMovePPBase" + i)) {
                    // empty if block
                }
                this.add(a);
            }
        }
        this.reminderMoves.clear();
        if (nbt.func_74764_b("RelrnMoves")) {
            list = nbt.func_150295_c("Moveset", 3);
            for (NBTBase base : list) {
                NBTTagInt id = (NBTTagInt)base;
                AttackBase.getAttackBase(id.func_150287_d()).ifPresent(this.reminderMoves::add);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.clear();
        int numberOfMoves = buf.readByte();
        for (int j = 0; j < numberOfMoves; ++j) {
            Attack attack = new Attack(buf.readShort());
            attack.pp = buf.readByte();
            attack.ppLevel = buf.readByte();
            attack.overridePPMax(buf.readByte());
            attack.setDisabled(buf.readBoolean(), null);
            this.attacks[j] = attack;
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.size());
        for (Attack a : this) {
            if (a == null) continue;
            buf.writeShort(a.getActualMove().getAttackId());
            buf.writeByte(a.pp);
            buf.writeByte(a.ppLevel);
            buf.writeByte(a.getOverriddenPPMax() == null ? -1 : a.getOverriddenPPMax());
            buf.writeBoolean(a.getDisabled());
        }
    }

    public boolean hasAttack(Attack a) {
        for (Attack attack : this.attacks) {
            if (attack == null || attack.getActualMove().getAttackId() != a.getActualMove().getAttackId()) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttack(String ... attackNames) {
        for (Attack attack : this.attacks) {
            if (attack == null || !attack.isAttack(attackNames)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttack(AttackBase ... moves) {
        for (Attack attack : this.attacks) {
            for (AttackBase base : moves) {
                if (attack == null || attack.getActualMove() != base) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAttackCategory(AttackCategory attackCategory) {
        for (Attack attack : this.attacks) {
            if (attack == null || attack.getActualMove().getAttackCategory() != attackCategory) continue;
            return true;
        }
        return false;
    }

    public boolean hasOffensiveAttackType(EnumType ... types) {
        for (Attack attack : this.attacks) {
            for (EnumType type : types) {
                if (attack == null || attack.getActualMove().getAttackCategory() == AttackCategory.STATUS || attack.getType() != type) continue;
                return true;
            }
        }
        return false;
    }

    public boolean removeAttack(String attackName) {
        for (int i = 0; i < this.attacks.length; ++i) {
            Attack attack = this.attacks[i];
            if (attack == null || !attack.isAttack(attackName)) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    public void replaceWith(ArrayList<Integer> attackIds) {
        this.clear();
        for (Integer attackIndex : attackIds) {
            this.add(new Attack(attackIndex));
        }
    }

    public boolean hasFullPP() {
        for (int i = 0; i < this.size(); ++i) {
            Attack a = this.attacks[i];
            if (a == null || a.pp >= a.getMaxPP()) continue;
            return false;
        }
        return true;
    }

    public Moveset copy() {
        Attack[] attacks = new Attack[this.attacks.length];
        for (int i = 0; i < this.attacks.length; ++i) {
            if (this.attacks[i] == null) continue;
            attacks[i] = this.attacks[i].copy();
        }
        return new Moveset(attacks);
    }

    public boolean replaceMove(String oldMove, Attack newMove) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.attacks[i] == null || !this.attacks[i].isAttack(oldMove)) continue;
            this.attacks[i] = newMove;
            this.tryNotifyPokemon();
            return true;
        }
        return false;
    }

    public void healAllPP() {
        for (int i = 0; i < this.size(); ++i) {
            Attack attack = this.attacks[i];
            if (attack == null) continue;
            attack.pp = attack.getMaxPP();
        }
        this.tryNotifyPokemon();
    }

    public List<AttackBase> getReminderMoves() {
        return this.reminderMoves;
    }

    public static Moveset loadMoveset(PokemonLink pokemon) {
        return pokemon.getBaseStats().loadMoveset(pokemon.getLevel());
    }
}

