/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pixelmon.stats;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.util.ITranslatable;

public enum StatsType implements ITranslatable
{
    None,
    HP,
    Attack,
    Defence,
    SpecialAttack,
    SpecialDefence,
    Speed,
    Accuracy,
    Evasion;

    private static final StatsType[] STATS;

    public static boolean isStatsEffect(String effectTypeString) {
        for (StatsType t : StatsType.values()) {
            if (!effectTypeString.equalsIgnoreCase(t.toString())) continue;
            return true;
        }
        return false;
    }

    public static StatsType getStatsEffect(String effectTypeString) {
        for (StatsType t : StatsType.values()) {
            if (!effectTypeString.equalsIgnoreCase(t.toString())) continue;
            return t;
        }
        return null;
    }

    public int getStatIndex() {
        switch (this) {
            case Accuracy: {
                return 0;
            }
            case Evasion: {
                return 1;
            }
            case Attack: {
                return 2;
            }
            case Defence: {
                return 3;
            }
            case SpecialAttack: {
                return 4;
            }
            case SpecialDefence: {
                return 5;
            }
            case Speed: {
                return 6;
            }
        }
        return -1;
    }

    @Override
    public String getUnlocalizedName() {
        if (this == None) {
            return "";
        }
        return "enum.stat." + this.name().toLowerCase();
    }

    public static StatsType[] getStatValues() {
        return STATS;
    }

    public static StatsType getRandomBattleMutableStat() {
        return STATS[RandomHelper.getRandomNumberBetween(1, 5)];
    }

    static {
        STATS = new StatsType[]{HP, Attack, Defence, SpecialAttack, SpecialDefence, Speed};
    }
}

