/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.entities.pokeballs.captures;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.entities.pokeballs.EnumPokeBallMode;
import com.pixelmonmod.pixelmon.entities.pokeballs.captures.CaptureBase;
import com.pixelmonmod.pixelmon.enums.items.EnumPokeballs;
import net.minecraft.entity.player.EntityPlayer;

public class CaptureLevelBall
extends CaptureBase {
    public CaptureLevelBall() {
        super(EnumPokeballs.LevelBall);
    }

    @Override
    public double getBallBonus(EnumPokeballs type, EntityPlayer thrower, Pokemon p2, EnumPokeBallMode mode) {
        double ballBonus = this.pokeball.getBallBonus();
        if (mode == EnumPokeBallMode.battle) {
            BattleControllerBase bc = BattleRegistry.getBattle(thrower);
            if (bc == null) {
                return ballBonus;
            }
            int ownerPokemonLevel = 0;
            for (BattleParticipant p : bc.participants) {
                if (p.getEntity() != thrower) continue;
                for (PixelmonWrapper pw : p.controlledPokemon) {
                    ownerPokemonLevel = Math.max(ownerPokemonLevel, pw.getLevelNum());
                }
            }
            int targetLevel = p2.getLevel();
            if (ownerPokemonLevel > 4 * targetLevel) {
                ballBonus = 8.0;
            } else if (ownerPokemonLevel > 2 * targetLevel) {
                ballBonus = 4.0;
            } else if (ownerPokemonLevel > targetLevel) {
                ballBonus = 2.0;
            }
        }
        return ballBonus;
    }
}

