/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import java.awt.Color;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;

public enum EnumBossMode {
    NotBoss(0, -1, new Color(255, 255, 255), 1.0f, 0),
    Common(1, 50, new Color(192, 192, 192), 1.2f, 5),
    Uncommon(2, 40, new Color(0, 212, 63), 1.4f, 10),
    Rare(3, 30, new Color(0, 110, 255), 1.6f, 20),
    Epic(4, 20, new Color(159, 0, 217), 1.8f, 30),
    Legendary(5, 10, new Color(255, 162, 0), 2.0f, 40),
    Ultimate(6, 1, new Color(0, 255, 255), 2.2f, 50),
    Spooky(7, -1, new Color(194, 129, 199), 1.0f, 25),
    Drowned(8, -1, new Color(103, 201, 164), 2.5f, 100),
    Equal(9, -1, Color.WHITE, 1.0f, 0);

    public int index;
    public int rarity;
    public Color colour;
    public float scaleFactor;
    private int extraLevels;
    public float r;
    public float g;
    public float b;

    private EnumBossMode(int index, int rarity, Color colour, float scaleFactor, int extraLevels) {
        this.index = index;
        this.rarity = rarity;
        this.colour = colour;
        this.scaleFactor = scaleFactor;
        this.extraLevels = extraLevels;
        this.r = (float)colour.getRed() / 255.0f;
        this.g = (float)colour.getGreen() / 255.0f;
        this.b = (float)colour.getBlue() / 255.0f;
    }

    public static EnumBossMode getMode(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index >= EnumBossMode.values().length) {
            index = Legendary.ordinal();
        }
        try {
            return EnumBossMode.values()[index];
        }
        catch (IndexOutOfBoundsException e) {
            return NotBoss;
        }
    }

    public static EnumBossMode getFromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("BossMode")) {
            return EnumBossMode.getMode(compound.func_74762_e("BossMode"));
        }
        return NotBoss;
    }

    public static EnumBossMode getRandomMode() {
        int val = RandomHelper.rand.nextInt(100);
        int total = 0;
        for (EnumBossMode b : EnumBossMode.values()) {
            if (b.rarity == -1 || val > (total += b.rarity)) continue;
            return b;
        }
        return Rare;
    }

    public static EnumBossMode getRandomModeMega() {
        return EnumBossMode.values()[RandomHelper.rand.nextInt(3) + 4];
    }

    public boolean isMega() {
        return this.ordinal() >= 4 && this.ordinal() <= 6;
    }

    public int getColourInt() {
        return this.colour.getRGB();
    }

    public static EnumBossMode getNextMode(EnumBossMode bossMode) {
        int index = bossMode.ordinal();
        index = index == EnumBossMode.NotBoss.index ? EnumBossMode.Equal.index : (index == EnumBossMode.Equal.index ? EnumBossMode.Uncommon.index : (index == EnumBossMode.Ultimate.index ? EnumBossMode.NotBoss.index : ++index));
        return EnumBossMode.getMode(index);
    }

    public static boolean hasBossMode(String name) {
        for (EnumBossMode mode : EnumBossMode.values()) {
            if (!mode.name().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public static EnumBossMode getBossMode(String name) {
        for (EnumBossMode mode : EnumBossMode.values()) {
            if (!mode.name().equalsIgnoreCase(name)) continue;
            return mode;
        }
        return null;
    }

    public static EnumBossMode getWeightedBossMode() {
        List<Integer> weights = PixelmonConfig.bossWeights;
        if (weights == null) {
            return null;
        }
        int totalWeight = 0;
        for (Integer weight : weights) {
            totalWeight += weight.intValue();
        }
        int value = RandomHelper.rand.nextInt(totalWeight) + 1;
        int runningWeights = 0;
        int i = 0;
        for (Integer weight : weights) {
            if ((runningWeights += weight.intValue()) >= value) {
                if (i > 6) {
                    i = 5;
                }
                return EnumBossMode.values()[i + 1];
            }
            ++i;
        }
        return null;
    }

    public int getExtraLevels() {
        if (this == Equal || this == NotBoss) {
            return this.extraLevels;
        }
        List<Integer> levels = PixelmonConfig.bossLevelIncreases;
        int ordinal = this.index - 1;
        return levels.size() > ordinal ? levels.get(ordinal) : this.extraLevels;
    }

    public float getCandyChance() {
        if (this.index > 0 && this.index < 7) {
            int index = this.index - 1;
            if (PixelmonConfig.bossCandyChances.size() > index) {
                return PixelmonConfig.bossCandyChances.get(index).floatValue();
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public String getBossText() {
        return I18n.func_74838_a((String)("enum.trainerBoss." + this.toString().toLowerCase()));
    }

    public boolean isBossPokemon() {
        return this.extraLevels > 0;
    }

    public boolean isMegaBossPokemon() {
        return this.isBossPokemon() && this.isMega();
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)("enum.trainerBoss." + this.name().toLowerCase()));
    }
}

