/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;

public enum EnumEggGroup {
    Monster(0),
    Bug(1),
    Flying(2),
    Field(3),
    Fairy(4),
    Grass(5),
    Humanlike(6),
    Mineral(7),
    Amorphous(8),
    Ditto(9),
    Dragon(10),
    Water1(11),
    Water2(12),
    Water3(13),
    Undiscovered(14);

    public int index;
    private static final EnumEggGroup[] VALUES;

    private EnumEggGroup(int index) {
        this.index = index;
    }

    public static EnumEggGroup getEggGroupFromIndex(int index) {
        for (EnumEggGroup n : EnumEggGroup.values()) {
            if (n.index != index) continue;
            return n;
        }
        return null;
    }

    public static Integer getIndexFromEggGroup(EnumEggGroup group) {
        return group.index;
    }

    public static Integer getIndexFromEggGroupName(String groupName) {
        return EnumEggGroup.hasEggGroup(groupName) ? EnumEggGroup.getEggGroupFromString((String)groupName).index : -1;
    }

    public Integer getIndex() {
        return this.index;
    }

    public static EnumEggGroup getRandomEggGroup() {
        int rndm = RandomHelper.getRandomNumberBetween(0, 14);
        return EnumEggGroup.getEggGroupFromIndex(rndm);
    }

    public static boolean hasEggGroup(String group) {
        for (EnumEggGroup n : VALUES) {
            if (!n.name().equalsIgnoreCase(group)) continue;
            return true;
        }
        return false;
    }

    public static EnumEggGroup getEggGroupFromString(String group) {
        for (EnumEggGroup n : VALUES) {
            if (!n.name().equalsIgnoreCase(group)) continue;
            return n;
        }
        return null;
    }

    public static EnumEggGroup[] getEggGroups(PokemonBase pokemon) {
        return pokemon.getBaseStats().getEggGroupsArray();
    }

    static {
        VALUES = EnumEggGroup.values();
    }
}

