/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.enums.forms;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.enums.forms.ICosmeticForm;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import javax.annotation.Nonnull;

public enum EnumAegislash implements IEnumForm,
ICosmeticForm
{
    SHIELD,
    BLADE,
    SHIELD_ALTER,
    BLADE_ALTER;


    @Override
    public String getFormSuffix() {
        return "-" + this.name().toLowerCase();
    }

    @Override
    public byte getForm() {
        return (byte)this.ordinal();
    }

    @Override
    public boolean isTemporary() {
        return this != SHIELD && this != SHIELD_ALTER;
    }

    @Override
    public IEnumForm getDefaultFromTemporary(Pokemon pokemon) {
        return pokemon.getFormEnum() == BLADE ? SHIELD : (pokemon.getFormEnum() == BLADE_ALTER ? SHIELD_ALTER : SHIELD);
    }

    @Override
    public IEnumForm getDefaultFromForm(IEnumForm form) {
        return SHIELD;
    }

    @Override
    public boolean isDefaultForm() {
        return this == SHIELD;
    }

    @Override
    public String getUnlocalizedName() {
        return "pixelmon.aegislash.form." + this.name().toLowerCase();
    }

    @Override
    public boolean isCosmetic() {
        return this != SHIELD && this != BLADE;
    }

    @Override
    @Nonnull
    public IEnumForm getBaseFromCosmetic(Pokemon pokemon) {
        return pokemon.getFormEnum() == SHIELD_ALTER ? SHIELD : (pokemon.getFormEnum() == BLADE_ALTER ? BLADE : pokemon.getFormEnum());
    }

    @Override
    public String getName() {
        return this.name();
    }
}

